/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import jxl.Cell;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

class JxlHeaderData {
    private String[] names;
    private int[] index;
    private int columnSize = 0;
    private boolean nameNoSet = true;
    private boolean useNumber = true;

    JxlHeaderData() {
    }

    void setUseNumber(boolean bl) {
        this.useNumber = bl;
    }

    boolean setColumns(String string) {
        if (string != null && string.length() > 0) {
            this.names = StringUtil.csv2Array((String)string);
            this.columnSize = this.names.length;
            this.index = new int[this.columnSize];
            int n = this.useNumber ? 1 : 0;
            for (int i = 0; i < this.columnSize; ++i) {
                this.index[i] = n++;
            }
            this.nameNoSet = false;
            return true;
        }
        return false;
    }

    boolean isSkip(Cell[] cellArray) {
        int n = cellArray.length;
        if (n == 0) {
            return true;
        }
        String string = cellArray[0].getContents();
        if (string != null && string.length() > 0) {
            if (this.nameNoSet) {
                if ("#Name".equalsIgnoreCase(string)) {
                    this.makeNames(cellArray);
                    this.nameNoSet = false;
                    return true;
                }
                if (string.charAt(0) == '#') {
                    return true;
                }
                String string2 = "#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002" + HybsSystem.CR + "\u53ef\u80fd\u6027\u3068\u3057\u3066\u3001\u30d5\u30a1\u30a4\u30eb\u304c\u3001\u30cd\u30a4\u30c6\u30a3\u30d6Excel\u3067\u306a\u3044\u4e8b\u304c\u8003\u3048\u3089\u308c\u307e\u3059\u3002" + HybsSystem.CR;
                throw new HybsSystemException(string2);
            }
            if (string.charAt(0) == '#') {
                return true;
            }
        }
        return this.nameNoSet;
    }

    private void makeNames(Cell[] cellArray) {
        int n;
        int n2 = cellArray.length;
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        for (int i = n = this.useNumber ? 1 : 0; i < n2; ++i) {
            String string = cellArray[i].getContents();
            if (string == null || string.length() <= 0) continue;
            stringArray[this.columnSize] = string;
            nArray[this.columnSize] = i;
            ++this.columnSize;
        }
        if (n2 == this.columnSize) {
            this.names = stringArray;
            this.index = nArray;
        } else {
            this.names = new String[this.columnSize];
            this.index = new int[this.columnSize];
            System.arraycopy(stringArray, 0, this.names, 0, this.columnSize);
            System.arraycopy(nArray, 0, this.index, 0, this.columnSize);
        }
    }

    String[] getNames() {
        return this.names;
    }

    int getColumnSize() {
        return this.columnSize;
    }

    String[] toArray(Cell[] cellArray) {
        if (this.nameNoSet) {
            String string = "#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002";
            throw new HybsSystemException(string);
        }
        int n = cellArray.length;
        String[] stringArray = new String[this.columnSize];
        for (int i = 0; i < this.columnSize; ++i) {
            int n2 = this.index[i];
            stringArray[i] = n2 < n ? cellArray[n2].getContents() : null;
        }
        return stringArray;
    }
}

