/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeSet;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class FileUpdateTag
extends CommonTagSupport {
    private static final String VERSION = "5.6.5.2 (2013/06/21)";
    private static final long serialVersionUID = 565220130621L;
    public static final String CMD_ENTRY = "ENTRY";
    private static final String COMMAND_LIST = "ENTRY";
    private static final String errMsgId = "h_errMsg";
    public static final String ACT_COPY = "COPY";
    public static final String ACT_MOVE = "MOVE";
    public static final String ACT_MODIFY = "MODIFY";
    public static final String ACT_DELETE = "DELETE";
    private static final String[] ACTION_LIST = new String[]{"COPY", "MOVE", "MODIFY", "DELETE"};
    private String action = null;
    private String targetDir = null;
    private boolean createDir = true;
    private String tableId = "h_tblmdl";
    private String command = "ENTRY";
    private boolean outMessage = true;
    private String displayMsg = "MSG0040";
    private boolean selectedAll = false;
    private boolean keepTimeStamp = false;
    private transient DBTableModel table = null;
    private transient ErrorMessage errMessage = null;
    private int executeCount = -1;
    private int errCode = 0;
    private long dyStart = 0L;

    @Override
    public int doEndTag() {
        CharSequence charSequence;
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        this.dyStart = System.currentTimeMillis();
        this.table = (DBTableModel)this.getObject(this.tableId);
        String string = "";
        if (this.table != null && this.table.getRowCount() > 0 && this.check(this.command, "ENTRY")) {
            this.startQueryTransaction(this.tableId);
            this.execute();
            charSequence = new StringBuilder(50);
            this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
            this.setRequestAttribute("DB.ERR_CODE", String.valueOf(this.errCode));
            String string2 = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource());
            if (string2 != null && string2.length() > 0) {
                ((StringBuilder)charSequence).append(string2);
                this.setSessionAttribute(errMsgId, this.errMessage);
            }
            string = ((StringBuilder)charSequence).toString();
            if (this.table != null && !this.commitTableObject(this.tableId, this.table)) {
                this.jspPrint("FileUpdateTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        }
        this.jspPrint(string);
        if (this.displayMsg != null && this.displayMsg.length() > 0) {
            charSequence = this.executeCount + this.getResource().getLabel(this.displayMsg);
            this.jspPrint((String)charSequence + HybsSystem.BR);
        }
        long l = System.currentTimeMillis() - this.dyStart;
        this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.command = "ENTRY";
        this.action = null;
        this.targetDir = null;
        this.createDir = true;
        this.outMessage = true;
        this.displayMsg = "MSG0040";
        this.selectedAll = false;
        this.keepTimeStamp = false;
        this.table = null;
        this.errMessage = null;
        this.executeCount = -1;
        this.errCode = 0;
        this.dyStart = 0L;
    }

    private void execute() {
        int[] nArray = this.getParameterRows();
        if (nArray.length > 0) {
            FromToFiles fromToFiles = new FromToFiles(this.table, this.targetDir, this.createDir);
            if (ACT_COPY.equalsIgnoreCase(this.action)) {
                this.actionCOPY(nArray, fromToFiles);
            } else if (ACT_MOVE.equalsIgnoreCase(this.action) || ACT_MODIFY.equalsIgnoreCase(this.action)) {
                this.actionMOVE(nArray, fromToFiles);
            } else if (ACT_DELETE.equalsIgnoreCase(this.action)) {
                this.actionDELETE(nArray, fromToFiles);
            }
        }
    }

    private void actionCOPY(int[] nArray, FromToFiles fromToFiles) {
        File file = null;
        File file2 = null;
        this.executeCount = 0;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            File[] fileArray = fromToFiles.makeFromToFile(nArray[i]);
            file = fileArray[0];
            file2 = fileArray[1];
            if (file.isFile() && !FileUtil.copy((File)file, (File)file2, (boolean)this.keepTimeStamp)) {
                String string = "\u30a2\u30af\u30b7\u30e7\u30f3=[" + this.action + "]\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + "From=[" + file + "],To=[" + file2 + "]" + HybsSystem.CR;
                throw new HybsSystemException(string);
            }
            ++this.executeCount;
        }
    }

    private void actionMOVE(int[] nArray, FromToFiles fromToFiles) {
        File file = null;
        File file2 = null;
        this.executeCount = 0;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            File[] fileArray = fromToFiles.makeFromToFile(nArray[i]);
            file = fileArray[0];
            file2 = fileArray[1];
            if (fromToFiles.lastParentEquals()) {
                if (!file.renameTo(file2)) {
                    String string = "\u30a2\u30af\u30b7\u30e7\u30f3=[" + this.action + "]\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + "\u540c\u4e00\u89aa\u30d5\u30a9\u30eb\u30c0\u306e\u305f\u3081\u3001RENAME\u51e6\u7406\u3092\u884c\u3063\u3066\u3044\u307e\u3059\u3002" + HybsSystem.CR + "From=[" + file + "],To=[" + file2 + "]" + HybsSystem.CR;
                    throw new HybsSystemException(string);
                }
            } else if (file.isFile()) {
                if (!FileUtil.copy((File)file, (File)file2, (boolean)this.keepTimeStamp)) {
                    String string = "\u30a2\u30af\u30b7\u30e7\u30f3=[" + this.action + "]\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + "\u79fb\u52d5\u524d\u306eCOPY\u51e6\u7406\u3092\u884c\u3063\u3066\u3044\u307e\u3057\u305f\u3002" + HybsSystem.CR + "From=[" + file + "],To=[" + file2 + "]" + HybsSystem.CR;
                    throw new HybsSystemException(string);
                }
                if (!file.delete()) {
                    String string = "\u30a2\u30af\u30b7\u30e7\u30f3=[" + this.action + "]\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + "\u79fb\u52d5\u5f8c\u306e\u30aa\u30ea\u30b8\u30ca\u30eb\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u51e6\u7406\u3092\u884c\u3063\u3066\u3044\u307e\u3057\u305f\u3002" + HybsSystem.CR + "From=[" + file + "],To=[" + file2 + "]" + HybsSystem.CR;
                    if (!file2.delete()) {
                        string = string + "toFile \u3082\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR;
                    }
                    throw new HybsSystemException(string);
                }
            }
            ++this.executeCount;
        }
    }

    private void actionDELETE(int[] nArray, FromToFiles fromToFiles) {
        File file = null;
        TreeSet<File> treeSet = new TreeSet<File>(new FileNameLengthComparator());
        this.executeCount = 0;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            file = fromToFiles.makeFromOnly(nArray[i]);
            if (file.isFile()) {
                if (!file.delete()) {
                    String string = "\u30a2\u30af\u30b7\u30e7\u30f3=[" + this.action + "]\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + "From=[" + file + "]" + HybsSystem.CR;
                    throw new HybsSystemException(string);
                }
            } else {
                treeSet.add(file);
            }
            ++this.executeCount;
        }
        for (File file2 : treeSet) {
            if (file2.delete()) continue;
            String string = "\u30a2\u30af\u30b7\u30e7\u30f3=[" + this.action + "]\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + "From(Dir)=[" + file2 + "]" + HybsSystem.CR;
            throw new HybsSystemException(string);
        }
    }

    @Override
    protected int[] getParameterRows() {
        int[] nArray;
        if (this.selectedAll) {
            int n = this.table.getRowCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            nArray = super.getParameterRows();
        }
        return nArray;
    }

    public void setAction(String string) {
        this.action = StringUtil.nval((String)this.getRequestParameter(string), (String)this.action);
        if (this.action != null && !this.check(this.action, ACTION_LIST)) {
            String string2 = "\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + HybsSystem.CR + "action=[" + this.action + "] " + HybsSystem.CR + StringUtil.array2csv((String[])ACTION_LIST);
            throw new HybsSystemException(string2);
        }
    }

    public void setTargetDir(String string) {
        this.targetDir = StringUtil.nval((String)this.getRequestParameter(string), (String)this.targetDir);
    }

    public void setCreateDir(String string) {
        this.createDir = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.createDir);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() >= 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setOutMessage(String string) {
        this.outMessage = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.outMessage);
    }

    public void setDisplayMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.displayMsg = string2;
        }
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setKeepTimeStamp(String string) {
        this.keepTimeStamp = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.keepTimeStamp);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("action", (Object)this.action).println("command", (Object)this.command).println("targetDir", (Object)this.targetDir).println("createDir", (Object)this.createDir).println("tableId", (Object)this.tableId).println("outMessage", (Object)this.outMessage).println("displayMsg", (Object)this.displayMsg).println("selectedAll", (Object)this.selectedAll).println("keepTimeStamp", (Object)this.keepTimeStamp).fixForm().toString();
    }

    private static final class FromToFiles {
        private final DBTableModel table;
        private final int PARENT;
        private final int NAME;
        private final int TO_PARENT;
        private final int TO_NAME;
        private final File toDir;
        private final boolean createDir;
        private boolean equalParent = false;

        public FromToFiles(DBTableModel dBTableModel, String string, boolean bl) {
            this.table = dBTableModel;
            this.createDir = bl;
            this.toDir = this.mkDirs(string, bl);
            this.PARENT = dBTableModel.getColumnNo("PARENT", false);
            this.NAME = dBTableModel.getColumnNo("NAME", false);
            this.TO_PARENT = dBTableModel.getColumnNo("TO_PARENT", false);
            this.TO_NAME = dBTableModel.getColumnNo("TO_NAME", false);
        }

        public File makeFromOnly(int n) {
            String[] stringArray = (String[])this.table.getValues(n);
            File file = this.mkDirs(stringArray[this.PARENT], this.createDir);
            return new File(file, stringArray[this.NAME]);
        }

        public File[] makeFromToFile(int n) {
            String[] stringArray = (String[])this.table.getValues(n);
            File file = this.mkDirs(stringArray[this.PARENT], this.createDir);
            File file2 = new File(file, stringArray[this.NAME]);
            File file3 = this.toDir;
            this.equalParent = false;
            if (file3 == null) {
                if (this.TO_PARENT >= 0 && StringUtil.nval((String)stringArray[this.TO_PARENT], null) != null) {
                    file3 = this.mkDirs(stringArray[this.TO_PARENT], this.createDir);
                } else {
                    file3 = file;
                    this.equalParent = true;
                }
            }
            File file4 = null;
            file4 = this.TO_NAME >= 0 && StringUtil.nval((String)stringArray[this.TO_NAME], null) != null ? new File(file3, stringArray[this.TO_NAME]) : new File(file3, stringArray[this.NAME]);
            return new File[]{file2, file4};
        }

        public boolean lastParentEquals() {
            return this.equalParent;
        }

        private File mkDirs(String string, boolean bl) {
            File file = null;
            if (string != null) {
                file = new File(string);
                if (file.exists()) {
                    if (file.isFile()) {
                        String string2 = "\u30bf\u30fc\u30b2\u30c3\u30c8\u306b\u3001\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002" + HybsSystem.CR + "\u30bf\u30fc\u30b2\u30c3\u30c8=[" + string + "]" + HybsSystem.CR;
                        throw new HybsSystemException(string2);
                    }
                } else {
                    if (!bl) {
                        String string3 = "\u30bf\u30fc\u30b2\u30c3\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 " + HybsSystem.CR + "\u30bf\u30fc\u30b2\u30c3\u30c8=[" + string + "]" + HybsSystem.CR;
                        throw new HybsSystemException(string3);
                    }
                    if (!file.mkdirs()) {
                        String string4 = "\u30bf\u30fc\u30b2\u30c3\u30c8\u3092\u81ea\u52d5\u4f5c\u6210\u4f7f\u7528\u3068\u3057\u307e\u3057\u305f\u304c\u3001\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + "\u30bf\u30fc\u30b2\u30c3\u30c8=[" + string + "]" + HybsSystem.CR;
                        throw new HybsSystemException(string4);
                    }
                }
            }
            return file;
        }
    }

    private static final class FileNameLengthComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 565220130621L;

        private FileNameLengthComparator() {
        }

        @Override
        public int compare(File file, File file2) {
            if (file == null || file2 == null) {
                String string = "\u5f15\u6570\u306eFile\u306bnull\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002file1=[" + file + "] , file2=[" + file2 + "]";
                throw new IllegalArgumentException(string);
            }
            int n = file.getAbsolutePath().length();
            int n2 = file2.getAbsolutePath().length();
            return n2 - n;
        }
    }
}

