/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* LPAD2 ( FUNCTION )                                                       */
/* Created : 2014/05/23 18:59:12                                            */
/****************************************************************************/
CREATE FUNCTION LPAD2 
FUNCTION LPAD2(
	XTEXT       IN VARCHAR2 ,
	XLEN        IN NUMBER   ,
	XVAL        IN VARCHAR2 := ' ' )
RETURN VARCHAR2
/**********************************************************************/
/* UTF-8対応 LPAD ファンクション                                      */
/*  LPAD2( XTEXT,XLEN,[XVAL] )                                        */
/*                                                                    */
/*	 XTEXT       IN VARCHAR2          文字列式                        */
/*	 XLEN        IN NUMBER            調整後の文字列長                */
/*	[XVAL        IN VARCHAR2 :=' ']   充填する文字列(デフォルト' ')   */
/*                                                                    */
/*	左側から文字列を充填します。                                      */
/*                                                                    */
/**********************************************************************/
AS
    TEMP	VARCHAR2(4000);
BEGIN
	IF LENGTHB(XTEXT) > XLEN THEN
		RETURN SUBSTRB( XTEXT,1,XLEN );
	ELSE
		TEMP := LPAD( XTEXT,XLEN,XVAL );
		RETURN SUBSTRB( TEMP,LENGTHB(TEMP)-XLEN+1, XLEN ) ;
	END IF;
END LPAD2;
/
