/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.CommentLineParser;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsDateUtil;

public class FileLineModel
extends LineModel {
    private static final String[] KEYS = new String[]{"Level", "File", "Length", "Modify", "LineCnt", "Biko", "MD5"};
    private static final int LEVEL = 0;
    private static final int FILE = 1;
    private static final int LENGTH = 2;
    private static final int MODIFY = 3;
    private static final int LINECNT = 4;
    private static final int BIKO = 5;
    private static final int MD5 = 6;
    private final boolean useLineCnt;
    private final boolean useMD5;
    private final boolean omitCmnt;
    private String encode = "JISAutoDetect";

    public FileLineModel() {
        this(false, false, false);
    }

    public FileLineModel(boolean bl) {
        this(bl, false, false);
    }

    public FileLineModel(boolean bl, boolean bl2) {
        this(bl, bl2, false);
    }

    public FileLineModel(boolean bl, boolean bl2, boolean bl3) {
        this.useLineCnt = bl;
        this.useMD5 = bl2;
        this.omitCmnt = bl3;
        this.init(KEYS);
    }

    public FileLineModel(LineModel lineModel) {
        this.init(lineModel.getNames());
        Object[] objectArray = lineModel.getValues();
        this.setValue(0, Integer.valueOf((String)objectArray[0]));
        this.setValue(1, new File((String)objectArray[1]));
        this.setValue(2, Long.valueOf((String)objectArray[2]));
        this.setValue(3, (String)objectArray[3]);
        String string = (String)objectArray[4];
        boolean bl = this.useLineCnt = string != null && string.length() > 0 && !"null".equalsIgnoreCase(string);
        if (this.useLineCnt) {
            this.setValue(4, string);
        }
        this.setValue(5, (String)objectArray[5]);
        String string2 = (String)objectArray[6];
        boolean bl2 = this.useMD5 = string2 != null && string2.length() > 0 && !"null".equalsIgnoreCase(string2);
        if (this.useMD5) {
            this.setValue(6, string2);
        }
        this.omitCmnt = false;
    }

    public void setFileVals(int n, File file) {
        this.setValue(0, n);
        this.setValue(1, file);
        this.setValue(3, HybsDateUtil.getDate(file.lastModified(), "yyyy/MM/dd HH:mm:ss"));
        if (this.useLineCnt || this.omitCmnt) {
            long[] lArray = this.getLineCnt(file);
            this.setValue(4, String.valueOf(lArray[0]));
            this.setValue(2, lArray[1]);
        } else {
            this.setValue(2, file.length());
        }
        if (this.useMD5 && file.isFile()) {
            this.setValue(6, HybsCryptography.getMD5(file));
        }
    }

    public void setEncode(String string) {
        this.encode = string;
    }

    public void setFile(File file) {
        this.setValue(1, file);
    }

    public void setBiko(String string) {
        this.setValue(5, string);
    }

    public int getLebel() {
        return (Integer)this.getValue(0);
    }

    public File getFile() {
        return (File)this.getValue(1);
    }

    public long getLength() {
        return (Long)this.getValue(2);
    }

    public String getModify() {
        return (String)this.getValue(3);
    }

    public String getMD5() {
        return (String)this.getValue(6);
    }

    private long[] getLineCnt(File file) {
        long l = 0L;
        long l2 = 0L;
        BufferedReader bufferedReader = FileUtil.getBufferedReader(file, this.encode);
        CommentLineParser commentLineParser = this.omitCmnt ? new CommentLineParser() : null;
        try {
            if (!file.isDirectory()) {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (this.omitCmnt && (string = commentLineParser.line(string)) == null) continue;
                    ++l;
                    l2 += (long)string.length();
                }
            }
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u30ab\u30a6\u30f3\u30c8\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + file + "]";
            throw new RuntimeException(string, iOException);
        }
        finally {
            Closer.ioClose(bufferedReader);
        }
        return new long[]{l, l2};
    }
}

