/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.HTMLTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class InputTag
extends HTMLTagSupport {
    private static final String VERSION = "5.7.1.0 (2013/12/06)";
    private static final long serialVersionUID = 571020131206L;
    private static final String CHECK_TYPE = "|text|password|checkbox|radio|submit|reset|button|image|file|hidden|search|tel|url|email|datetime|date|month|week|time|datetime-local|number|range|color|";
    private final String CLM = HybsSystem.sysBool("HTML_LABEL_SEPARATOR") ? ":" : "";
    private String td_flag = "yes";
    private String colspan = "";
    private String nextForm = null;
    private final int COLUMNS_MAXSIZE = HybsSystem.sysInt("HTML_COLUMNS_MAXSIZE");
    private String body = null;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        this.body = this.getBodyString();
        return 0;
    }

    @Override
    protected void release2() {
        super.release2();
        this.td_flag = "yes";
        this.colspan = "";
        this.nextForm = null;
    }

    @Override
    protected String makeTag() {
        String string;
        if (this.get("value") == null) {
            this.set("value", "");
        }
        if (this.getMsglbl() == null) {
            this.setLbl(this.get("name"));
        }
        if (this.nextForm != null) {
            string = "nextForm(this,'" + this.nextForm + "'," + this.get("maxlength") + ");";
            this.set("onKeyup", string);
        }
        string = this.get("type");
        StringBuilder stringBuilder = new StringBuilder(200);
        if ("yes".equals(this.td_flag)) {
            if (string != null && ("radio".equals(string) || "checkbox".equals(string))) {
                if (this.get("id") == null) {
                    this.set("id", TaglibUtil.getTagId());
                }
                stringBuilder.append("<td>");
                stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes()));
                if (this.body != null) {
                    stringBuilder.append(this.body);
                }
                stringBuilder.append("</td>");
                stringBuilder.append("<td ");
                stringBuilder.append(this.colspan);
                stringBuilder.append(">");
                stringBuilder.append("<label for=\"");
                stringBuilder.append(this.get("id"));
                stringBuilder.append("\">");
                stringBuilder.append(this.getLongLabel());
                stringBuilder.append("</label>");
            } else if (string != null && ("submit".equals(string) || "reset".equals(string) || "button".equals(string))) {
                this.set("value", this.getMsglbl());
                stringBuilder.append("<td");
                stringBuilder.append(this.colspan);
                stringBuilder.append(">");
                stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes()));
                if (this.body != null) {
                    stringBuilder.append(this.body);
                }
                stringBuilder.append("</td>");
                stringBuilder.append("<td>");
            } else {
                stringBuilder.append("<td class=\"label\">");
                stringBuilder.append(this.getLongLabel());
                stringBuilder.append(this.CLM);
                stringBuilder.append("</td>");
                stringBuilder.append("<td");
                stringBuilder.append(this.colspan);
                stringBuilder.append(">");
                stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes()));
                if (this.body != null) {
                    stringBuilder.append(this.body);
                }
            }
            if (this.getMustType() != null) {
                stringBuilder.append(this.makeMustHidden(this.get("name")));
            }
            stringBuilder.append("</td>");
        } else if ("no".equals(this.td_flag)) {
            if (string != null && ("radio".equals(string) || "checkbox".equals(string))) {
                stringBuilder.append("<label>");
                stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes()));
                if (this.body != null) {
                    stringBuilder.append(this.body);
                }
                stringBuilder.append("<span class=\"label\">");
                stringBuilder.append(this.getLongLabel());
                stringBuilder.append("</span>");
                stringBuilder.append("</label>");
            } else if (string != null && ("submit".equals(string) || "reset".equals(string) || "button".equals(string))) {
                this.set("value", this.getMsglbl());
                stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes()));
                if (this.body != null) {
                    stringBuilder.append(this.body);
                }
            } else {
                stringBuilder.append("<span class=\"label\">");
                stringBuilder.append(this.getLongLabel());
                stringBuilder.append(this.CLM);
                stringBuilder.append("</span>");
                stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes()));
                if (this.body != null) {
                    stringBuilder.append(this.body);
                }
            }
            if (this.getMustType() != null) {
                stringBuilder.append(this.makeMustHidden(this.get("name")));
            }
        } else {
            if (string != null && ("submit".equals(string) || "reset".equals(string) || "button".equals(string))) {
                this.set("value", this.getMsglbl());
                stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes()));
                if (this.body != null) {
                    stringBuilder.append(this.body);
                }
            } else {
                stringBuilder.append(XHTMLTag.input((Attributes)this.getAttributes()));
                if (this.body != null) {
                    stringBuilder.append(this.body);
                }
            }
            if (this.getMustType() != null) {
                stringBuilder.append(this.makeMustHidden(this.get("name")));
            }
        }
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.set("name", this.getRequestParameter(string));
    }

    public void setType(String string) {
        String string2 = this.getRequestParameter(string);
        if (!this.check("|" + string2 + "|", CHECK_TYPE)) {
            String string3 = "type \u5c5e\u6027\u306f\u3001\u4e0b\u8a18\u306e\u4e2d\u304b\u3089\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002type=[" + string2 + "  in [" + CHECK_TYPE + "]";
            throw new HybsSystemException(string3);
        }
        this.set("type", string2);
    }

    public void setValue(String string) {
        this.set("value", this.getRequestParameter(string));
    }

    public void setSize(String string) {
        this.set("size", this.getRequestParameter(string));
    }

    public void setMaxlength(String string) {
        int n;
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.set("maxlength", string2);
        if (this.get("size") == null && string2 != null) {
            n = Integer.parseInt(string2);
            if (n > this.COLUMNS_MAXSIZE) {
                n = this.COLUMNS_MAXSIZE;
            }
            this.set("size", String.valueOf(n));
        }
        if (string2 != null && string2.length() == 1 && (n = (int)string2.charAt(0)) >= 49 && n <= 53) {
            this.add("class", "S0" + (char)n);
        }
    }

    public void setChecked(String string) {
        String string2 = this.getRequestParameter(string);
        if ("checked".equals(string2)) {
            this.set("checked", "checked");
        }
    }

    public void setSrc(String string) {
        this.set("src", this.getRequestParameter(string));
    }

    public void setAlt(String string) {
        this.set("alt", this.getRequestParameter(string));
    }

    public void setAccept(String string) {
        this.set("accept", this.getRequestParameter(string));
    }

    public void setUsemap(String string) {
        this.set("usemap", this.getRequestParameter(string));
    }

    public void setIsmap(String string) {
        this.set("ismap", this.getRequestParameter(string));
    }

    public void setTd(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.td_flag);
        if (!this.check("|" + string2 + "|", "|yes|no|false|")) {
            String string3 = "td \u5c5e\u6027\u306f\u3001\u4e0b\u8a18\u306e\u4e2d\u304b\u3089\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002td=[" + string2 + "  in [|true|false|label|]";
            throw new HybsSystemException(string3);
        }
        this.td_flag = string2;
    }

    public void setLbls(String string) {
        String[] stringArray = this.getCSVParameter(string);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getLabel(stringArray[0]));
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(this.getLabel(stringArray[i]));
        }
        this.setLbl(stringBuilder.toString());
    }

    public void setColspan(String string) {
        this.colspan = StringUtil.nval((String)this.getRequestParameter(string), (String)this.colspan);
        if (this.colspan.length() > 0) {
            this.colspan = " colspan=\"" + this.colspan + "\" ";
        }
    }

    public void setNextForm(String string) {
        this.nextForm = StringUtil.nval((String)this.getRequestParameter(string), (String)this.nextForm);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("td_flag", (Object)this.td_flag).println("colspan", (Object)this.colspan).println("nextForm", (Object)this.nextForm).println("CHECK_TYPE", (Object)CHECK_TYPE).println("HTML_LABEL_SEPARATOR", (Object)this.CLM).println("HTML_COLUMNS_MAXSIZE", (Object)this.COLUMNS_MAXSIZE).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

