/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.util.List;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.Layer;
import org.opengion.hayabusa.io.ChartCreate;
import org.opengion.hayabusa.io.ChartDataset;
import org.opengion.hayabusa.io.ChartFactory;
import org.opengion.hayabusa.io.ChartPlot;
import org.opengion.hayabusa.io.HybsURLGenerator;
import org.opengion.hayabusa.io.TypeRenderer;

public class ChartPlot_XYTime
implements ChartPlot {
    @Override
    public Plot getPlot(ChartCreate chartCreate) {
        XYPlot xYPlot = new XYPlot();
        DateAxis dateAxis = chartCreate.getDateAxis();
        xYPlot.setDomainAxis((ValueAxis)dateAxis);
        xYPlot.setOrientation(chartCreate.getPlotOrientation());
        xYPlot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        HybsURLGenerator hybsURLGenerator = chartCreate.getURLGenerator();
        boolean bl = chartCreate.isUseToolTip();
        List<ChartDataset> list = chartCreate.getDatasetList();
        for (int i = 0; i < list.size(); ++i) {
            ChartDataset chartDataset = list.get(i);
            String string = chartDataset.getChartType();
            TypeRenderer typeRenderer = ChartFactory.getTypeRenderer(string);
            XYItemRenderer xYItemRenderer = (XYItemRenderer)typeRenderer.getRenderer();
            xYPlot.setRenderer(i, xYItemRenderer, false);
            if (hybsURLGenerator != null) {
                xYItemRenderer.setURLGenerator((XYURLGenerator)hybsURLGenerator);
            }
            if (bl) {
                xYItemRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
            }
            NumberAxis numberAxis = chartDataset.makeNumberAxis();
            xYPlot.setRangeAxis(i, (ValueAxis)numberAxis, false);
            ValueMarker[] valueMarkerArray = chartDataset.getValueMarkers();
            for (int j = 0; j < valueMarkerArray.length; ++j) {
                xYPlot.addRangeMarker(i, (Marker)valueMarkerArray[j], Layer.FOREGROUND);
            }
            xYPlot.setDataset(i, (XYDataset)chartDataset.getDataset());
        }
        return xYPlot;
    }
}

