/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBCellFactory;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.db.DBType;
import org.opengion.hayabusa.db.DBTypeFactory;
import org.opengion.hayabusa.db.Selection;
import org.opengion.hayabusa.db.SelectionFactory;
import org.opengion.hayabusa.resource.CodeData;
import org.opengion.hayabusa.resource.ColumnData;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.resource.RoleMode;

public final class DBColumn {
    private final int COLUMNS_MAXSIZE = HybsSystem.sysInt("HTML_COLUMNS_MAXSIZE");
    private final ColumnData columnData;
    private final LabelData labelData;
    private final CodeData codeData;
    private final CellRenderer cellRenderer;
    private final CellEditor cellEditor;
    private final DBType dbType;
    private final String lang;
    private final boolean writable;
    private final String defValue;
    private final Attributes rendAttri;
    private final Attributes editAttri;
    private final boolean addNoValue;
    private final String dbid;
    private final boolean official;
    private final int checkLevel;
    private final Selection selection;
    private final String eventColumn;
    private final String rawEditParameter;
    private final String rawRendParameter;
    private final String eventURL;
    private final String useSLabel;
    private final String noDisplayVal;

    public DBColumn(String string, ColumnData columnData, LabelData labelData, CodeData codeData) {
        this.lang = string;
        this.columnData = columnData;
        this.labelData = labelData;
        this.codeData = codeData;
        this.writable = true;
        try {
            this.dbType = DBTypeFactory.newInstance(this.columnData.getDbType());
        }
        catch (RuntimeException runtimeException) {
            String string2 = "dbType \u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 name=[" + this.columnData.getName() + "]" + " dbType=[" + this.columnData.getDbType() + "] " + runtimeException.getMessage();
            throw new HybsSystemException(string2, runtimeException);
        }
        this.rendAttri = null;
        this.editAttri = null;
        this.addNoValue = false;
        this.official = true;
        this.checkLevel = -1;
        this.dbid = null;
        this.eventColumn = null;
        this.rawEditParameter = columnData.getEditorParam();
        this.rawRendParameter = columnData.getRendererParam();
        this.eventURL = null;
        this.useSLabel = "auto";
        this.noDisplayVal = null;
        String string3 = this.columnData.getDefault();
        this.defValue = string3 != null ? string3 : this.dbType.getDefault();
        this.selection = this.codeData == null ? null : SelectionFactory.newSelection("MENU", this.codeData);
        try {
            this.cellRenderer = DBCellFactory.newRenderer(this.columnData.getRenderer(), this);
            this.cellEditor = DBCellFactory.newEditor(this.columnData.getEditor(), this);
        }
        catch (RuntimeException runtimeException) {
            String string4 = "Renderer,Editor \u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 name=[" + this.columnData.getName() + "]" + " Renderer=[" + this.columnData.getRenderer() + "] " + " Editor=[" + this.columnData.getEditor() + "] " + runtimeException.getMessage();
            throw new HybsSystemException(string4, runtimeException);
        }
    }

    public DBColumn(DBColumnConfig dBColumnConfig) {
        String string;
        this.lang = dBColumnConfig.getLang();
        this.columnData = dBColumnConfig.getColumnData();
        this.labelData = dBColumnConfig.getLabelData();
        this.codeData = dBColumnConfig.getCodeData();
        this.writable = dBColumnConfig.isWritable();
        this.dbType = DBTypeFactory.newInstance(this.columnData.getDbType());
        this.rendAttri = dBColumnConfig.getRendererAttributes();
        this.editAttri = dBColumnConfig.getEditorAttributes();
        this.addNoValue = dBColumnConfig.isAddNoValue();
        this.official = dBColumnConfig.isOfficial();
        this.dbid = dBColumnConfig.getDbid();
        this.eventColumn = dBColumnConfig.getEventColumn();
        this.rawEditParameter = dBColumnConfig.getRawEditParameter();
        this.rawRendParameter = dBColumnConfig.getRawRendParameter();
        this.eventURL = dBColumnConfig.getEventURL();
        this.useSLabel = dBColumnConfig.getUseSLabel();
        this.noDisplayVal = dBColumnConfig.getNoDisplayVal();
        String string2 = HybsSystem.sys("DB_OFFICIAL_COLUMN_CHECK_LEVEL");
        this.checkLevel = !this.official && string2 != null && string2.length() > 0 ? Integer.parseInt(string2) : -1;
        String string3 = dBColumnConfig.getDefault();
        this.defValue = string3 != null ? string3 : this.dbType.getDefault();
        this.selection = this.codeData != null ? SelectionFactory.newSelection("MENU", this.codeData) : ((string = dBColumnConfig.getCodeKeyVal()) != null ? SelectionFactory.newSelection("KEYVAL", string) : null);
        this.cellRenderer = DBCellFactory.newRenderer(this.columnData.getRenderer(), this);
        this.cellEditor = DBCellFactory.newEditor(this.columnData.getEditor(), this);
    }

    public String getLang() {
        return this.lang;
    }

    public String getName() {
        return this.columnData.getName();
    }

    public String getLabel() {
        return this.labelData.getLabel();
    }

    public String getShortLabel() {
        return this.labelData.getShortLabel();
    }

    public String getLongLabel() {
        return this.labelData.getLongLabel();
    }

    public String getClassName() {
        return this.columnData.getClassName();
    }

    public int getTotalSize() {
        return this.columnData.getTotalSize();
    }

    public String getMaxlength() {
        return this.columnData.getMaxlength();
    }

    public int getSizeX() {
        return this.columnData.getSizeX();
    }

    public int getSizeY() {
        return this.columnData.getSizeY();
    }

    public String getViewLength() {
        return this.columnData.getViewLength();
    }

    public boolean isWritable() {
        return this.writable;
    }

    public String getRendererValue(String string) {
        return this.cellRenderer.getValue(string != null ? string : "");
    }

    public String getRendererValue(int n, String string) {
        return this.cellRenderer.getValue(n, string != null ? string : "");
    }

    public String getEditorValue(String string) {
        return this.cellEditor.getValue(string != null ? string : "");
    }

    public String getEditorValue(int n, String string) {
        return this.cellEditor.getValue(n, string != null ? string : "");
    }

    public String getWriterValue(String string, String string2) {
        return this.dbType.valueFill(string, this.columnData.getSizeX(), this.columnData.getSizeY(), string2);
    }

    public String getRenderer() {
        return this.columnData.getRenderer();
    }

    public String getEditor() {
        return this.columnData.getEditor();
    }

    public String getDbType() {
        return this.columnData.getDbType();
    }

    public NativeType getNativeType() {
        return this.dbType.getNativeType();
    }

    public String getDefault() {
        return this.defValue;
    }

    public String getRendererParam() {
        return this.columnData.getRendererParam();
    }

    public String getEditorParam() {
        return this.columnData.getEditorParam();
    }

    public String getDbTypeParam() {
        return this.columnData.getDbTypeParam();
    }

    public String getRoles() {
        return this.columnData.getRoles();
    }

    public RoleMode getRoleMode() {
        return this.columnData.getRoleMode();
    }

    public String getDbid() {
        return this.dbid;
    }

    public String valueAdd(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return this.dbType.valueAdd(string);
        }
        return this.dbType.valueAdd(string, string2);
    }

    public ErrorMessage valueCheck(String string) {
        return this.valueCheck(string, true);
    }

    public ErrorMessage valueCheck(String string, boolean bl) {
        String string2 = this.labelData.getLabel();
        if (string2.indexOf(60) >= 0) {
            string2 = string2.replaceAll("<[^>]*>", "");
        }
        ErrorMessage errorMessage = this.dbType.valueCheck(string2, string, this.columnData.getSizeX(), this.columnData.getSizeY(), this.columnData.getDbTypeParam(), bl);
        if (this.checkLevel >= 0) {
            errorMessage.addMessage(0, this.checkLevel, "ERR0034", new String[]{this.columnData.getName(), this.labelData.getLabel()});
        }
        return errorMessage;
    }

    public String valueSet(String string) {
        return this.dbType.valueSet(string);
    }

    public String valueAction(String string, String string2, String string3) {
        return this.dbType.valueAction(string, string2, string3);
    }

    public DBColumnConfig getConfig() {
        DBColumnConfig dBColumnConfig = new DBColumnConfig(this.lang, this.columnData.getName(), this.labelData, this.columnData.getClassName(), this.columnData.getMaxlength(), String.valueOf(this.writable), this.columnData.getRenderer(), this.columnData.getEditor(), this.codeData, this.columnData.getDbType(), this.defValue, this.columnData.getRendererParam(), this.columnData.getEditorParam(), this.columnData.getDbTypeParam(), this.columnData.getRoles(), this.official, this.dbid);
        dBColumnConfig.setViewLength(this.columnData.getViewLength());
        dBColumnConfig.setRendererAttributes(this.rendAttri);
        dBColumnConfig.setEditorAttributes(this.editAttri);
        dBColumnConfig.setAddNoValue(this.addNoValue);
        dBColumnConfig.setEventColumn(this.eventColumn);
        dBColumnConfig.setRawEditParameter(this.rawEditParameter);
        dBColumnConfig.setRawRendParameter(this.rawRendParameter);
        dBColumnConfig.setEventURL(this.eventURL);
        dBColumnConfig.setUseSLabel(this.useSLabel);
        dBColumnConfig.setNoDisplayVal(this.noDisplayVal);
        return dBColumnConfig;
    }

    public Attributes getRendererAttributes() {
        return this.rendAttri;
    }

    public Attributes getEditorAttributes() {
        return this.editAttri;
    }

    public boolean isAddNoValue() {
        return this.addNoValue;
    }

    public boolean isOfficial() {
        return this.official;
    }

    public LabelData getLabelData() {
        return this.labelData;
    }

    public CodeData getCodeData() {
        return this.codeData;
    }

    public int getFieldSize(int n, int n2) {
        int n3 = n;
        if (n3 <= 0 || n3 > n2) {
            n3 = n2;
        }
        return n3;
    }

    public int getFieldSize(int n) {
        return this.getFieldSize(n, this.COLUMNS_MAXSIZE);
    }

    public Selection getSelection() {
        if (this.selection == null) {
            String string = "clm=[" + this.getName() + "],label=[" + this.getLabel() + "]\u306e\u30b3\u30fc\u30c9\u30ea\u30bd\u30fc\u30b9\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            System.err.println("\u8b66\u544a\uff1a" + string);
            return SelectionFactory.newSelection("NULL", string);
        }
        return this.selection;
    }

    public String getEventColumn() {
        return this.eventColumn;
    }

    public String getRawEditParam() {
        return this.rawEditParameter;
    }

    public String getRawRendParam() {
        return this.rawRendParameter;
    }

    public String getEventURL() {
        return this.eventURL;
    }

    public String getEventColumnTag(String string, String string2, boolean bl) {
        return this.getEventColumnTag(string, string2, -1, bl);
    }

    public String getEventColumnTag(String string, String string2, int n, boolean bl) {
        TagBuffer tagBuffer = new TagBuffer("span");
        tagBuffer.add("class", "h_evElm");
        tagBuffer.add("h_evCid", this.columnData.getName() + (n < 0 ? "" : "__" + n));
        tagBuffer.add("h_evVal", string2);
        tagBuffer.add("h_evWrtbl", String.valueOf(bl));
        tagBuffer.setBody(string);
        return tagBuffer.makeTag();
    }

    public boolean isNeedsParamParse() {
        return this.rawRendParameter != null && this.rawRendParameter.indexOf("{@") >= 0 || this.rawEditParameter != null && this.rawEditParameter.indexOf("{@") >= 0;
    }

    public String getUseSLabel() {
        return this.useSLabel;
    }

    public String getNoDisplayVal() {
        return this.noDisplayVal;
    }
}

