/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.opengion.fukurou.process.HybsProcess;
import org.opengion.fukurou.process.LoggerProcess;
import org.opengion.fukurou.process.MainProcess;
import org.opengion.fukurou.process.Process_Logger;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class MainProcessTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0.0 (2006/09/31)";
    private static final long serialVersionUID = 400020060931L;
    public static final String CMD_NEW = "NEW";
    private List<HybsProcess> list = null;
    private String command = "NEW";
    private boolean isJspLog = false;
    private boolean isDisplay = false;
    private boolean useThread = false;
    private int delayTime = 0;
    private static final Set<String> lockSet = new HashSet<String>();
    private String urlKey = null;
    private boolean skipFlag = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doStartTag() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        this.urlKey = this.getUrlKey(httpServletRequest);
        Set<String> set = lockSet;
        synchronized (set) {
            boolean bl = lockSet.add(this.urlKey);
            this.skipFlag = !CMD_NEW.equalsIgnoreCase(this.command) || !bl && this.delayTime > 0;
        }
        if (this.skipFlag) {
            System.out.println("Skip Process : " + this.urlKey);
            return 0;
        }
        this.list = new ArrayList<HybsProcess>();
        return 2;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.skipFlag) {
            return 5;
        }
        if (this.isJspLog || this.isDisplay) {
            this.initLoggerProcess();
        }
        boolean bl = true;
        try {
            DelayedProcess delayedProcess = new DelayedProcess(this.delayTime, this.urlKey, this.list);
            if (this.useThread) {
                new Thread(delayedProcess).start();
            } else {
                delayedProcess.run();
            }
            int n = delayedProcess.getKekka();
            this.setRequestAttribute("DB.ERR_CODE", String.valueOf(n));
        }
        catch (Throwable throwable) {
            bl = false;
            LogWriter.log((Throwable)throwable);
            try {
                HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
                httpServletResponse.sendError(304, "ERROR:" + throwable.getMessage());
            }
            catch (IOException iOException) {
                LogWriter.log((Throwable)iOException);
            }
        }
        if (bl) {
            return 6;
        }
        return 5;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = CMD_NEW;
        this.isJspLog = false;
        this.isDisplay = false;
        this.useThread = false;
        this.delayTime = 0;
        this.list = null;
    }

    protected void addProcess(HybsProcess hybsProcess) {
        if (!this.list.isEmpty() && hybsProcess instanceof LoggerProcess) {
            String string = "LoggerProcess \u306f\u3001\u6700\u3082\u6700\u521d\u306b\u6307\u5b9a\u3057\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        this.list.add(hybsProcess);
    }

    public void setCommand(String string) {
        this.command = StringUtil.nval((String)this.getRequestParameter(string), (String)this.command);
    }

    public void setUseJspLog(String string) {
        this.isJspLog = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isJspLog);
    }

    public void setUseDisplay(String string) {
        this.isDisplay = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isDisplay);
    }

    public void setUseThread(String string) {
        this.useThread = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useThread);
    }

    public void setDelayTime(String string) {
        this.delayTime = StringUtil.nval((String)this.getRequestParameter(string), (int)this.delayTime);
    }

    private void initLoggerProcess() {
        LoggerProcess loggerProcess;
        HybsProcess hybsProcess = this.list.get(0);
        if (hybsProcess instanceof LoggerProcess) {
            loggerProcess = (LoggerProcess)hybsProcess;
        } else {
            loggerProcess = new Process_Logger();
            this.list.add(0, (HybsProcess)loggerProcess);
        }
        JspWriter jspWriter = this.pageContext.getOut();
        PrintWriter printWriter = FileUtil.getNonFlushPrintWriter((Writer)jspWriter);
        if (this.isJspLog) {
            loggerProcess.setLoggingWriter(printWriter);
        }
        if (this.isDisplay) {
            loggerProcess.setDisplayWriter(printWriter);
        }
    }

    private String getUrlKey(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        String string = httpServletRequest.getQueryString();
        if (string != null) {
            stringBuffer.append('?').append(string);
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("list", this.list).fixForm().toString();
    }

    private static final class DelayedProcess
    implements Runnable {
        private final int delayTime;
        private final String urlKey;
        private final List<HybsProcess> list;
        private int errCode = -1;

        public DelayedProcess(int n, String string, List<HybsProcess> list) {
            this.delayTime = n;
            this.urlKey = string;
            this.list = list;
        }

        public int getKekka() {
            return this.errCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.delayTime > 0) {
                try {
                    Thread.sleep((long)this.delayTime * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("InterruptedException:" + interruptedException.getMessage());
                }
            }
            Set set = lockSet;
            synchronized (set) {
                lockSet.remove(this.urlKey);
            }
            try {
                set = new MainProcess();
                set.setList(this.list);
                set.run();
                this.errCode = set.getKekka();
            }
            catch (Throwable throwable) {
                this.errCode = 2;
                LogWriter.log((Throwable)throwable);
            }
        }
    }
}

