/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* CUT ( FUNCTION )                                                         */
/* Created : 2013/10/17 14:33:53                                            */
/****************************************************************************/
CREATE OR REPLACE 
FUNCTION CUT(
	XTEXT       IN VARCHAR2 ,
	XPOS        IN NUMBER ,
	XLEN        IN NUMBER := 2147483647 )
RETURN VARCHAR2
/**********************************************************************/
/* 新帳票システム 文字列切り出しファンクション                        */
/*  CUT( XTEXT,XPOS,XLEN )                                            */
/*                                                                    */
/*	  XTEXT    IN VARCHAR2     入力文字列                             */
/*	  XPOS     IN NUMBER       切り出し開始位置                       */
/*	 [XLEN     IN NUMBER ]     切り出しバイト数 (初期値：最後まで)    */
/*                                                                    */
/*	入力文字列を、切り出し開始位置から切り出しバイト数分切り出します。*/
/*  切り出した文字列は、RTRIMされた形式（後ろのスペース削除）で、     */
/*  切り出されます。                                                  */
/*                                                                    */
/*  漢字コードがUTF-8の場合、２Byte目、３Byte目から切り出そうとした   */
/*  場合は、オラクルエラー (ORA-20000)を EXCEPTION します。           */
/*                                                                    */
/**********************************************************************/
AS
	-- 漢字コードの途中で分割しようとした場合はエラーとする。
	-- UTF8 の場合は、128 ～ 191 の範囲は第２、第３バイト
	-- JA16SJIS の場合は、129 ～ 159 および 224 ～ 239 の範囲は第１バイト、
	--                     64 ～ 126 および 128 ～ 252 の範囲は第２バイト、
--	TEXT_CUT_POSITION_ERROR		EXCEPTION ;
--	PRAGMA EXCEPTION_INIT(TEXT_CUT_POSITION_ERROR , -20000);
--	DUMP_STR	VARCHAR2(50);
--	TEMP_CD		NUMBER(5);
BEGIN
--	SELECT DUMP( XTEXT,1010, XPOS, 1 ) INTO DUMP_STR FROM DUAL;
--	TEMP_CD := TO_NUMBER(SUBSTR( DUMP_STR,INSTR( DUMP_STR,':',-1)+2 )) ;
--	IF( INSTR( DUMP_STR,'UTF8' ) > 0 AND
--		( 128 <= TEMP_CD AND TEMP_CD <= 191 )) THEN
--		RAISE_APPLICATION_ERROR (
--			NUM => -20000,
--			MSG => '漢字コードの途中で分割しようとしました。POSITION=' || TO_CHAR(XPOS) || ' , [' || DUMP_STR || ']');
--		RAISE TEXT_CUT_POSITION_ERROR;
--	END IF;

--	RETURN RTRIM(SUBSTRB( XTEXT,XPOS,XLEN )) ;
	RETURN RTRIM(SUBSTRB( XTEXT,XPOS,XLEN ),' 　') ;
END CUT;
/
