/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.taglet;

/**
 * 属性情報を管理する、AttKeySet クラスです。
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
class AttKeySet {
	private final String searchKey ;
	private final int    len ;
	private final String seq ;
	private final String valueName ;

	/**
	 * コンストラクター
	 *
	 * @param searchKey  String
	 * @param seq        int
	 * @param valueName  String
	 *
	 */
	AttKeySet( final String searchKey,final int seq,final String valueName ) {
		this.searchKey		= searchKey ;
		this.seq	        = String.valueOf( seq );
		this.valueName		= valueName ;

		len = searchKey.length();
	}

	/**
	 * シーケンス番号を返します。
	 *
	 * @return シーケンス番号
	 *
	 */
	String getSeq() {
		return seq;
	}

	/**
	 * 属性名を返します。
	 *
	 * @return 属性名
	 *
	 */
	String getValueName() {
		return valueName;
	}

	/**
	 * クラス名の先頭一致の場合の、**** 部分を返します。
	 * インターフェースも扱えるように修正しましたので、先頭が _ の場合は、
	 * _ を削除して返します。
	 *
	 * @param name クラスの名称（例：DBCellEditor_**** , ViewForm_****)
	 */
	String getAttKey( final String name ) {
		String rtn = null;		// 一致しなかった。

		if( name.equals( searchKey ) ) {	// 完全一致：インターフェース
			return "(Interface)" + name ;
		}

		int start = name.indexOf( searchKey );
		if( start == 0 ) {		// 先頭一致した。
			rtn = name.substring( len );
		}

		if( rtn != null && rtn.charAt(0) == '_' ) { return rtn.substring( 1 ); }
		return rtn ;
	}
}
