select 
  owner,
  segment_name,
  partition_name,
  AVG_ROW_LEN,
  NUM_ROWS,
  ROWS_PER_BLOCK,
  KB,
  EMPTY_KB,
  USED_KB,
  EST_KB
from 
 (
  select /*+ ORDERED */
    ds.owner,
    ds.segment_name,
    ' ' partition_name,  /* p[eBV݂͑Ȃ߁A_~[l' '擾 */
    ds.segment_type,
     /* avg_row_lennull̏ꍇ"*"A0̏ꍇ"?"AȊȌꍇavg_row_len̒l\ */
    lpad(decode(avg_row_len,null,'***',0,'?',avg_row_len),4) AVG_ROW_LEN,
     /* num_rowsnull̏ꍇ"*"A0̏ꍇ"?"AȊȌꍇnum_rows̒l\ */
    lpad(decode(num_rows,null,'***',num_rows),9) NUM_ROWS,
     /* ubNTCYI[owbhAPCT_FREEāAubNŎۂɎgp\TCY߂ */
    ceil((vp.db_block_size - KCBH - UB4 - KTBBH - (ini_trans - 1) * KTBIT - KDBH) * 
          (1 - pct_free / 100) - KDBT
         ) FREE_PER_BLOCK,
     /* 1sɉ͂邩߂邽߁Aŋ߂gp\̈avg_row_lenŊA_ȉ؂̂Ă */
    lpad(decode(avg_row_len,null,'***',0,'?',
            trunc((ceil((vp.db_block_size - KCBH - UB4 - KTBBH - (ini_trans - 1) * KTBIT - KDBH) * 
            (1 - pct_free / 100) - KDBT))/avg_row_len)),10
         ) ROWS_PER_BLOCK,
    ds.bytes/1024 KB,
    lpad(decode(dt.BLOCKS,null,'***',(dt.BLOCKS+1)*vp.db_block_size/1024),8) USED_KB,
     /* ubNɊi[\Ȍ߁Anum_rows̒lŊ邱ƂŁAKvȃubN߂B
        ̒lɃZOgEwb_[ƂāA1ubNǉ */
    lpad(decode(avg_row_len,null,'***',0,'?',
            ((ceil(num_rows/(trunc((ceil
             ((vp.db_block_size - KCBH - UB4 - KTBBH - (ini_trans - 1) * KTBIT - KDBH) * 
             (1 - pct_free / 100) - KDBT))/avg_row_len))))+1) * vp.db_block_size/1024),8) EST_KB,
    lpad(decode(EMPTY_BLOCKS,null,'***',EMPTY_BLOCKS*vp.db_block_size/1024),8) EMPTY_KB
  from 
    (select type_size KCBH from v$type_size where type = 'KCBH') ,
    (select type_size UB4 from v$type_size where type = 'UB4') ,
    (select type_size KTBBH from v$type_size where type = 'KTBBH') ,
    (select type_size KTBIT from v$type_size where type = 'KTBIT') ,
    (select type_size KDBH from v$type_size where type = 'KDBH') ,
    (select type_size KDBT from v$type_size where type = 'KDBT') ,
    (select value db_block_size from sys.v_$parameter where name = 'db_block_size') vp,
    sys.dba_tables   dt,
    sys.dba_segments ds
  where dt.owner like '%'
    and dt.table_name like  '%' 
    and dt.owner not in 
       ('SYS','SYSTEM','WMSYS','CTXSYS','MDSYS','ORDSYS','AURORA$JIS$UTILITY$','OUTLN','OSE$HTTP$ADMIN')
    and ds.segment_type = 'TABLE'
    and ds.owner = dt.owner
    and ds.segment_name = dt.table_name
  union all
  select /*+ ORDERED */
    ds.owner,
    ds.segment_name,
    ds.partition_name,
    ds.segment_type,
    lpad(decode(avg_row_len,null,'***',0,'?',avg_row_len),4) AVG_ROW_LEN,
    lpad(decode(num_rows,null,'***',num_rows),9) NUM_ROWS,
    ceil((vp.db_block_size - KCBH - UB4 - KTBBH - (ini_trans - 1) * KTBIT - KDBH) * 
         (1 - pct_free / 100) - KDBT
        ) FREE_PER_BLOCK,
    lpad(decode(avg_row_len,null,'***',0,'?',
           trunc((ceil((vp.db_block_size - KCBH - UB4 - KTBBH - (ini_trans - 1) * KTBIT - KDBH) * 
           (1 - pct_free / 100) - KDBT))/avg_row_len)),10
        ) ROWS_PER_BLOCK,
    ds.bytes/1024 KB,
    lpad(decode(dtp.BLOCKS,null,'***',(dtp.BLOCKS+1)*vp.db_block_size/1024),8) USED_KB,
    lpad(decode(avg_row_len,null,'***',0,'?',
           ((ceil(num_rows/(trunc((ceil
             ((vp.db_block_size - KCBH - UB4 - KTBBH - (ini_trans - 1) * KTBIT - KDBH) * 
             (1 - pct_free / 100) - KDBT))/avg_row_len))))+1) * vp.db_block_size/1024),8) EST_KB,
    lpad(decode(EMPTY_BLOCKS,null,'***',EMPTY_BLOCKS*vp.db_block_size/1024),8) EMPTY_KB
  from 
    (select type_size KCBH from v$type_size where type = 'KCBH') ,
    (select type_size UB4 from v$type_size where type = 'UB4') ,
    (select type_size KTBBH from v$type_size where type = 'KTBBH') ,
    (select type_size KTBIT from v$type_size where type = 'KTBIT') ,
    (select type_size KDBH from v$type_size where type = 'KDBH') ,
    (select type_size KDBT from v$type_size where type = 'KDBT') ,
    (select value db_block_size from sys.v_$parameter where name = 'db_block_size') vp,
    sys.dba_tab_partitions  dtp,
    sys.dba_segments         ds
  where dtp.table_owner like upper('&TAB_OWNER') 
    and dtp.table_name like  upper('&TAB_NAME') 
    and dtp.table_owner not in 
      ('SYS','SYSTEM','WMSYS','CTXSYS','MDSYS','ORDSYS','AURORA$JIS$UTILITY$','OUTLN','OSE$HTTP$ADMIN')
    and ds.segment_type = 'TABLE PARTITION'
    and ds.owner = dtp.table_owner
    and ds.segment_name = dtp.table_name
    and ds.partition_name = dtp.partition_name
)
order by 
  owner,
  KB,
  segment_name,
  partition_name
