<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useRealTimeCheck="false"/>
<og:localResource systemId="GE" initLoad="false" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "FAQRGST"
	title	= "標準(FAQ登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- entryタグのcommandとcolumnSetのコマンドが同じ場合のみ、動作します。 -->
<og:entry command = "{@command}" >
	<!-- 解説：CLMがNULLの場合は、メモリ上のCLM（検索条件）をセットします。 -->
	<!-- action には、DEFAULT,CLEAR,ADD,LOWER,UPPER,COPY,SET,NULLSET,TBLSET が指定できます。 -->
	<!-- 項目 -->
	<og:columnSet command="INSERT" columnId="SYSTEM_ID" action="SET" value="{@MEM.SYSTEM_ID}"/>
	<og:columnSet command="{@command}" columnId="QANO" action="SET" value="0"/>
</og:entry>
<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<form onSubmit="return oneClick();" method="POST" action="forward.jsp"  target="RESULT">
<!-- 登録、取消、リセットボタンを作成します。 -->
<!-- HTMLTextField(１点入力)使用時には、EXCEL(CSV)取り込みは使えません。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" keys="UPDFLG" vals="1"/>
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input   type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<!-- viewFormType="HTMLTextField" を使用する場合は、skip="true"が必要です。 -->
<og:view
	viewFormType = "HTMLTable"
	command      = "{@command}" 
	noDisplay    = "UNIQ,QANO,SYS_SEQNO"
	noWritable   = "{@noWritable}"
/>

<og:value command="SETTBL" key="SYSCODE"/>
	<og:hidden name="SYSCODE1" value="{@SYSCODE}"/>
<og:value command="SETTBL" key="CDBNRUI"/>
	<og:hidden name="CDBNRUI1" value="{@CDBNRUI}"/>
<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
