<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useRealTimeCheck="false"/>
<og:localResource systemId="GE" initLoad="false" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "WHTSNEW"
	title	= "標準(新着情報登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>
<!-- ﾌｧｲﾙﾊﾟｽ取得-->
<og:equals val1="INSERT|COPY" val2="{@command}" contains="true">
	<og:value command="SQL">
		SELECT	'whatsnew/'||'{@SYS.SYSTEM_ID}'||'/'||'{@USER.ID}'||TO_CHAR(SYSDATE,'YYYYMMDDHH24MISS')	REAL_PATH
		FROM	DUAL
	</og:value>
</og:equals>
<!-- entryタグのcommandとcolumnSetのコマンドが同じ場合のみ、動作します。 -->
<og:entry command = "{@command}" >
	<!-- 解説：CLMがNULLの場合は、メモリ上のCLM（検索条件）をセットします。 -->
	<!-- action には、DEFAULT,CLEAR,ADD,LOWER,UPPER,COPY,SET,NULLSET,TBLSET が指定できます。 -->
	<!-- 項目 -->
	<og:columnSet command="INSERT" columnId="SYSTEM_ID" action="SET" value="{@SYS.SYSTEM_ID}"/>		<!-- ｼｽﾃﾑID	-->
	<og:columnSet command="INSERT" columnId="SYSCODE" action="SET" value="{@SYSCODE}"/>				<!-- ｼｽﾃﾑｺｰﾄﾞ-->
	<og:columnSet command="INSERT" columnId="DYSTRD" action="SET" value="{@USER.YMD}"/>				<!-- 掲載開始日-->
	<og:columnSet command="INSERT" columnId="MAND" action="SET" value="{@USER.JNAME}"/>				<!-- 掲載者-->
	<og:columnSet command="INSERT" columnId="FILEPATH" action="SET" value="{@REAL_PATH}"/>			<!-- ﾌｧｲﾙﾊﾟｽ-->
	<og:columnSet command="COPY" columnId="DYSTRD" action="SET" value="{@USER.YMD}"/>				<!-- 掲載開始日-->
	<og:columnSet command="COPY" columnId="MAND" action="SET" value="{@USER.JNAME}"/>				<!-- 掲載者-->
	<og:columnSet command="COPY" columnId="FILEPATH" action="SET" value="{@REAL_PATH}"/>			<!-- ﾌｧｲﾙﾊﾟｽ-->
</og:entry>
<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<form name="frm" onSubmit="return oneClick();" method="POST" action="entry.jsp" enctype="multipart/form-data" target="RESULT">
<og:columnEditor columns="TITLE,DYSTRD,DYENDD" must="true"/>
<og:columnEditor columns="NAIYO" editor="TEXTAREA" style="width:500px;"/>
<og:columnEditor columns="DYENDD" editor="QUERY" eventColumn="DYSTRD" parameter="SELECT TO_CHAR(ADD_MONTHS('{@DYSTRD}',3),'YYYYMMDD') DYENDD FROM DUAL"/>
<!-- 登録、取消、リセットボタンを作成します。 -->
<!-- HTMLTextField(１点入力)使用時には、EXCEL(CSV)取り込みは使えません。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
<!--	<og:submit  value="reset"   lbl="RESET" accesskey="R" />	-->
		<og:input type="button" onClick="history.back()" lbl="RESET" />
		<og:input   type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<!-- viewFormType="HTMLTextField" を使用する場合は、skip="true"が必要です。 -->
<og:view
	viewFormType = "HTMLFormatTextField"			
	command      = "{@command}" 
	noDisplay    = "UNIQ"
	noWritable   = "{@noWritable}"
	skip         = "true"
>
<table>
	<tr>
		<td>[#CDDEG]</td><td>[$CDDEG]</td>					<!-- 重要度 -->
	</tr>
	<tr>
		<td>[#DYSTRD]</td><td>[$DYSTRD]</td>				<!-- 掲載開始日-->
		<td>[#DYENDD]</td><td>[$DYENDD]</td>				<!-- 掲載完了日-->
	</tr>
	<tr>
		<td>[#TITLE]</td><td>[$TITLE]</td>					<!-- ﾀｲﾄﾙ-->
	</tr>
	<tr>
		<td>[#NAIYO]</td><td colspan="3">[$NAIYO]</td>		<!-- 内容-->
	</tr>
	<tr>
		<td>[#MAND]</td><td>[$MAND]</td>					<!-- 掲載者-->
		<td>[#BUSHOD]</td><td>[$BUSHOD]</td>				<!-- 掲載部署-->
	</tr>
	<tr>
		<td>[#TEL]</td><td>[$TEL]</td>						<!-- 電話番号-->
		<td>[#MAILAD]</td><td>[$MAILAD]</td>				<!-- ﾒｰﾙ-->
	</tr>
	<tr>
		<td>[#FGJ]</td><td>[$FGJ]</td>						<!-- 状況-->
		<td>[#TAG]</td><td>[$TAG]</td>						<!-- ﾀｸﾞｷｰﾜｰﾄﾞ-->
	</tr>
</table>
	<og:fieldset lbl="FILE">
		<table>
			<tr>
				<td>[#FILE1]</td><td>[$FILE1]</td>				<!-- 添付1-->
				<td>[#FILE2]</td><td>[$FILE2]</td>				<!-- 添付2-->
				<td>[#FILE3]</td><td>[$FILE3]</td>				<!-- 添付3-->
			</tr>
		<og:equals val1="{@command}" val2="MODIFY">
			<tr>
				<td colspan="2">[$FILEB1]</td>					<!-- (変更前)ﾌｧｲﾙ1-->
				<td colspan="2">[$FILEB2]</td>					<!-- (変更前)ﾌｧｲﾙ2-->
				<td colspan="2">[$FILEB3]</td>					<!-- (変更前)ﾌｧｲﾙ3-->
			</tr>
		</og:equals>
		</table>
	</og:fieldset>

	<!-- ﾌｧｲﾙﾊﾟｽ取得(追加･複写) -->
	<og:equals val1="INSERT|COPY" val2="{@command}" contains="true">
		<og:userInfo key="USER.FILEPATH" command="SET" value="{@REAL_PATH}"/>
	</og:equals>
	<!-- ﾌｧｲﾙﾊﾟｽ取得(変更)-->
	<og:equals val1="{@command}" val2="MODIFY">
		<og:value command="SETTBL" key="FILEPATH"/>
		<og:userInfo key="USER.FILEPATH" command="SET" value="{@FILEPATH}"/>
	</og:equals>
<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
</og:view>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
