<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP04"
	title    = "振分条件マスタ"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここからです。 -->
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_OUT_FILE" value="OUTFILE" />
	<og:value command="SET" key="C_OUT_DIR" value="OUTDIR" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_OUT_FILE" value="OUT_FILE" />
	<og:value command="SET" key="C_OUT_DIR" value="OUT_DIR" />
</og:equals>

<!-- データが選ばれていなければエラー -->
<og:columnCheck minRowCount="1" command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- forward.jsp から command = "MODIFY" がセットされて遷移してくるので、変更画面となります。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" >
	<og:columnSet command="{@command}" columnId="RDC_CODE"  action="SET"     value="{@USER.RDC_CODE}" />
</og:entry>

<!-- メッセージ表示を行います。必ずリソースファイルに表示するメッセージを登録し、 -->
<!-- lbl属性を使用して表示させて下さい。 -->
<og:message lbl="MSG0046" comment="変更処理を行います。" /><br />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />

</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:view
	viewFormType   = "HTMLTable"
	command        = "{@command}"
	columnWritable = "FGRUN,PRTID,LANG,PRGDIR,PRGFILE,COMMENTS,DMN_GRP,DMN_TIME,OUT_DIR,OUT_FILE,RELEASE_NOTES"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
/>

<og:hidden name="names"
			value="FGRUN,PRTID,LANG,PRGDIR,PRGFILE,COMMENTS,DMN_GRP,DMN_TIME,FGJ,SYSTEM_ID,JOKEN" />
<og:hidden name="SQL" >
  <jsp:text>
	update GE53
	set
		FGRUN		= [FGRUN]	,
		PRTID		= [PRTID]	,
		LANG		= [LANG]	,
		PRGDIR		= [PRGDIR]	,
		PRGFILE		= [PRGFILE]	,
		COMMENTS	= [COMMENTS],
		DMN_GRP		= [DMN_GRP]	,
		DMN_TIME	= [DMN_TIME],
		{@C_OUT_DIR}	= [OUT_DIR],
		{@C_OUT_FILE}	= [OUT_FILE],
		RELEASE_NOTES	= [RELEASE_NOTES],
		FGJ			= [FGJ]		,
		RDC_CODE	= '{@USER.RDC_CODE}',
		DYUPD		= '{@USER.YMDH}' ,
		USRUPD		= '{@USER.ID}' ,
		PGUPD		= '{@GUI.KEY}'
	where 	SYSTEM_ID	= [SYSTEM_ID]
	and		JOKEN		= [JOKEN]
  </jsp:text>
</og:hidden>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
