/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.util;

import java.util.Date ;

/**
 * StopTimer は、指定の一定時間の間、実行を停止します。
 * 引数に、停止時間を秒単位で指定します。
 * 初期値は、５(秒)です。
 *
 * java org.opengion.fukurou.fukurou.util.StopTimer 5
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public final class StopTimer {

	/**
	 * すべてが staticメソッドなので、コンストラクタを呼び出さなくしておきます。
	 *
	 */
	private StopTimer() {}

	/**
	 * 処理を実行する main メソッドです。
	 *
	 * 引数には、処理を停止する 秒数 を入力します。
	 * -T を入力した場合は、処理開始時刻を表示します。
	 *
	 * 【Usage: java org.opengion.fukurou.fukurou.util.StopTimer 停止時間(秒) -T】
	 *
	 * @param   args String[]
	 */
	public static void main( final String[] args ) {
		long stopTime ;

		if( args.length >= 1 ) { stopTime = 1000L * Long.parseLong( args[0] ) ; }
		else {
			LogWriter.log("Usage: java org.opengion.fukurou.fukurou.util.StopTimer 停止時間(秒)");
			return;
		}

		if( args.length ==2 && "-T".equals( args[1] ) ) {
			System.out.println( new Date() );
		}

		try {
			Thread.sleep( stopTime );
		}
		catch( InterruptedException ex ) {
			LogWriter.log( "InterruptedException:" + ex.getMessage() );
		}
	}
}
