<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select a.*, '概要登録' gaiyo, '項目定義登録' koumoku from gfx01 a
	</jsp:text>
	<og:where>
		<og:and value = "GUIID    like '{@GUIID}'%"   />
		<og:and value = "GUINAME  like '{@GUINAME}'%" />
		<og:and value = "STYPE    like '{@STYPE}'%"   />
	</og:where>
	<og:appear
		startKey = "order by"
		value = "{@ORDER_BY}"
		defaultVal = "GUIID" />
</og:query>

<og:columnEditor columns="GUIID,GUINAME,STYPE" must="true" />

<og:viewLink command="{@command}">
	<og:link column="KOUMOKU" href="koumoku_index.jsp" target="RESULT"
		keys="command,GUIID"
		vals="NEW,[GUIID]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<og:writeCheck>
	<og:submit  value="update"   command="COPY"   lbl="COPY"    accesskey="C"
			keys="noWritable" vals="null" />
	<og:submit  value="update"   command="MODIFY" lbl="MODIFY"  accesskey="M" 
			keys="noWritable" vals="GUIID" />
	<og:submit  value="update"   command="DELETE" lbl="DELETE"  accesskey="D" 
			keys="columnWritable" vals="null" />
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
