<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9500"
	title	= "標準(SQL,PLSQL)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<og:bizLogic logics="gf.GF9540S"
	keys = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME,KBSAKU,ORDER_BY"
	vals = "{@SYSTEM_ID},{@LANG},{@CLM},{@NAME_JA},{@LABEL_NAME},{@KBSAKU},{@ORDER_BY}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!--<jsp:text>は不要です。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" quotCheck="false">
	{@RETURN}
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<!-- LinkTag で、画面遷移を行う場合は、gamenId属性を使用してください。-->
	<!-- LinkTag のuseGamenId属性 を "false" に設定すると、GAMENID,BACK_GAMENIDなどのリクエスト情報が付加されません。-->
	<!-- 項目 -->
	<og:link column="CLM" gamenId="GF9100" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,LANG,CLM,KBSAKU,IMAGE"
		vals="NEW,{@SYSTEM_ID},[LANG],[CLM],[KBSAKU],{@IMAGE}" />
</og:viewLink>

<!-- ColumnEditorTagを使用すると、カラム属性を設定しなおすことが出来ます。-->
<!-- 担当者の名称を表示します-->
<og:columnEditor column="CDTAN" editor="DBMENU" >
             SELECT USERID,NAME_JA FROM GF44 WHERE USERID = '$1' ORDER BY 1
</og:columnEditor>

<!-- EqualTagを使用すると、val1 と val2 の値を比較して、trueの場合のみ、BODY部を実行します。-->
<!-- nullCheck="true"で、val1 が NULL のとき trueになり、notEquals="true"で結果を反転します -->
<og:equals val1="{@IMAGE}" val2="true">
	<!-- ColumnEditorTagを使用すると、カラム属性を設定しなおすことが出来ます。-->
	<!-- 名称(漢字) -->
	<og:columnEditor column="NAME_JA" label="IMAGE_VIEW" />
	<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
	<og:viewMarker command="{@command}">
		<!-- 子要素の ColumnMarkerTag のBODY部と表示（レンデラー）を置き換えます。 -->
		<!-- onMark="true" または ="1" のときのみ、置き換えを行います。onMark=[カラム名] が使用できます。 -->
		<!-- 名称(漢字) -->
		<og:columnMarker column="NAME_JA" onMark="[ONMARK]" >
			<img src="../customImage/[CLM].jpg" alt="[CLM]" />
		</og:columnMarker>
  </og:viewMarker>
</og:equals>

<og:writeCheck>
	<og:popup gamenId="GF9110" href="index.jsp" target="CONTENTS" 
	 keys="SYSTEM_ID,LANG" vals="{@SYSTEM_ID},ja" style="width:100px;" lbl="GF9110"  />
<br />
</og:writeCheck>


<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	writable     = "false"
	noDisplay    = "ONMARK"/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
