/**************************************************************************/
/* GEA04 ( コード定義 )                                                   */
/*                                                                        */
/* Created : 2012/01/20 11:41:09                                          */
/**************************************************************************/
CREATE TABLE GEA04 (
   SYSTEM_ID     VARCHAR2(10)                 NOT NULL      /* 10  システムID       */
 , CLM           VARCHAR2(30)                 NOT NULL      /* 20  項目             */
 , CODE          VARCHAR2(30)                 NOT NULL      /* 30  コード           */
 , SEQNO         NUMBER(7)        DEFAULT 0   NOT NULL      /* 40  表示順           */
 , CDKH          VARCHAR2(1)                                /* 50  改廃コード       */
 , KBSAKU        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 60  作成区分         */
 , RELEASE_NOTES VARCHAR2(120)                              /* 70  リリースノート   */
 , RDC_CODE      VARCHAR2(20)                               /* 80  設変番号         */
 , CODEGRP       VARCHAR2(20)                               /* 90  コードグループ   */
 , COMMENTS      VARCHAR2(500)                              /* 100 コメント         */
 , CODELVL       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 110 階層             */
 , CODE_PARAM    VARCHAR2(200)                              /* 120 コードパラメータ */
 , ROLES         VARCHAR2(500)                              /* 130 ロールズ         */
 , UNIQ          NUMBER(9)        DEFAULT 0   NOT NULL      /* 140 ユニークキー     */
 , FGJ           VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 150 状態フラグ       */
 , DYSET         VARCHAR2(14)                               /* 160 登録日時         */
 , PGSET         VARCHAR2(10)                               /* 170 作成PG           */
 , PGPSET        VARCHAR2(10)                               /* 180 作成親PG         */
 , USRSET        VARCHAR2(10)                               /* 190 作成社員         */
 , DYUPD         VARCHAR2(14)                               /* 200 更新日時         */
 , PGUPD         VARCHAR2(10)                               /* 210 更新PG           */
 , PGPUPD        VARCHAR2(10)                               /* 220 更新親PG         */
 , USRUPD        VARCHAR2(10)                               /* 230 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GEA04S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA04T00 
BEFORE INSERT ON GEA04
FOR EACH ROW 
BEGIN 
SELECT GEA04S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

