/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.daemon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.transfer.TransferConfig;
import org.opengion.hayabusa.transfer.TransferExec;

public class Daemon_Transfer_CB01
extends HybsTimerTask {
    private static final String CLS_BASE = "org.opengion.hayabusa.transfer.TransferExec_";
    private static final String CB_SELECT = "SELECT B.READOBJ,B.READPRM,B.KBEXEC,B.EXECDBID,B.EXECOBJ,B.EXECPRM,A.HTCNO FROM CB01 A,GE62 B WHERE A.HCDD = SUBSTR(B.READOBJ,1,INSTR(B.READOBJ,' ',1,1)-1) AND A.HTO    = RPAD(SUBSTR(B.READOBJ,INSTR(B.READOBJ,' ',1,1)+1,INSTR(B.READOBJ,' ',1,2)-INSTR(B.READOBJ,' ',1,1)-1),8) AND A.HSYU   = RPAD(SUBSTR(B.READOBJ,INSTR(B.READOBJ,' ',1,2)+1),4) AND A.HCDJ = '1' AND B.FGJ = '1'";
    private static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool((String)"USE_DB_APPLICATION_INFO");
    private static final int LOOP_COUNTER = 24;
    private boolean running = true;
    private int loopCnt = 0;
    private String cbSelect = null;
    private String dmnName = null;
    private ApplicationInfo appInfo = null;
    private boolean debug = false;

    public void initDaemon() {
        this.debug = StringUtil.nval((String)this.getValue("DEBUG"), (boolean)this.debug);
        this.dmnName = this.getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CB_SELECT);
        String string = this.getValue("SYSTEM_ID");
        if (StringUtil.isNull((String)string)) {
            String string2 = "\u30b7\u30b9\u30c6\u30e0ID\u65b9\u6cd5\u306f\u5fc5\u9808\u6307\u5b9a\u3067\u3059\u3002";
            throw new HybsSystemException(string2);
        }
        stringBuilder.append(" AND B.SYSTEM_ID='").append(string).append("'");
        String string3 = this.getValue("KBREAD");
        if (StringUtil.isNull((String)string3)) {
            String string4 = "\u8aad\u53d6\u65b9\u6cd5\u306f\u5fc5\u9808\u6307\u5b9a\u3067\u3059\u3002";
            throw new HybsSystemException(string4);
        }
        stringBuilder.append(" AND B.KBREAD='").append(string3).append("'");
        String string5 = this.getValue("DMN_GRP");
        if (StringUtil.isNull((String)string5)) {
            String string6 = "\u30c7\u30fc\u30e2\u30f3\u30b0\u30eb\u30fc\u30d7\u306f\u5fc5\u9808\u6307\u5b9a\u3067\u3059\u3002";
            throw new HybsSystemException(string6);
        }
        stringBuilder.append(" AND B.DMN_GRP='").append(string5).append("'");
        stringBuilder.append(" ORDER BY A.HTC");
        this.cbSelect = stringBuilder.toString();
        if (this.debug) {
            System.out.println("DMN_NAME=[" + this.dmnName + "]");
            System.out.println("QUERY=[" + this.cbSelect + "]");
        }
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(string, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("TransferDaemon", this.dmnName, this.dmnName);
        } else {
            this.appInfo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDaemon() {
        String string;
        if (this.loopCnt % 24 == 0) {
            this.loopCnt = 1;
            System.out.println();
            System.out.print(this.toString() + " " + new Date() + " ");
        } else {
            System.out.print(".");
            ++this.loopCnt;
        }
        String[][] stringArray = null;
        CB01Data cB01Data = new CB01Data();
        try {
            stringArray = DBUtil.dbExecute((String)this.cbSelect, null, (ApplicationInfo)this.appInfo);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; this.running && i < stringArray.length; ++i) {
                    cB01Data.addData(stringArray[i]);
                }
            }
        }
        catch (Throwable throwable) {
            String string2 = "\u4f1d\u9001\u8aad\u53d6\u30a8\u30e9\u30fc\uff1aDMN_NAME=[" + this.dmnName + "] , DMN_HOST=[" + HybsSystem.HOST_NAME + "] , QUERY=[" + this.cbSelect + "]";
            string = string2 + HybsSystem.CR + StringUtil.stringStackTrace((Throwable)throwable);
            System.out.println(string);
            LogWriter.log((String)string);
            this.sendMail(string2, string);
        }
        for (String string2 : cB01Data.getTranSet()) {
            String[] stringArray2;
            string = null;
            TransferConfig transferConfig = null;
            String[] stringArray3 = null;
            boolean bl = true;
            try {
                string = new TransactionReal(this.appInfo);
                for (String string3 : cB01Data.getExecKeySet(string2)) {
                    transferConfig = cB01Data.getConfig(string3);
                    stringArray3 = cB01Data.getHtcno(string3);
                    if (this.debug) {
                        System.out.println();
                        System.out.print(" START = " + new Date());
                        System.out.print("[" + this.dmnName + "]:[" + StringUtil.array2csv((String[])stringArray3) + "]:[" + transferConfig.toString() + "]");
                    }
                    stringArray2 = this.read(stringArray3, (Transaction)string);
                    TransferExec transferExec = (TransferExec)StringUtil.newInstance((String)(CLS_BASE + transferConfig.getKbExec()));
                    transferExec.execute(stringArray2, transferConfig, (Transaction)string);
                    if (this.debug) {
                        System.out.println();
                        System.out.print(" END = " + new Date());
                        System.out.print("[" + this.dmnName + "]:[" + StringUtil.array2csv((String[])stringArray3) + "]:[" + transferConfig.toString() + "]");
                    }
                    if (!"NOUPDATE".equalsIgnoreCase(transferConfig.getReadPrm())) continue;
                    bl = false;
                }
                if (!bl) continue;
                this.complete(stringArray3, (Transaction)string);
            }
            catch (Throwable throwable) {
                String string3;
                if (string != null) {
                    string.rollback();
                    string.close();
                    string = null;
                }
                if (stringArray3 != null && stringArray3.length > 0) {
                    this.error(stringArray3);
                }
                string3 = "\u4f1d\u9001\u30a8\u30e9\u30fc\uff1aDMN_NAME=[" + this.dmnName + "] , DMN_HOST=[" + HybsSystem.HOST_NAME + "]";
                if (stringArray3 != null && stringArray3.length > 0) {
                    string3 = string3 + " , HTCNO=[" + StringUtil.array2csv((String[])stringArray3) + "]";
                }
                if (transferConfig != null) {
                    string3 = string3 + " , CONFIG=[" + transferConfig.toString() + "]";
                }
                stringArray2 = string3 + HybsSystem.CR + StringUtil.stringStackTrace((Throwable)throwable);
                System.out.println((String)stringArray2);
                LogWriter.log((String)stringArray2);
                this.sendMail(string3, (String)stringArray2);
            }
            finally {
                if (string == null) continue;
                string.close();
            }
        }
    }

    public boolean cancel() {
        this.running = false;
        return super.cancel();
    }

    private String[] read(String[] stringArray, Transaction transaction) {
        if (stringArray == null || stringArray.length == 0) {
            return new String[0];
        }
        String string = StringUtil.array2csv((String[])stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT A.HTEXT");
        stringBuilder.append(" FROM CB01 A");
        stringBuilder.append(" WHERE A.HCDJ = '5'");
        stringBuilder.append(" AND A.HTCNO IN (");
        stringBuilder.append(string);
        stringBuilder.append(") ORDER BY A.HTC, A.HTCNO");
        String[][] stringArray2 = DBUtil.dbExecute((String)stringBuilder.toString(), null, (Transaction)transaction);
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = stringArray2[i][0];
        }
        return stringArray3;
    }

    private void complete(String[] stringArray, Transaction transaction) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = StringUtil.array2csv((String[])stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE CB01 A");
        stringBuilder.append(" SET A.HCDJ = '2'");
        stringBuilder.append(" WHERE A.HCDJ = '1'");
        stringBuilder.append(" AND A.HTCNO IN (");
        stringBuilder.append(string);
        stringBuilder.append(")");
        DBUtil.dbExecute((String)stringBuilder.toString(), null, (Transaction)transaction);
    }

    private void error(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = StringUtil.array2csv((String[])stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE CB01 A");
        stringBuilder.append(" SET A.HCDJ = '9'");
        stringBuilder.append(" WHERE A.HCDJ in ('1','2')");
        stringBuilder.append(" AND A.HTCNO IN (");
        stringBuilder.append(string);
        stringBuilder.append(")");
        DBUtil.dbExecute((String)stringBuilder.toString(), null, (ApplicationInfo)this.appInfo);
    }

    private void sendMail(String string, String string2) {
        String string3 = HybsSystem.sys((String)"COMMON_MAIL_SERVER");
        String string4 = HybsSystem.sys((String)"ERROR_MAIL_FROM_USER");
        Object[] objectArray = StringUtil.csv2Array((String)HybsSystem.sys((String)"ERROR_MAIL_TO_USERS"));
        if (string3 != null && string4 != null && objectArray.length > 0) {
            try {
                MailTX mailTX = new MailTX(string3);
                mailTX.setFrom(string4);
                mailTX.setTo((String[])objectArray);
                mailTX.setSubject(string);
                mailTX.setMessage(string2);
                mailTX.sendmail();
            }
            catch (Throwable throwable) {
                String string5 = "\u30a8\u30e9\u30fc\u6642\u30e1\u30fc\u30eb\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + " SUBJECT:" + string + HybsSystem.CR + " HOST:" + string3 + HybsSystem.CR + " FROM:" + string4 + HybsSystem.CR + " TO:" + Arrays.toString(objectArray) + HybsSystem.CR + throwable.getMessage();
                LogWriter.log((String)string5);
                LogWriter.log((Throwable)throwable);
            }
        }
    }

    private static class CB01Data {
        private final Set<String> tranSet = new LinkedHashSet<String>();
        private final Map<String, Set<String>> tran2ExecKeySet = new LinkedHashMap<String, Set<String>>();
        private final Map<String, TransferConfig> execKey2Conf = new HashMap<String, TransferConfig>();
        private final Map<String, List<String>> execKey2HtcnoArr = new LinkedHashMap<String, List<String>>();

        private CB01Data() {
        }

        private void addData(String[] stringArray) {
            List<String> list;
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            String string5 = stringArray[4];
            String string6 = stringArray[5];
            String string7 = stringArray[6];
            String string8 = string;
            this.tranSet.add(string8);
            String string9 = string + string3 + string5;
            Set<String> set = this.tran2ExecKeySet.get(string8);
            if (set == null) {
                set = new LinkedHashSet<String>();
            }
            set.add(string9);
            this.tran2ExecKeySet.put(string8, set);
            TransferConfig transferConfig = this.execKey2Conf.get(string9);
            if (transferConfig == null) {
                transferConfig = new TransferConfig(string, string2, string3, string4, string5, string6);
                this.execKey2Conf.put(string9, transferConfig);
            }
            if ((list = this.execKey2HtcnoArr.get(string9)) == null) {
                list = new ArrayList<String>();
            }
            list.add(string7);
            this.execKey2HtcnoArr.put(string9, list);
        }

        private Set<String> getTranSet() {
            return this.tranSet;
        }

        private Set<String> getExecKeySet(String string) {
            return this.tran2ExecKeySet.get(string);
        }

        private TransferConfig getConfig(String string) {
            return this.execKey2Conf.get(string);
        }

        private String[] getHtcno(String string) {
            List<String> list = this.execKey2HtcnoArr.get(string);
            if (list == null) {
                return new String[0];
            }
            return list.toArray(new String[0]);
        }
    }
}

