/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.xml.JspParserFilter;
import org.opengion.fukurou.xml.OGDocument;
import org.opengion.fukurou.xml.OGElement;
import org.opengion.fukurou.xml.OGNode;
import org.opengion.fukurou.xml.OGNodeType;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class JspSaxParser
extends DefaultHandler2 {
    public static final String CR = System.getProperty("line.separator");
    private final List<JspParserFilter> filters = new ArrayList<JspParserFilter>();
    private SAXParser parser = null;
    private Map<String, OGElement> idMap = null;
    private Stack<OGNode> stack = null;
    private OGNode ele = null;
    private String attTab = "";
    private boolean inCDATA = false;
    private boolean inEntity = false;
    private String filename = null;

    public OGDocument read(File file) {
        this.filename = file.getAbsolutePath();
        try {
            if (this.parser == null) {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                this.parser = sAXParserFactory.newSAXParser();
                this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            }
            this.parser.parse(file, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "\u91cd\u5927\u306a\u69cb\u6210\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "\t" + parserConfigurationException.getMessage() + CR + "\t" + file;
            throw new RuntimeException(string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = "SAX \u306e\u4e00\u822c\u7684\u306a\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "\t" + sAXException.getMessage() + CR + "\t" + file;
            Exception exception = sAXException.getException();
            if (exception != null) {
                string = string + CR + "\t" + exception.getMessage();
            }
            throw new RuntimeException(string, sAXException);
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u53d6\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "\t" + iOException.getMessage() + CR + "\t" + file;
            throw new RuntimeException(string, iOException);
        }
        return this.getDocument();
    }

    public OGDocument string2Node(String string) {
        this.filename = null;
        try {
            Object object;
            if (this.parser == null) {
                object = SAXParserFactory.newInstance();
                this.parser = ((SAXParserFactory)object).newSAXParser();
                this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            }
            object = new InputSource(new StringReader(string));
            this.parser.parse((InputSource)object, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string2 = "\u91cd\u5927\u306a\u69cb\u6210\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + parserConfigurationException.getMessage();
            throw new RuntimeException(string2, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string3 = "SAX \u306e\u4e00\u822c\u7684\u306a\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + sAXException.getMessage();
            Exception exception = sAXException.getException();
            if (exception != null) {
                string3 = string3 + CR + "\t" + exception.getMessage();
            }
            throw new RuntimeException(string3, sAXException);
        }
        catch (IOException iOException) {
            String string4 = "\u30b9\u30c8\u30ea\u30fc\u30e0\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u4f5c\u6210\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + iOException.getMessage();
            throw new RuntimeException(string4, iOException);
        }
        return this.getDocument();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(File file, OGDocument oGDocument) {
        PrintWriter printWriter = null;
        String string = oGDocument.getEncode();
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string)));
            printWriter.println(oGDocument.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string2 = "\u6307\u5b9a\u3055\u308c\u305f\u30d1\u30b9\u540d\u3067\u793a\u3055\u308c\u308b\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "\t" + fileNotFoundException.getMessage() + CR + "\t" + file;
                throw new RuntimeException(string2, fileNotFoundException);
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string3 = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0(" + string + ")\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + CR + "\t" + unsupportedEncodingException.getMessage() + CR + "\t" + file;
                    throw new RuntimeException(string3, unsupportedEncodingException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(printWriter);
                throw throwable;
            }
        }
        Closer.ioClose(printWriter);
    }

    public void copyDirectry(File file, File file2) {
        if (file.exists() && file.isFile()) {
            boolean bl = false;
            String string = file.getName();
            if (string.endsWith(".jsp") || string.endsWith(".xml")) {
                try {
                    OGDocument oGDocument = this.read(file);
                    if (oGDocument != null && !this.filters.isEmpty()) {
                        JspParserFilter jspParserFilter;
                        Iterator<JspParserFilter> iterator = this.filters.iterator();
                        while (iterator.hasNext() && (oGDocument = (jspParserFilter = iterator.next()).filter(oGDocument)) != null) {
                        }
                    }
                    if (oGDocument != null) {
                        this.write(file2, oGDocument);
                        bl = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    System.out.println(runtimeException.getMessage());
                }
            }
            if (!bl) {
                FileUtil.copy(file, file2, true);
            }
            return;
        }
        if (!file2.exists() && !file2.mkdirs()) {
            System.err.println(file2 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.copyDirectry(fileArray[i], new File(file2, fileArray[i].getName()));
        }
    }

    public void addFilter(JspParserFilter jspParserFilter) {
        this.filters.add(jspParserFilter);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Usage: JspSaxParser  <inFile|inDir> <outFile|outDir> [<JspParserFilter1> \uff65\uff65\uff65 ]");
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        JspSaxParser jspSaxParser = new JspSaxParser();
        if (stringArray.length >= 3) {
            for (int i = 2; i < stringArray.length; ++i) {
                JspParserFilter jspParserFilter = (JspParserFilter)Class.forName(stringArray[i]).newInstance();
                jspSaxParser.addFilter(jspParserFilter);
            }
        }
        jspSaxParser.copyDirectry(file, file2);
    }

    @Override
    public void startDocument() {
        this.stack = new Stack();
        this.ele = new OGDocument();
        ((OGDocument)this.ele).setFilename(this.filename);
        this.idMap = new HashMap<String, OGElement>();
        this.attTab = "";
        this.inCDATA = false;
        this.inEntity = false;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        OGElement oGElement = new OGElement(string3, this.attTab, attributes);
        String string4 = oGElement.getId();
        if (string4 != null) {
            this.idMap.put(string4, oGElement);
        }
        this.ele.addNode(oGElement);
        this.stack.push(this.ele);
        this.ele = oGElement;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.inEntity) {
            return;
        }
        String string = this.toText(cArray, n, n2);
        if (this.inCDATA) {
            this.ele.addNode(string);
            return;
        }
        OGNode oGNode = new OGNode(string);
        this.ele.addNode(oGNode);
        int n3 = string.lastIndexOf(10);
        this.attTab = n3 >= 0 ? string.substring(n3 + 1) : string;
    }

    @Override
    public void startCDATA() {
        OGNode oGNode = new OGNode();
        oGNode.setNodeType(OGNodeType.Cdata);
        this.ele.addNode(oGNode);
        this.stack.push(this.ele);
        this.ele = oGNode;
        this.inCDATA = true;
    }

    @Override
    public void endCDATA() {
        this.ele = this.stack.pop();
        this.inCDATA = false;
    }

    @Override
    public void startDTD(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE ").append(string);
        if (string2 != null) {
            stringBuilder.append(" PUBLIC \"").append(string2).append("\"");
        }
        if (string3 != null) {
            stringBuilder.append("\"").append(string3).append("\"");
        }
        OGNode oGNode = new OGNode(stringBuilder.toString());
        oGNode.setNodeType(OGNodeType.DTD);
        this.ele.addNode(oGNode);
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String string) {
        String string2 = "&" + string + ";";
        OGNode oGNode = new OGNode(string2);
        this.ele.addNode(oGNode);
        this.inEntity = true;
    }

    @Override
    public void endEntity(String string) {
        this.inEntity = false;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        String string = this.toText(cArray, n, n2);
        OGNode oGNode = new OGNode(string);
        this.ele.addNode(oGNode);
    }

    @Override
    public void comment(char[] cArray, int n, int n2) {
        String string = this.toText(cArray, n, n2);
        OGNode oGNode = new OGNode(string);
        oGNode.setNodeType(OGNodeType.Comment);
        this.ele.addNode(oGNode);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.ele = this.stack.pop();
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        String string = sAXParseException.getMessage() + ":" + sAXParseException.getPublicId() + CR + "\t" + this.filename + " (" + sAXParseException.getLineNumber() + ")";
        System.err.println("WARNING:" + string);
    }

    private String toText(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        return string.replaceAll("\n", CR);
    }

    private OGDocument getDocument() {
        OGDocument oGDocument = null;
        if (this.ele != null && this.ele.getNodeType() == OGNodeType.Document) {
            oGDocument = (OGDocument)this.ele;
            oGDocument.setIdMap(this.idMap);
        }
        return oGDocument;
    }
}

