/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.FileLineModel;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.FTPConnect;
import org.opengion.fukurou.util.LogWriter;

public class Process_FileFtp
extends AbstractProcess
implements ChainProcess {
    private static final int TIMEOUT = 600;
    private FTPConnect ftp = null;
    private String host = null;
    private String user = null;
    private String command = "PUT";
    private String localPath = null;
    private String remotePath = null;
    private boolean display = false;
    private boolean debug = false;
    private int localPathLen = 0;
    private int inCount = 0;
    private static final Map<String, String> mustProparty;
    private static final Map<String, String> usableProparty;
    private static final String[] MODE_LST;

    public Process_FileFtp() {
        super("org.opengion.fukurou.process.Process_FileFtp", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        String string = argument.getProparty("pass");
        this.host = argument.getProparty("host");
        this.user = argument.getProparty("user");
        this.ftp = new FTPConnect();
        this.ftp.setHostUserPass(this.host, this.user, string);
        this.localPath = argument.getProparty("localPath");
        this.remotePath = argument.getProparty("remotePath");
        this.localPathLen = this.localPath.length();
        this.ftp.setMode(argument.getProparty("mode", "ASCII", MODE_LST));
        this.ftp.setPassive(argument.getProparty("passive", true));
        this.ftp.setMkdirs(argument.getProparty("mkdirs", true));
        this.ftp.setEncode(argument.getProparty("encode", "UTF-8"));
        this.ftp.setTimeout(argument.getProparty("timeout", 600));
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("display", this.debug);
        this.ftp.setDisplay(this.display);
        this.ftp.setDebug(this.debug);
        this.ftp.connect();
    }

    @Override
    public void end(boolean bl) {
        if (this.ftp != null) {
            this.ftp.disconnect();
        }
    }

    @Override
    public LineModel action(LineModel lineModel) {
        ++this.inCount;
        FileLineModel fileLineModel = lineModel instanceof FileLineModel ? (FileLineModel)lineModel : new FileLineModel(lineModel);
        File file = fileLineModel.getFile();
        if (!file.isFile()) {
            if (this.display) {
                this.println(lineModel.dataLine());
            }
            return lineModel;
        }
        String string = file.getAbsolutePath();
        String string2 = this.remotePath + string.substring(this.localPathLen);
        this.ftp.action(this.command, string, string2);
        if (this.display) {
            this.println(lineModel.dataLine());
        }
        return lineModel;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\t" + "Copy Count : " + this.inCount + CR + "\t" + "host       : " + this.host + CR + "\t" + "user       : " + this.user + CR + "\t" + "localPath  : " + this.localPath + CR + "\t" + "remotePath : " + this.remotePath;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process_FileFtp \u306f\u3001\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f FileLineModel \u3092\u51e6\u7406\u3059\u308b").append(CR);
        stringBuilder.append("ChainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f FileLineModel \u306e \u30d5\u30a1\u30a4\u30eb\u304b\u3089\u3001localPath \u306e\u30ed\u30fc\u30ab\u30eb\u5171\u901a\u30d1\u30b9\u3092").append(CR);
        stringBuilder.append("remotePath \u306eFTP\u5171\u901a\u30d1\u30b9\u306b\u3001PFT\u4f1d\u9001\u3057\u307e\u3059\u3002(-command=PUT \u51e6\u7406\u306e\u307f) ").append(CR);
        stringBuilder.append("\u30d5\u30a1\u30a4\u30eb\u305d\u306e\u3082\u306e\u306e\u968e\u5c64\u69cb\u9020\u306f\u3001\u7dad\u6301\u3055\u308c\u308b\u305f\u3081\u3001\u30ed\u30fc\u30ab\u30eb\u304b\u3089FTP\u30b5\u30fc\u30d0\u30fc").append(CR);
        stringBuilder.append("\u3078\u306e\u30d5\u30a9\u30eb\u30c0\u30b3\u30d4\u30fc\u306b\u8fd1\u3044\u30a4\u30e1\u30fc\u30b8\u306b\u306a\u308a\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("Process_FileCopy \u3068\u306e\u9055\u3044\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u5909\u63db\u306f\u884c\u3044\u307e\u305b\u3093\u3002\u305f\u3060\u3057\u3001").append(CR);
        stringBuilder.append("FTP\u4f1d\u9001\u3067\u306e\u6539\u884c\u30b3\u30fc\u30c9\u306e\u5909\u63db\u306f\u3001-mode=ASCII \u3067\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002").append(CR);
        stringBuilder.append("\u3082\u3046\u3072\u3068\u3064\u3001Process_FileCopy \u3067\u306f\u3001inPath \u3068 outPath \u3067\u306eCOPY\u51e6\u7406\u3067\u3057\u305f\u304c\u3001").append(CR);
        stringBuilder.append("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u3001localPath \u3068\u3001remotePath \u3067\u305d\u308c\u305e\u308c\u306e\u5171\u901a\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u4e0a\u6d41\u30d7\u30ed\u30bb\u30b9\u3067\u306f\u3001Name \u5c5e\u6027\u3068\u3057\u3066\u3001\u300eFile\u300f\u3092\u6301\u3061\u3001\u5024\u306f\u3001File\u30aa\u30d6\u30b8\u30a7\u30af\u30c8").append(CR);
        stringBuilder.append("\u3067\u3042\u308b\u3001Process_FileSearch \u3092\u4f7f\u7528\u3059\u308b\u306e\u304c\u3001\u4fbf\u5229\u3067\u3059\u3002\u305d\u308c\u4ee5\u5916\u306e\u30af\u30e9\u30b9\u3092").append(CR);
        stringBuilder.append("\u4f7f\u7528\u3059\u308b\u5834\u5408\u3067\u3082\u3001Name\u5c5e\u6027\u3068\u3001File \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6301\u3064 LineModel \u3092\u53d7\u3051\u6e21\u3057").append(CR);
        stringBuilder.append("\u3067\u304d\u308c\u3070\u3001\u4f7f\u7528\u53ef\u80fd\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_FileFtp().usage());
    }

    static {
        MODE_LST = new String[]{"ASCII", "BINARY"};
        mustProparty = new LinkedHashMap<String, String>();
        mustProparty.put("host", "\u63a5\u7d9a\u5148\u306eFTP\u30b5\u30fc\u30d0\u30fc\u306e\u30a2\u30c9\u30ec\u30b9\u307e\u305f\u306f\u3001\u30b5\u30fc\u30d0\u30fc\u540d(\u5fc5\u9808)");
        mustProparty.put("user", "\u63a5\u7d9a\u3059\u308b\u30e6\u30fc\u30b6\u30fc\u540d(\u5fc5\u9808)");
        mustProparty.put("pass", "\u63a5\u7d9a\u3059\u308b\u30e6\u30fc\u30b6\u30fc\u306e\u30d1\u30b9\u30ef\u30fc\u30c9(\u5fc5\u9808)");
        mustProparty.put("localPath", "\u4e0a\u6d41\u3067\u691c\u7d22\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u306e\u30ed\u30fc\u30ab\u30eb\u5074\u5171\u901a\u90e8\u5206(\u5fc5\u9808)");
        mustProparty.put("remotePath", "\u4e0a\u6d41\u3067\u691c\u7d22\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u306eFTP\u5074\u5171\u901a\u90e8\u5206(\u5fc5\u9808)");
        usableProparty = new LinkedHashMap<String, String>();
        usableProparty.put("mode", "\u6271\u3046\u30d5\u30a1\u30a4\u30eb\u306e\u7a2e\u985e\uff08ASCII/BINARY\uff09\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002(\u521d\u671f\u5024\uff1aASCII)");
        usableProparty.put("passive", "\u30d1\u30c3\u30b7\u30d6\u30e2\u30fc\u30c9(\u30ed\u30fc\u30ab\u30eb\u304b\u3089\u30b5\u30fc\u30d0\u30fc\u3078\u63a5\u7d9a\u3092\u5f35\u308b)\u3092\u5229\u7528\u3059\u308b\u304b\u3069\u3046\u304b\u3002(\u521d\u671f\u5024\uff1atrue)");
        usableProparty.put("mkdirs", "\u53d7\u3051\u5074\u30d5\u30a1\u30a4\u30eb(GET\u6642:LOCAL\u3001PUT\u6642:FTP\u30b5\u30fc\u30d0\u30fc)\u306b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3059\u308b\u304b\u3069\u3046\u304b\u3002(\u521d\u671f\u5024\uff1atrue)");
        usableProparty.put("encode", "\u65e5\u672c\u8a9e\u30d5\u30a1\u30a4\u30eb\u540d\u306a\u3069\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002(\u521d\u671f\u5024\uff1aUTF-8\uff09");
        usableProparty.put("timeout", "Data\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3002(\u521d\u671f\u5024\uff1a600 [\u79d2])");
        usableProparty.put("display", "[false/true]:true\u306f\u3001\u691c\u7d22\u72b6\u6cc1\u3092\u8868\u793a\u3057\u307e\u3059\u3002(\u521d\u671f\u5024\uff1afalse\uff09");
        usableProparty.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "\uff08\u521d\u671f\u5024 false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

