/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.resource;

/**
 * systemId , lang に対応したラベルデータを作成します。
 *
 * ラベルデータは、項目(CLM)に対して、各種ラベル情報を持っています。
 * ラベルデータは、名前(短)と名前(長)を持っています。従来のラベルは、表示名称と
 * して、一種類しか持っていませんでした。
 * 名前(長)は、従来の表示名称にあたります。これは、一般的なラベルとして
 * 使用されます。名前(短)は、テーブル一覧のヘッダーの様に、特殊なケースで、
 * 簡略化された名称を使用するときに利用されます。この切り替えは、自動で判断されます。
 * 名前(短)に、なにも設定されていない場合は、名前(長)が自動的に使用されますので
 * 初期データ移行時には、そのまま、通常時もテーブルヘッダー時も同じ文字列が
 * 使用されます。
 *
 * ラベルデータを作成する場合は、同一ラベルで、作成区分(KBSAKU)違いの場合は、
 * 最も大きな作成区分を持つコードを使用します。
 * 作成区分(KBSAKU)は、0:システム予約、1:アプリ設定、2:ユーザー設定 という具合に
 * カスタマイズの度合いに応じて大きな数字を割り当てることで、キー情報を上書き修正
 * することが可能になります。（削除することは出来ません。）
 *
 * @og.rev 4.0.0 (2004/12/31) 新規作成
 * @og.group リソース管理
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface LabelInterface {

	/**
	 * ラベルインターフェースのキーを返します。
	 *
	 * @return key ラベルインターフェースのキー
	 *
	 */
	String getKey() ;

	/**
	 * ラベルインターフェースの名前を返します。
	 * これは、ＤＢ上の LNAME(名前(長))に該当します。
	 *
	 * @return label ラベルインターフェースの名前(短)
	 *
	 */
	String getLabel() ;

	/**
	 * ラベルインターフェースの引数付きメッセージを返します。
	 * メッセージの引数部分に、文字列配列を適用して、MessageFormat
	 * で変換した結果を返します。(MessageData でのみ有効です。)
	 *
	 * @return label ラベルインターフェースの引数付きメッセージ
	 *
	 */
	String getMessage( String[] vals ) ;

	/**
	 * ラベルインターフェースの名前(短)を返します。
	 * 概要説明がない場合でかつＤＢ上のSNAMEが未設定の場合は、
	 * LNAME が返されます。SNAMEが設定されている場合は、
	 * ツールチップにLNAME が表示されます。
	 * 概要説明が存在する場合は、ツールチップに概要説明が
	 * 表示されます。
	 *
	 * @return shortLabel ラベルインターフェースの名前(短)
	 */
	String getShortLabel() ;

	/**
	 * ラベルインターフェースの名前(長)を返します。
	 * 概要説明が存在する場合は、ツールチップに概要説明が
	 * 表示されます。
	 *
	 * @return shortLabel ラベルインターフェースの名前(長)
	 * @see #getLongLabel( String )
	 */
	String getLongLabel() ;

	/**
	 * ラベルインターフェースの名前(長)を返します。
	 * ツールチップに表示するタイトル属性(概要説明)を置き換えます。
	 * null の場合は、既存のgetLongLabel()を返します。
	 *
	 * @param  title String ツールチップに表示するタイトル属性
	 * @return shortLabel ラベルインターフェースの名前(長)
	 * @see #getLongLabel()
	 */
	String getLongLabel( String title ) ;

	/**
	 * ラベルインターフェースの概要説明を返します。
	 * 概要説明が存在する場合は、ラベルのツールチップに
	 * 概要説明が表示されます。
	 *
	 * @return description ラベルインターフェースの概要説明
	 *
	 */
	String getDescription() ;
	
	/**
	 * ラベルインターフェースの引数付きメッセージを返します。
	 * 概要(対応方法)の引数部分に、文字列配列を適用して、MessageFormat
	 * で変換した結果を返します。(MessageData でのみ有効です。)
	 * 
	 * @og.rev 4.3.7.6 (2009/07/15) 新規作成
	 * 
	 * @param vals パラメータ
	 * @return label ラベルインターフェースの引数付き概要
	 *
	 */
	String getDescription( String[] vals ) ;

	/**
	 * リソースＤＢから作成されたかどうかを返します。
	 * 正式な場合は、true / リソースになく、独自に作成された場合は、false になります。
	 *
	 * @return official リソースＤＢから作成されたかどうか
	 *
	 */
	boolean isOfficial() ;
}
