/**************************************************************************/
/* GF91 ( 青紙明細テーブル )                                              */
/*                                                                        */
/* Created : 2010/05/07 16:07:33                                          */
/**************************************************************************/
CREATE TABLE GF91 (
   SYSTEM_ID  VARCHAR2(10)                                /* 10  システムID   */
 , PGID       VARCHAR2(30)                  NOT NULL      /* 20  PG-ID        */
 , TABLE_NAME VARCHAR2(50)                  NOT NULL      /* 30  テーブル名   */
 , AS_TABLE   VARCHAR2(2)                   NOT NULL      /* 40  テーブル別名 */
 , KBACCS     VARCHAR2(1)                                 /* 50  アクセス区分 */
 , BIKO       VARCHAR2(2000)                              /* 60  備考         */
 , UNIQ       NUMBER(9)         DEFAULT 0   NOT NULL      /* 70  ユニークキー */
 , FGJ        VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 80  状態フラグ   */
 , DYSET      VARCHAR2(14)                                /* 90  登録日時     */
 , PGSET      VARCHAR2(10)                                /* 100 作成PG       */
 , PGPSET     VARCHAR2(10)                                /* 110 作成親PG     */
 , USRSET     VARCHAR2(10)                                /* 120 作成社員     */
 , DYUPD      VARCHAR2(14)                                /* 130 更新日時     */
 , PGUPD      VARCHAR2(10)                                /* 140 更新PG       */
 , PGPUPD     VARCHAR2(10)                                /* 150 更新親PG     */
 , USRUPD     VARCHAR2(10)                                /* 160 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF91S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF91T01 
BEFORE INSERT ON GF91
FOR EACH ROW 
BEGIN 
SELECT GF91S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

