/**************************************************************************/
/* GF07 ( インデックスカラム定義 )                                        */
/*                                                                        */
/* Created : 2010/05/07 16:07:32                                          */
/**************************************************************************/
CREATE TABLE GF07 (
   SYSTEM_ID  VARCHAR2(10)                NOT NULL      /* 10  システムID     */
 , TBLSYU     VARCHAR2(1)                 NOT NULL      /* 20  テーブル種別   */
 , TABLE_NAME VARCHAR2(50)                NOT NULL      /* 30  テーブル名     */
 , INDEX_NAME VARCHAR2(30)                NOT NULL      /* 40  インデックス名 */
 , CLM        VARCHAR2(30)                NOT NULL      /* 50  項目           */
 , SEQNO      NUMBER(7)       DEFAULT 0   NOT NULL      /* 60  表示順         */
 , UNIQ       NUMBER(9)       DEFAULT 0   NOT NULL      /* 800 ユニークキー   */
 , FGJ        VARCHAR2(1)     DEFAULT '1' NOT NULL      /* 810 状態フラグ     */
 , DYSET      VARCHAR2(14)                              /* 820 登録日時       */
 , PGSET      VARCHAR2(10)                              /* 830 作成PG         */
 , PGPSET     VARCHAR2(10)                              /* 840 作成親PG       */
 , USRSET     VARCHAR2(10)                              /* 850 作成社員       */
 , DYUPD      VARCHAR2(14)                              /* 860 更新日時       */
 , PGUPD      VARCHAR2(10)                              /* 870 更新PG         */
 , PGPUPD     VARCHAR2(10)                              /* 880 更新親PG       */
 , USRUPD     VARCHAR2(10)                              /* 890 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF07S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF07T01 
BEFORE INSERT ON GF07
FOR EACH ROW 
BEGIN 
SELECT GF07S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

