/**************************************************************************/
/* GE39 ( ファイル管理テーブル )                                          */
/*                                                                        */
/* Created : 2010/05/07 16:07:31                                          */
/**************************************************************************/
CREATE TABLE GE39 (
   UNIQ_ID     VARCHAR2(10)                  NOT NULL      /* 10  UNIQ番号         */
 , SEQNO       NUMBER(7)         DEFAULT 0   NOT NULL      /* 20  表示順           */
 , SUFFIX      VARCHAR2(10)                                /* 30  拡張子           */
 , REF_KEY     VARCHAR2(100)                 NOT NULL      /* 40  関連キー         */
 , SYSTEM_ID   VARCHAR2(10)                  NOT NULL      /* 50  システムID       */
 , SYKEY       VARCHAR2(10)                  NOT NULL      /* 60  種別キー         */
 , SYFILE      VARCHAR2(100)                               /* 70  ファイル種別     */
 , SYNAME      VARCHAR2(200)                               /* 80  種別名称         */
 , SAVE_FOLDER VARCHAR2(300)                               /* 90  保管フォルダ     */
 , FILE_URL    VARCHAR2(300)                               /* 100 ファイルURL      */
 , ICON_URL    VARCHAR2(300)                               /* 110 アイコンURL      */
 , ROLES       VARCHAR2(500)                               /* 120 ロールズ         */
 , SU_LMT      NUMBER(5)         DEFAULT 0   NOT NULL      /* 130 閲覧制限数       */
 , DY_LMT      NUMBER(5)         DEFAULT 0   NOT NULL      /* 140 閲覧期日         */
 , FGANGO      VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 150 暗号化FG         */
 , FGZIP       VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 160 圧縮FG           */
 , FILE_NAME   VARCHAR2(500)                               /* 170 ファイル名称     */
 , CONTENTS    VARCHAR2(4000)                              /* 180 内容             */
 , FG_NEW      VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 190 最新FG           */
 , SIZE_FILE   NUMBER(9)         DEFAULT 0   NOT NULL      /* 200 ファイルサイズ   */
 , DYFILESET   VARCHAR2(14)                                /* 210 ファイル登録日時 */
 , USRTOROKU   VARCHAR2(10)                                /* 220 ファイル登録者   */
 , SETGUIID    VARCHAR2(10)                                /* 230 登録画面ID       */
 , FGKOSHIN    VARCHAR2(1)       DEFAULT '1'               /* 240 変更許可FG       */
 , FGKOKAI     VARCHAR2(1)       DEFAULT '1'               /* 250 公開許可FG       */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 260 ユニークキー     */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 270 状態フラグ       */
 , DYSET       VARCHAR2(14)                                /* 280 登録日時         */
 , PGSET       VARCHAR2(10)                                /* 290 作成PG           */
 , PGPSET      VARCHAR2(10)                                /* 300 作成親PG         */
 , USRSET      VARCHAR2(10)                                /* 310 作成社員         */
 , DYUPD       VARCHAR2(14)                                /* 320 更新日時         */
 , PGUPD       VARCHAR2(10)                                /* 330 更新PG           */
 , PGPUPD      VARCHAR2(10)                                /* 340 更新親PG         */
 , USRUPD      VARCHAR2(10)                                /* 350 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE39S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE39T01 
BEFORE INSERT ON GE39
FOR EACH ROW 
BEGIN 
SELECT GE39S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

