/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.db.QueryFactory;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class QueryTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    private static final String[] COMMAND_LIST = new String[]{"NEW", "RENEW"};
    protected static final String errMsgId = "h_errMsg";
    private String queryType = null;
    private String dbid = null;
    protected transient DBTableModel table = null;
    protected transient ErrorMessage errMessage = null;
    protected String tableId = "h_tblmdl";
    protected String command = "NEW";
    protected int skipRowCount = 0;
    protected int maxRowCount = -1;
    protected String sql = null;
    protected int executeCount = -1;
    protected String names = null;
    protected boolean outMessage = true;
    protected int errCode = 0;
    protected boolean quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
    private boolean trace = false;
    private boolean stopZero = false;
    private String modifyType = null;
    protected String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String overflowMsg = "MSG0007";
    private String notfoundMsg = "MSG0077";
    private boolean isMainTrans = true;
    protected long dyStart = 0L;
    protected boolean stopError = true;
    private StringBuilder debugMsg = null;
    private String checkNames = null;
    private String traceMsg = null;
    protected boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");

    @Override
    public int doStartTag() {
        this.dyStart = System.currentTimeMillis();
        if (!this.check(this.command, COMMAND_LIST)) {
            return 0;
        }
        this.useMainTrans(this.isMainTrans);
        this.startQueryTransaction(this.tableId);
        if ("session".equals(this.getScope())) {
            this.removeSessionAttribute(this.tableId);
            this.removeSessionAttribute("h_vform");
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doAfterBody() {
        this.useQuotCheck(this.quotCheck);
        this.useXssCheck(this.xssCheck);
        this.sql = this.getBodyString().trim();
        if (this.isMainTrans) {
            this.setUserInfo("LASTSQL", this.sql, false);
        }
        Query query = QueryFactory.newInstance(this.queryType);
        try {
            if (this.maxRowCount < 0) {
                this.maxRowCount = this.sysInt("DB_MAX_ROW_COUNT");
            }
            query.setSkipRowCount(this.skipRowCount);
            query.setMaxRowCount(this.maxRowCount);
            query.setConnectionID(this.dbid);
            query.setResourceManager(this.getResource());
            if (this.trace) {
                this.traceMsg = this.traceQuery(this.sql);
                query.setMaxRowCount(1);
            }
            query.setStatement(this.sql);
            query.setApplicationInfo(this.getApplicationInfo());
            this.execute(query);
            this.executeCount = query.getExecuteCount();
            if (this.errCode < 2 && this.executeCount >= 0) {
                this.table = query.getDBTableModel();
                if (this.modifyType != null) {
                    for (int i = 0; i < this.executeCount; ++i) {
                        this.table.setModifyType(i, this.modifyType);
                    }
                }
            }
        }
        finally {
            if (query != null) {
                query.close();
            }
            QueryFactory.close(query);
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.trace) {
            this.jspPrint(this.traceMsg);
        }
        String string = "";
        if (this.check(this.command, COMMAND_LIST)) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder(50);
            if (CMD_NEW.equals(this.command)) {
                if (this.executeCount > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
                    stringBuilder.append(this.executeCount);
                    stringBuilder.append(this.getResource().getLabel(this.displayMsg));
                    stringBuilder.append(HybsSystem.BR);
                } else if (this.executeCount == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
                    stringBuilder.append(this.getResource().getLabel(this.notfoundMsg));
                    stringBuilder.append(HybsSystem.BR);
                }
            }
            this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
            this.setRequestAttribute("DB.ERR_CODE", String.valueOf(this.errCode));
            if (this.table != null && this.table.isOverflow()) {
                stringBuilder.append(this.getResource().getLabel(this.overflowMsg));
                stringBuilder.append(HybsSystem.BR);
            }
            if ((string2 = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource())) != null && string2.length() > 0) {
                stringBuilder.append(string2);
                this.setSessionAttribute(errMsgId, this.errMessage);
            } else if (CMD_NEW.equals(this.command)) {
                this.removeSessionAttribute(errMsgId);
            }
            string = stringBuilder.toString();
            if (this.table != null && !this.commitTableObject(this.tableId, this.table)) {
                this.jspPrint("QueryTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        }
        this.jspPrint(string);
        int n = this.errCode >= 2 ? (this.stopError ? 5 : 6) : (this.executeCount == 0 && this.stopZero ? 5 : 6);
        long l = System.currentTimeMillis() - this.dyStart;
        this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        GUIInfo gUIInfo = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (gUIInfo != null) {
            gUIInfo.addReadCount(this.executeCount, l, this.sql);
        }
        return n;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.queryType = null;
        this.dbid = null;
        this.command = CMD_NEW;
        this.skipRowCount = 0;
        this.maxRowCount = -1;
        this.table = null;
        this.sql = null;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.overflowMsg = "MSG0007";
        this.notfoundMsg = "MSG0077";
        this.executeCount = -1;
        this.names = null;
        this.outMessage = true;
        this.trace = false;
        this.errCode = 0;
        this.errMessage = null;
        this.stopZero = false;
        this.stopError = true;
        this.dyStart = 0L;
        this.debugMsg = null;
        this.checkNames = null;
        this.quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
        this.modifyType = null;
        this.traceMsg = null;
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.isMainTrans = true;
    }

    protected void execute(Query query) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        try {
            if (this.names == null) {
                query.execute();
            } else {
                stringArray = StringUtil.csv2Array((String)this.names);
                stringArray2 = this.getRequest(stringArray);
                if (this.isDebug()) {
                    this.printDebug(stringArray, stringArray2);
                }
                query.execute(stringArray2);
            }
            this.errCode = query.getErrorCode();
            this.errMessage = query.getErrorMessage();
            if (query.isUpdate()) {
                if (this.errCode < 2) {
                    query.commit();
                } else {
                    query.rollback();
                }
            }
        }
        catch (HybsSystemException hybsSystemException) {
            query.rollback();
            String string = "DATABASE ERROR! " + HybsSystem.CR;
            if (stringArray != null) {
                this.printDebug(stringArray, stringArray2);
                string = string + this.debugMsg;
            }
            throw new HybsSystemException(string, hybsSystemException);
        }
        finally {
            if (query != null) {
                query.close();
            }
        }
    }

    private void printDebug(String[] stringArray, String[] stringArray2) {
        if (this.debugMsg == null) {
            this.debugMsg = new StringBuilder();
        }
        this.debugMsg.append("  names=[");
        this.debugMsg.append(StringUtil.array2csv((String[])stringArray));
        this.debugMsg.append("]");
        this.debugMsg.append(HybsSystem.CR);
        this.debugMsg.append("  values=[");
        this.debugMsg.append(StringUtil.array2csv((String[])stringArray2));
        this.debugMsg.append("]");
        this.debugMsg.append(HybsSystem.CR);
    }

    protected String[] getRequest(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            DBColumn dBColumn;
            String string;
            stringArray2[i] = this.getRequestValue(stringArray[i]);
            if (this.checkNames == null || this.checkNames.length() <= 0 || stringArray2[i].length() <= 0 || ("," + this.checkNames + ",").indexOf("," + stringArray[i] + ",") < 0 || (string = (dBColumn = this.getDBColumn(stringArray[i])).valueSet(stringArray2[i])) == null) continue;
            stringArray2[i] = string;
        }
        return stringArray2;
    }

    public void setSkipRowCount(String string) {
        this.skipRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.skipRowCount);
    }

    public void setMaxRowCount(String string) {
        this.maxRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxRowCount);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setQueryType(String string) {
        this.queryType = this.getRequestParameter(string);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() >= 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setStopZero(String string) {
        this.stopZero = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopZero);
    }

    public void setDisplayMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.displayMsg = string2;
        }
    }

    public void setOverflowMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.overflowMsg = string2;
        }
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    public void setNames(String string) {
        this.names = StringUtil.nval((String)this.getRequestParameter(string), (String)this.names);
    }

    public void setOutMessage(String string) {
        this.outMessage = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.outMessage);
    }

    public void setTrace(String string) {
        this.trace = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.trace);
    }

    public void setCheckNames(String string) {
        this.checkNames = StringUtil.nval((String)this.getRequestParameter(string), (String)this.checkNames);
    }

    public void setModifyType(String string) {
        this.modifyType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.modifyType);
    }

    public void setQuotCheck(String string) {
        this.quotCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.quotCheck);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    public void setStopError(String string) {
        this.stopError = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopError);
    }

    private String traceQuery(String string) {
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        String string2 = this.getUserInfo("USER.ID");
        String[] stringArray = new String[]{string2};
        DBUtil.dbExecute((String)"DELETE FROM PLAN_TABLE WHERE STATEMENT_ID = ?", (String[])stringArray, (ApplicationInfo)applicationInfo, (String)this.dbid);
        String string3 = "EXPLAIN PLAN SET STATEMENT_ID = '" + string2 + "' FOR " + string;
        DBUtil.dbExecute((String)string3, null, (ApplicationInfo)applicationInfo, (String)this.dbid);
        String[] stringArray2 = new String[]{string2, string2, string2};
        String string4 = "SELECT LEVEL,LPAD(' ',LEVEL,' ') || RTRIM( OPERATION ) || ' ' || RTRIM( OPTIONS )   || ' ' || RTRIM( OBJECT_NAME ) FROM PLAN_TABLE WHERE STATEMENT_ID = ? CONNECT BY PRIOR ID = PARENT_ID         AND STATEMENT_ID = ? START WITH ID = 0         AND STATEMENT_ID = ?";
        String[][] stringArray3 = DBUtil.dbExecute((String)string4, (String[])stringArray2, (ApplicationInfo)applicationInfo, (String)this.dbid);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<pre>").append(string).append("</pre>").append(HybsSystem.BR);
        stringBuilder.append("<table>");
        stringBuilder.append("<tr  class=\"row_h\"><th>LEVEL</th><th>EXECUTION_PLAN</th></tr>");
        for (int i = 0; i < stringArray3.length; ++i) {
            stringBuilder.append("<tr class=\"row_").append(i % 2).append("\">");
            stringBuilder.append("<td>").append(stringArray3[i][0]).append("</td>");
            stringBuilder.append("<td><pre>").append(stringArray3[i][1]).append("</td></tr>");
        }
        stringBuilder.append("</table>").append(HybsSystem.BR);
        return stringBuilder.toString();
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return this.sql;
    }
}

