/************************************************

  SingleBarクラス

  単一の直線部材を表すオブジェクトです。

  http://1-stop.co.cc/

************************************************/

#ifndef SINGLEBAR_H
#define SINGLEBAR_H

#include <QWidget>

class SingleBar
{
public:
    SingleBar(double);
    void addMomentLoad(double M,double x);
    void addAxialLoad(double W,double x);
    void addSharingLoad(double W,double Gw,double S,double Gs);
    void clearLoad();
    double end_M(bool);
    double end_Q(bool);
    double end_N(bool);

private:
    double left_end_M;
    double left_end_Q;
    double left_end_N;
    double right_end_M;
    double right_end_Q;
    double right_end_N;
    double Length;
};

#endif // SINGLEBAR_H
