/************************************************

  SingleBarクラス

  荷重入力用のメンバ関数により、固定端反力を操作します。

  http://1-stop.co.cc/

************************************************/

#include "singlebar.h"

SingleBar::SingleBar(double length)
{
    clearLoad();
    if (length > 0) Length = length;
}

void SingleBar::addAxialLoad(double W, double x)
{
    double right_end_Added = W * x / Length;
    right_end_N += right_end_Added;
    left_end_N += W - right_end_Added;
}

void SingleBar::addMomentLoad(double M, double x)
{
    double right_end_Added = M * x / Length * 0.5;
    right_end_M += right_end_Added;
    left_end_M += M * 0.5 - right_end_Added;
    right_end_Added = right_end_Added * 3 / Length;
    right_end_Q += right_end_Added;
    left_end_Q -= right_end_Added * (Length / x - 1);
}

void SingleBar::addSharingLoad(double W, double Gw, double S, double Gs)
{
    double right_end_Added = ( 1 - Gs * 3 / Length ) * S * 2 / Length;
    right_end_M += right_end_Added;
    left_end_M += right_end_Added + S * 2 / Length;
    right_end_Added = ((right_end_Added + S / Length) * 2 - W * Gw) / Length;
    right_end_Q += right_end_Added;
    left_end_Q -= W + right_end_Added;
}

void SingleBar::clearLoad()
{
    left_end_M = 0;
    left_end_Q = 0;
    left_end_N = 0;
    right_end_M = 0;
    right_end_Q = 0;
    right_end_N = 0;
}

double SingleBar::end_M(bool index)
{
    if (index) return right_end_M;
    else return left_end_M;
}

double SingleBar::end_N(bool index)
{
    if (index) return right_end_N;
    else return left_end_N;
}

double SingleBar::end_Q(bool index)
{
    if (index) return right_end_Q;
    else return left_end_Q;
}
