/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import twitter4j.ExceptionDiagnosis;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.TwitterResponse;
import twitter4j.Version;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.http.HttpResponseCode;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterException
extends Exception
implements TwitterResponse,
HttpResponseCode {
    private int statusCode = -1;
    private int retryAfter;
    private RateLimitStatus rateLimitStatus;
    private RateLimitStatus featureSpecificRateLimitStatus = null;
    private static final long serialVersionUID = -2623309261327598087L;
    private Map<String, List<String>> responseHeaderFields = null;
    private ExceptionDiagnosis exceptionDiagnosis = null;
    private static final String[] FILTER = new String[]{"twitter4j"};
    boolean nested = false;

    public TwitterException(String message) {
        super(TwitterException.decode(message));
        this.rateLimitStatus = null;
    }

    public TwitterException(Exception cause) {
        super(TwitterException.decode(cause.getMessage()), cause);
        if (cause instanceof TwitterException) {
            ((TwitterException)cause).setNested();
        }
        this.rateLimitStatus = null;
    }

    public TwitterException(String message, HttpResponse res) {
        super(new StringBuffer().append(TwitterException.getCause(res)).append("\n").append(TwitterException.decode(message)).toString());
        if (res.getStatusCode() == 420) {
            try {
                String retryAfterStr = res.getResponseHeader("Retry-After");
                if (null != retryAfterStr) {
                    this.retryAfter = Integer.valueOf(retryAfterStr);
                }
            }
            catch (NumberFormatException ignore) {
                this.retryAfter = -1;
            }
        }
        this.responseHeaderFields = res.getResponseHeaderFields();
        this.statusCode = res.getStatusCode();
        this.rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader(res);
        this.featureSpecificRateLimitStatus = RateLimitStatusJSONImpl.createFeatureSpecificRateLimitStatusFromResponseHeader(res);
    }

    public TwitterException(String message, int retryAfter, Map<String, List<String>> responseHeaderFields, int statusCode, RateLimitStatus rateLimitStatus, RateLimitStatus featureSpecificLateLimitStatus) {
        super(TwitterException.decode(message));
        this.retryAfter = retryAfter;
        this.responseHeaderFields = responseHeaderFields;
        this.statusCode = statusCode;
        this.rateLimitStatus = rateLimitStatus;
        this.featureSpecificRateLimitStatus = featureSpecificLateLimitStatus;
    }

    public TwitterException(String msg, Exception cause) {
        super(TwitterException.decode(msg), cause);
    }

    public TwitterException(String msg, Exception cause, int statusCode) {
        super(TwitterException.decode(msg), cause);
        this.statusCode = statusCode;
    }

    private static String decode(String str) {
        StringBuffer value = new StringBuffer(str.length());
        try {
            JSONObject json = new JSONObject(str);
            if (!json.isNull("error")) {
                value.append("error - ").append(json.getString("error")).append("\n");
            }
            if (!json.isNull("request")) {
                value.append("request - ").append(json.getString("request")).append("\n");
            }
        }
        catch (JSONException e) {
            value.append(str);
        }
        return value.toString();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseHeader(String name) {
        List<String> header;
        String value = null;
        if (null != this.responseHeaderFields && (header = this.responseHeaderFields.get(name)).size() > 0) {
            value = header.get(0);
        }
        return value;
    }

    @Override
    public RateLimitStatus getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    public RateLimitStatus getFeatureSpecificRateLimitStatus() {
        return this.featureSpecificRateLimitStatus;
    }

    public int getRetryAfter() {
        if (this.statusCode != 420) {
            throw new IllegalStateException("Rate limitation is not exceeded");
        }
        return this.retryAfter;
    }

    public boolean isCausedByNetworkIssue() {
        return this.getCause() instanceof IOException;
    }

    public boolean exceededRateLimitation() {
        return this.statusCode == 400 && null != this.rateLimitStatus || this.statusCode == 420;
    }

    public boolean resourceNotFound() {
        return this.statusCode == 404;
    }

    public String getExceptionCode() {
        return this.getExceptionDiagnosis().asHexString();
    }

    private ExceptionDiagnosis getExceptionDiagnosis() {
        if (null == this.exceptionDiagnosis) {
            this.exceptionDiagnosis = new ExceptionDiagnosis(this, FILTER);
        }
        return this.exceptionDiagnosis;
    }

    void setNested() {
        this.nested = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterException that = (TwitterException)o;
        if (this.retryAfter != that.retryAfter) {
            return false;
        }
        if (this.statusCode != that.statusCode) {
            return false;
        }
        return !(this.rateLimitStatus != null ? !this.rateLimitStatus.equals(that.rateLimitStatus) : that.rateLimitStatus != null);
    }

    public int hashCode() {
        int result = this.statusCode;
        result = 31 * result + this.retryAfter;
        result = 31 * result + (this.rateLimitStatus != null ? this.rateLimitStatus.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return new StringBuffer().append(this.getMessage()).append(this.nested ? "" : new StringBuffer().append("Relevant discussions can be on the Internet at:\n\thttp://www.google.co.jp/search?q=").append(this.getExceptionDiagnosis().getStackLineHashAsHex()).append(" or\n\thttp://www.google.co.jp/search?q=").append(this.getExceptionDiagnosis().getLineNumberHashAsHex()).toString()).append("\nTwitterException{").append(this.nested ? "" : new StringBuffer().append("exceptionCode=[").append(this.getExceptionCode()).append("], ").toString()).append("statusCode=").append(this.statusCode).append(", retryAfter=").append(this.retryAfter).append(", rateLimitStatus=").append(this.rateLimitStatus).append(", version=").append(Version.getVersion()).append('}').toString();
    }

    private static String getCause(HttpResponse res) {
        String cause;
        int statusCode = res.getStatusCode();
        switch (statusCode) {
            case 304: {
                cause = "There was no new data to return.";
                break;
            }
            case 400: {
                cause = "The request was invalid.  An accompanying error message will explain why. This is the status code will be returned during rate limiting.";
                break;
            }
            case 401: {
                cause = "Authentication credentials (http://dev.twitter.com/pages/auth) were missing or incorrect. Ensure that you have set valid conumer key/secret, access token/secret, and the system clock in in sync.";
                break;
            }
            case 403: {
                cause = "The request is understood, but it has been refused. An accompanying error message will explain why. This code is used when requests are being denied due to update limits (http://support.twitter.com/forums/10711/entries/15364).";
                break;
            }
            case 404: {
                cause = "The URI requested is invalid or the resource requested, such as a user, does not exist.";
                break;
            }
            case 406: {
                cause = "Returned by the Search API when an invalid format is specified in the request.\nReturned by the Streaming API when one or more of the parameters are not suitable for the resource. The track parameter, for example, would throw this error if:\n The track keyword is too long or too short.\n The bounding box specified is invalid.\n No predicates defined for filtered resource, for example, neither track nor follow parameter defined.\n Follow userid cannot be read.";
                break;
            }
            case 413: {
                cause = "A parameter list is too long. The track parameter, for example, would throw this error if:\n Too many track tokens specified for role; contact API team for increased access.\n Too many bounding boxes specified for role; contact API team for increased access.\n Too many follow userids specified for role; contact API team for increased access.";
                break;
            }
            case 420: {
                cause = "Returned by the Search and Trends API when you are being rate limited (http://dev.twitter.com/pages/rate-limiting).\nReturned by the Streaming API:\n Too many login attempts in a short period of time.\n Running too many copies of the same application authenticating with the same account name.";
                break;
            }
            case 500: {
                cause = "Something is broken. Please post to the group (http://dev.twitter.com/pages/support) so the Twitter team can investigate.";
                break;
            }
            case 502: {
                cause = "Twitter is down or being upgraded.";
                break;
            }
            case 503: {
                cause = "The Twitter servers are up, but overloaded with requests. Try again later.";
                break;
            }
            default: {
                cause = "";
            }
        }
        return new StringBuffer().append(statusCode).append(":").append(cause).toString();
    }
}

