type t = [ `Binary | `Ascii | `Jis | `Euc | `Sjis | `Utf8 | `Utf16 | `Unknown ]

external nkf: string -> string -> string = "ocaml_nkf_kconv"

external guess: string -> string = "ocaml_nkf_guess"

external nkf_version: unit -> string = "ocaml_nkf_nkf_version"

external version: unit -> string = "ocaml_nkf_version"

let guess_t str : t =
  let r = guess str in
    match r with
      | "BINARY"      -> `Binary
      | "ASCII"       -> `Ascii
      | "ISO-2022-JP" -> `Jis
      | "EUC-JP"      -> `Euc
      | "Shift_JIS"   -> `Sjis
      | "UTF-8"       -> `Utf8
      | "UTF-16"      -> `Utf16
      | _             -> `Unknown
