package jp.android_group.artoolkit.hardware;

import android.graphics.PixelFormat;
import android.hardware.Camera;
import android.hardware.Camera.Parameters;
import android.hardware.Camera.PictureCallback;
import android.hardware.Camera.PreviewCallback;
import android.hardware.Camera.Size;
import android.os.Message;
import android.util.Log;

/**
 * It is implementing of CameraIF for Camera classe. 
 * R33.
 * 
 * @author noritsuna
 *
 */
public class AttachedCamera implements CameraIF {

	private Camera camera = null;
	private PreviewCallback cb = null;
	private CaptureThread mCaptureThread = null;

	private RawPictureCallback mRawPictureCallback = new RawPictureCallback();
	private final class RawPictureCallback implements PictureCallback { 
		public void onPictureTaken(byte [] rawData, Camera camera) {
			if(cb != null && rawData != null) {
				Log.d("RawPictureCallback", "data= OK");
				cb.onPreviewFrame(rawData, camera);
			} else {
				try {
					// The measure against over load. 
					Thread.sleep(300);
				} catch (InterruptedException e) {
					;
				}
			}
			
			// notify takePicture loop.
			synchronized(mCaptureThread) {
				mCaptureThread.notify();
			}
		}
	};
	
	private JpegPictureCallback mJpegPictureCallback = new JpegPictureCallback();
	private final class JpegPictureCallback implements PictureCallback {
		public void onPictureTaken(byte [] jpegData, Camera camera) {
			if(cb != null && jpegData != null) {
				Log.d("mJpegPictureCallback", "data= OK");
				cb.onPreviewFrame(jpegData, camera);
			} else {
				try {
					// The measure against over load. 
					Thread.sleep(500);
				} catch (InterruptedException e) {
					;
				}
			}
			
			// notify takePicture loop.
			synchronized(mCaptureThread) {
				mCaptureThread.notify();
			}
		}
	};
	
	public AttachedCamera() {
		camera = Camera.open();
		Parameters param = camera.getParameters();
		Size size = param.getPictureSize();
		float ratio = size.height/320;
		param.setPictureSize((int)(size.width/ratio), (int)(size.height/ratio));
		param.setPictureFormat(PixelFormat.JPEG);
		camera.setParameters(param);
	}
	public AttachedCamera(int w, int h) {
		camera = Camera.open();
		Parameters param = camera.getParameters();
		Size size = param.getPictureSize();
		param.setPictureSize(size.width, size.height);
		param.setPictureFormat(PixelFormat.JPEG);
		camera.setParameters(param);
	}

	@Override
	public Parameters getParameters() {
		return camera.getParameters();
	}

	@Override
	public void onDestroy() {
		camera.release();
	}

	@Override
	public void setParameters(Parameters params) {
		camera.setParameters(params);
	}

	@Override
	public void setPreviewCallback(PreviewCallback cb) {
		this.cb = cb;
		
	}

	@Override
	public void onStart() {
		Log.d("AttachedCamera", "call onStart");
		if(this.mCaptureThread == null) {
			this.mCaptureThread = new CaptureThread();
		}
		if(this.mCaptureThread.mDone) {
			this.mCaptureThread.mDone = false;
			this.mCaptureThread.start();
		}
	}

	@Override
	public void onStop() {
		Log.d("AttachedCamera", "call onStop");
		this.mCaptureThread.mDone = true;
	}
	
	@Override
	public void onPause() {
		this.onStop();
	}
	@Override
	public void onResume() {
		this.onStart();
	}



	@Override
	public void resetPreviewSize(int width, int height) {
		// TODO Auto-generated method stub
		
	}
	

	@Override
	public void handleMessage(Message msg) {
		// TODO Auto-generated method stub
		
	}

	
	
	private class CaptureThread extends Thread {
		private boolean mDone = true;
		
		public CaptureThread() {
			super();
			Log.d("CaptureThread", "new");
		}
		@Override
		public void run() {
			Log.d("CaptureThread", "in capture thread");
			while(!mDone) {
				// Take picture.
//				camera.takePicture(null, mRawPictureCallback, null);
				camera.takePicture(null, null, mJpegPictureCallback);
				synchronized(mCaptureThread) {
					try {
						// Wait until processing of ARToolkit finishes. 
						mCaptureThread.wait();
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		}
	}

}
