package jp.android_group.artoolkit;

import java.io.InputStream;

import jp.android_group.artoolkit.hardware.AttachedCamera;
import jp.android_group.artoolkit.hardware.CameraIF;
import jp.android_group.artoolkit.hardware.Dev1Camera;
import jp.android_group.artoolkit.hardware.SocketCamera;
import jp.android_group.artoolkit.hardware.StaticCamera;
import jp.android_group.artoolkit.view.GLSurfaceView;
import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PixelFormat;
import android.hardware.Camera;
import android.hardware.Camera.PreviewCallback;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.OrientationListener;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;

public class NyARToolkitAndroidActivity extends Activity implements View.OnClickListener, SurfaceHolder.Callback {
	
	public static final String TAG = "camera";
	
	public static final int CROP_MSG = 1;
	public static final int KEEP = 2;
	public static final int RESTART_PREVIEW = 3;
	public static final int CLEAR_SCREEN_DELAY = 4;
	public static final int SHOW_LOADING = 5;
	public static final int HIDE_LOADING = 6;
	

	private OrientationListener mOrientationListener;
	private int mLastOrientation = OrientationListener.ORIENTATION_UNKNOWN;
	
	private CameraIF mCameraDevice;
	private GLSurfaceView mGLSurfaceView;
	private ModelRenderer mRenderer;

	private PreviewCallback mPreviewCallback = new JpegPreviewCallback();


	private ARToolkitDrawer arToolkit = null;
	
	private Handler mHandler = new MainHandler(); 

	private boolean isUseSerface = false;
	
	private boolean drawFlag = false;
	

//----------------------- Override Methods ------------------------
	
	/** Called with the activity is first created. */
	@Override
	public void onCreate(Bundle icicle) {
		super.onCreate(icicle);

		// Renderer
		mRenderer = new ModelRenderer(false, getAssets(), "miku01.mqo", 0.01f);
		mRenderer.setMainHandler(mHandler);

		requestWindowFeature(Window.FEATURE_PROGRESS);
		
		Window win = getWindow();
		win.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
		
		// init Camera.
		if(getString(R.string.camera_name).equals("jp.android_group.artoolkit.hardware.SocketCamera")) {
			mCameraDevice = new SocketCamera(getString(R.string.server_addr),
					Integer.valueOf(getString(R.string.server_port)));
			setContentView(R.layout.camera);
			mGLSurfaceView = (GLSurfaceView) findViewById(R.id.GL_view);
			// OpenGL Verw
			mGLSurfaceView.setRenderer(mRenderer);
			mGLSurfaceView.getHolder().setFormat(PixelFormat.RGBA_8888);
			
		} else if(getString(R.string.camera_name).equals("jp.android_group.artoolkit.hardware.AttachedCamera")) {
			mCameraDevice = new AttachedCamera(320, 240);
			setContentView(R.layout.camera);
			mGLSurfaceView = (GLSurfaceView) findViewById(R.id.GL_view);
			// OpenGL Verw
			mGLSurfaceView.setRenderer(mRenderer);
			mGLSurfaceView.getHolder().setFormat(PixelFormat.RGBA_8888);
			
		} else if(getString(R.string.camera_name).equals("jp.android_group.artoolkit.hardware.StaticCamera")) {
			mCameraDevice = new StaticCamera(getAssets());
			setContentView(R.layout.camera);
			mGLSurfaceView = (GLSurfaceView) findViewById(R.id.GL_view);
			// OpenGL Verw
			mGLSurfaceView.setRenderer(mRenderer);
			mGLSurfaceView.getHolder().setFormat(PixelFormat.RGBA_8888);
			
		} else if(getString(R.string.camera_name).equals("jp.android_group.artoolkit.hardware.Dev1Camera")) {
			isUseSerface = true;
			setContentView(R.layout.devonecamera);
			SurfaceView mSurfaceView = (SurfaceView) findViewById(R.id.DEV1_camera_preview);
			
			mCameraDevice = new Dev1Camera(this, mSurfaceView);

			// OpenGL Verw
			mGLSurfaceView = (GLSurfaceView) findViewById(R.id.DEV1_GL_view);
			mGLSurfaceView.setRenderer(mRenderer);
			
		} else {
			isUseSerface = true;
			setContentView(R.layout.devonecamera);
			SurfaceView mSurfaceView = (SurfaceView) findViewById(R.id.DEV1_camera_preview);
			
			mCameraDevice = new Dev1Camera(this, mSurfaceView);
			
			// OpenGL Verw
			mGLSurfaceView = (GLSurfaceView) findViewById(R.id.DEV1_GL_view);
			mGLSurfaceView.setRenderer(mRenderer);
		}
		
		
		mOrientationListener = new OrientationListener(this) {
			public void onOrientationChanged(int orientation) {
				mLastOrientation = orientation;
			}
		};
		
		
		
		mCameraDevice.setPreviewCallback(mPreviewCallback);
		
		// init ARToolkit.
		InputStream camePara = getResources().openRawResource(
				R.raw.camera_para);
		InputStream patt = getResources().openRawResource(
				R.raw.patt);
		arToolkit = new ARToolkitDrawer(camePara, patt, mRenderer);
		
		
		
		//TODO init VoicePlayer for ARToolkit.
//		VoicePlayer mVoiceSound = new VoicePlayer();
//		mVoiceSound.initVoice(getResources().openRawResourceFd(R.raw.xxx_voice));
//		arToolkit.setVoicePlayer(mVoiceSound);
		
	}
	
	@Override
	public void onStart() {
		super.onStart();
		mCameraDevice.onStart();
		draw();
	}
	
	@Override
	public void onResume() {
		super.onResume();
		Log.d("Main", "onResume");
		
		mOrientationListener.enable();
		mCameraDevice.onResume();
		draw();
	}

	@Override
	public void onStop() {
		mCameraDevice.onStop();
		super.onStop();
	}

	@Override
	protected void onPause() {
		mOrientationListener.disable();
		mCameraDevice.onPause();
		super.onPause();
	}
	
	@Override  
	protected void onDestroy() {
		mCameraDevice.onDestroy();
		super.onDestroy();
	}
	
	@Override
	public void onClick(View v) {
		;;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		switch (requestCode) {
			case CROP_MSG: {
				Intent intent = new Intent();
				if (data != null) {
					Bundle extras = data.getExtras();
					if (extras != null) {
						intent.putExtras(extras);
					}
				}
				setResult(resultCode, intent);
				finish();
				break;
			}
		}
	}

	@Override
	public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
		Log.d("Main", "surfaceChanged");
		if(!isUseSerface) {
			return;
		}
		
		if(mCameraDevice instanceof Dev1Camera) {
			Dev1Camera cam = (Dev1Camera)mCameraDevice;
			cam.surfaceChanged(holder, format, w, h);
		}
	}

	@Override
	public void surfaceCreated(SurfaceHolder holder) {
		if(!isUseSerface) {
			return;
		}
		if(mCameraDevice instanceof Dev1Camera) {
			Dev1Camera cam = (Dev1Camera)mCameraDevice;
			cam.surfaceCreated(holder);
		}
	}

	@Override
	public void surfaceDestroyed(SurfaceHolder holder) {
		if(!isUseSerface) {
			return;
		}
		if(mCameraDevice instanceof Dev1Camera) {
			Dev1Camera cam = (Dev1Camera)mCameraDevice;
			cam.surfaceDestroyed(holder);
		}
	}
	
	
	
	
// ---------------------- getter & setter ---------------------------	

	public int getLastOrientation() {
		return mLastOrientation;
	}
	
	
// ---------------------------- Utils ---------------------------------	

	public static int roundOrientation(int orientationInput) {
		Log.d("roundOrientation", "orientationInput:" + orientationInput);
		int orientation = orientationInput;
		if (orientation == -1)
			orientation = 0;
		
		orientation = orientation % 360;
		int retVal;
		if (orientation < (0*90) + 45) {
			retVal = 0;
		} else if (orientation < (1*90) + 45) {
			retVal = 90;
		} else if (orientation < (2*90) + 45) {
			retVal = 180;
		} else if (orientation < (3*90) + 45) {
			retVal = 270;
		} else {
			retVal = 0;
		}

		return retVal;
	}	
	public static Matrix GetDisplayMatrix(Bitmap b, ImageView v) {
		Matrix m = new Matrix();
		float bw = (float)b.getWidth();
		float bh = (float)b.getHeight();
		float vw = (float)v.getWidth();
		float vh = (float)v.getHeight();
		float scale, x, y;
		if (bw*vh > vw*bh) {
			scale = vh / bh;
			x = (vw - scale*bw)*0.5F;
			y = 0;
		} else {
			scale = vw / bw;
			x = 0;
			y = (vh - scale*bh)*0.5F;
		}
		m.setScale(scale, scale, 0.5F, 0.5F);
		m.postTranslate(x, y);
		return m;
	}
		
	private void draw() {
		drawFlag = true;
		try {
			// The measure against over load. 
			Thread.sleep(50);
		} catch (InterruptedException e) {
			;
		}
		drawFlag = false;
		mGLSurfaceView.queueEvent(new Runnable() {
			@Override
			public void run() {
				while (!drawFlag) 
					try {
						Thread.sleep(40);
					} catch (InterruptedException e) {
						;
					}
				}
			}
		);
		
	}
	
// ---------------------------- Callback classes ---------------------------------	
	
	
	private final class JpegPreviewCallback implements PreviewCallback {

		@Override
		public void onPreviewFrame(byte [] jpegData, Camera camera) {
			Log.d("JpegPreviewCallback", "in JpegPreviewCallback...");
			
			if(jpegData != null) {
				Log.d("JpegPreviewCallback", "data= OK");
				arToolkit.draw(jpegData);
				draw();
			} else {
				try {
					// The measure against over load. 
					Thread.sleep(500);
				} catch (InterruptedException e) {
					;
				}
			}
		}

	};	
	


	
	
// ---------------------------- Handler classes ---------------------------------	
	
	/** This Handler is used to post message back onto the main thread of the application */
	private class MainHandler extends Handler {
		@Override
		public void handleMessage(Message msg) {
			mCameraDevice.handleMessage(msg);
			switch (msg.what) {
				case KEEP: {
					if (msg.obj != null) {
						mHandler.post((Runnable)msg.obj);
					}
					break;
				}
			
				case CLEAR_SCREEN_DELAY: {
					getWindow().clearFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
					break;
				}
				case SHOW_LOADING: {
					showDialog(DIALOG_LOADING);
					break;
				}
				case HIDE_LOADING: {
					try {
						dismissDialog(DIALOG_LOADING);
						removeDialog(DIALOG_LOADING);
					} catch (IllegalArgumentException e) {
					}
					break;
				}
			}
		}
	}

	public Handler getMessageHandler() {
		return this.mHandler;
	}
	
	
	
	private static final int DIALOG_LOADING = 0;

	@Override
	protected Dialog onCreateDialog(int id) {
		switch (id) {
		case DIALOG_LOADING: {
			ProgressDialog dialog = new ProgressDialog(this);
			dialog.setMessage("Loading ...");
			// dialog.setIndeterminate(true);
			dialog.setCancelable(false);
			dialog.getWindow().setFlags
				(WindowManager.LayoutParams.FLAG_BLUR_BEHIND,
				 WindowManager.LayoutParams.FLAG_BLUR_BEHIND);
			return dialog;
		}
		default:
			return super.onCreateDialog(id);
		}
	}
	
}

