/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.util.GLLib;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLUtils;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import javax.microedition.khronos.opengles.GL11;

public class KGLTextures {
    public AssetManager am;
    private HashMap<String, Integer> texPool = null;

    public KGLTextures(AssetManager am) {
        this.am = am;
        this.texPool = new HashMap();
    }

    public void Clear(GL11 gl) {
        Collection<Integer> collection = this.texPool.values();
        Integer[] ciarray = collection.toArray(new Integer[0]);
        if (ciarray.length == 0) {
            return;
        }
        int[] iarray = new int[ciarray.length];
        int i = 0;
        while (i < iarray.length) {
            iarray[i] = ciarray[i];
            ++i;
        }
        gl.glDeleteTextures(iarray.length, iarray, 0);
        this.texPool.clear();
    }

    public int getGLTexture(GL11 gl, String texname, String alpname, boolean reload) {
        Bitmap bitmap;
        if (texname == null && alpname == null) {
            return 0;
        }
        Integer ret = 0;
        ret = this.texPool.get(String.valueOf(texname) + alpname);
        if (!reload) {
            if (ret != null) {
                return ret;
            }
        } else if (ret != null) {
            gl.glBindTexture(3553, 0);
            this.glDeleteTexture(gl, ret);
            this.texPool.remove(String.valueOf(texname) + alpname);
            ret = 0;
        }
        if ((bitmap = this.loadTexture(texname, alpname)) == null) {
            return 0;
        }
        ret = this.glGenTexture(gl);
        if (ret == 0) {
            return 0;
        }
        gl.glBindTexture(3553, ret.intValue());
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        gl.glBindTexture(3553, 0);
        this.texPool.put(String.valueOf(texname) + alpname, ret);
        return ret;
    }

    private int glGenTexture(GL11 gl) {
        int[] texs = new int[1];
        gl.glGenTextures(1, texs, 0);
        return texs[0];
    }

    private void glDeleteTexture(GL11 gl, int tex) {
        int[] texs = new int[]{tex};
        gl.glDeleteTextures(1, texs, 0);
    }

    protected Bitmap loadTexture(String texname, String alpname) {
        try {
            InputStream is = this.am.open(texname);
            return BitmapFactory.decodeStream((InputStream)is);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void reset(GL11 gl, String texname, String alpname) {
        Integer ret = 0;
        ret = this.texPool.get(String.valueOf(texname) + alpname);
        if (ret != null) {
            if (gl != null) {
                gl.glBindTexture(3553, 0);
                this.glDeleteTexture(gl, ret);
            }
            this.texPool.remove(String.valueOf(texname) + alpname);
        }
    }
}

