/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.util.GLLib;

class KGLPoint {
    private float[] data = null;

    public KGLPoint(int in_num) {
        this.data = new float[in_num];
    }

    public KGLPoint(KGLPoint source) {
        this.data = new float[source.getData().length];
        this.set(source.getData());
    }

    public static KGLPoint create(KGLPoint in_data) {
        KGLPoint ret = new KGLPoint(in_data.data.length);
        ret.set(in_data.getData());
        return ret;
    }

    public static KGLPoint create(float[] in_data) {
        KGLPoint ret = new KGLPoint(in_data.length);
        ret.set(in_data);
        return ret;
    }

    public static KGLPoint createUV(float U, float V) {
        KGLPoint ret = new KGLPoint(2);
        ret.set_UV(U, V);
        return ret;
    }

    public static KGLPoint createXYZ(float X, float Y, float Z) {
        KGLPoint ret = new KGLPoint(3);
        ret.set_XYZ(X, Y, Z);
        return ret;
    }

    public static KGLPoint createCOLOR(float R, float G, float B) {
        KGLPoint ret = new KGLPoint(3);
        ret.set_COLOR(R, G, B);
        return ret;
    }

    public static KGLPoint createCOLOR(float R, float G, float B, float A) {
        KGLPoint ret = new KGLPoint(4);
        ret.set_COLOR(R, G, B, A);
        return ret;
    }

    public KGLPoint normalize() {
        double add = 0.0;
        int i = 0;
        while (i < this.data.length) {
            add += (double)(this.data[i] * this.data[i]);
            ++i;
        }
        double len = Math.sqrt(add);
        if (len == 0.0) {
            return this;
        }
        i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = (float)((double)this.data[n] / len);
        }
        return this;
    }

    public static KGLPoint vector(KGLPoint from, KGLPoint to) {
        float[] d_to;
        KGLPoint ret = null;
        float[] d_from = from.getData();
        if (d_from.length != (d_to = to.getData()).length) {
            return null;
        }
        float[] d_ret = new float[d_from.length];
        int i = 0;
        while (i < d_ret.length) {
            d_ret[i] = d_to[i] - d_from[i];
            ++i;
        }
        ret = new KGLPoint(d_ret.length);
        ret.set(d_ret);
        return ret;
    }

    protected float[] getData() {
        return this.data;
    }

    public KGLPoint set(KGLPoint src) {
        System.arraycopy(src.data, 0, this.data, 0, this.data.length < src.data.length ? this.data.length : src.data.length);
        return this;
    }

    public KGLPoint set(float[] src) {
        System.arraycopy(src, 0, this.data, 0, this.data.length < src.length ? this.data.length : src.length);
        return this;
    }

    public KGLPoint set_XYZ(float x, float y, float z) {
        this.data[0] = x;
        this.data[1] = y;
        this.data[2] = z;
        return this;
    }

    public KGLPoint set_UV(float u, float v) {
        this.data[0] = u;
        this.data[1] = v;
        return this;
    }

    public KGLPoint set_COLOR(float r, float g, float b) {
        this.data[0] = r;
        this.data[1] = g;
        this.data[2] = b;
        return this;
    }

    public KGLPoint set_COLOR(float r, float g, float b, float a) {
        this.data[0] = r;
        this.data[1] = g;
        this.data[2] = b;
        this.data[3] = a;
        return this;
    }

    public KGLPoint add(KGLPoint in) {
        int i = 0;
        while (i < in.data.length || i < this.data.length) {
            int n = i;
            this.data[n] = this.data[n] + in.data[i];
            ++i;
        }
        return this;
    }

    public KGLPoint add(float[] in) {
        int i = 0;
        while (i < in.length || i < this.data.length) {
            int n = i;
            this.data[n] = this.data[n] + in[i];
            ++i;
        }
        return this;
    }

    public KGLPoint scale(float in) {
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] * in;
        }
        return this;
    }

    public float X() {
        return this.data[0];
    }

    public float Y() {
        return this.data[1];
    }

    public float Z() {
        return this.data[2];
    }

    public float U() {
        return this.data[0];
    }

    public float V() {
        return this.data[1];
    }

    public float R() {
        return this.data[0];
    }

    public float G() {
        return this.data[1];
    }

    public float B() {
        return this.data[2];
    }

    public float A() {
        return this.data[3];
    }

    public String toString() {
        String ret = "[";
        int i = 0;
        while (i < this.data.length) {
            ret = String.valueOf(ret) + Float.toString(this.data[i]);
            if (i + 1 < this.data.length) {
                ret = String.valueOf(ret) + ", ";
            }
            ++i;
        }
        ret = String.valueOf(ret) + "]";
        return ret;
    }
}

