/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.util.GLLib;

import android.content.res.AssetManager;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import javax.microedition.khronos.opengles.GL11;
import jp.nyatla.util.GLLib.KGLException;
import jp.nyatla.util.GLLib.KGLModelData;
import jp.nyatla.util.GLLib.KGLPoint;
import jp.nyatla.util.GLLib.KGLTextures;

public class KGLMetaseq
extends KGLModelData {
    protected String getDoubleQuoatString(String st) {
        String ret = st.trim();
        if (ret.charAt(0) != '\"') {
            return ret;
        }
        int p = ret.indexOf("\"", 1);
        return ret.substring(1, p);
    }

    protected KGLPoint calcNormal(KGLPoint[] V, int A, int B, int C) {
        KGLPoint ret = null;
        KGLPoint BA = null;
        KGLPoint BC = null;
        BA = KGLPoint.vector(V[B], V[A]);
        BC = KGLPoint.vector(V[B], V[C]);
        ret = KGLPoint.createXYZ(BA.Y() * BC.Z() - BA.Z() * BC.Y(), BA.Z() * BC.X() - BA.X() * BC.Z(), BA.X() * BC.Y() - BA.Y() * BC.X());
        ret.normalize();
        return ret;
    }

    protected KGLPoint[] vNormal(objects mqoObj) {
        KGLPoint[] ret = null;
        KGLPoint sn = null;
        ret = new KGLPoint[mqoObj.vertex.length];
        int f = 0;
        while (f < mqoObj.face.length) {
            sn = this.calcNormal(mqoObj.vertex, mqoObj.face[f].V[0], mqoObj.face[f].V[1], mqoObj.face[f].V[2]);
            if (sn != null) {
                int i = 0;
                while (i < 3) {
                    if (ret[mqoObj.face[f].V[i]] == null) {
                        ret[mqoObj.face[f].V[i].intValue()] = KGLPoint.createXYZ(0.0f, 0.0f, 0.0f);
                    }
                    ret[mqoObj.face[f].V[i]].add(sn);
                    ++i;
                }
            }
            ++f;
        }
        int v = 0;
        while (v < ret.length) {
            if (ret[v] != null) {
                ret[v].normalize();
            }
            ++v;
        }
        return ret;
    }

    protected void dataSetter(Object obj, Field fl, Class ty, String data) throws IllegalArgumentException, IllegalAccessException {
        if (ty.toString().equals("class java.lang.Integer")) {
            fl.set(obj, Integer.parseInt(data));
        }
        if (ty.toString().equals("class java.lang.Float")) {
            fl.set(obj, Float.valueOf(Float.parseFloat(data)));
        }
        if (ty.toString().equals("class java.lang.String")) {
            fl.set(obj, this.getDoubleQuoatString(data));
        }
        if (ty.toString().equals("class [Ljava.lang.Float;")) {
            String[] s = data.split(" ");
            Float[] f = new Float[s.length];
            int i = 0;
            while (i < s.length) {
                f[i] = Float.valueOf(Float.parseFloat(s[i]));
                ++i;
            }
            fl.set(obj, f);
        }
    }

    private KGLModelData.GLMaterial makeMats(GL11 gl, material mqomat, int i_mqomat, objects mqoObjs, KGLPoint[] vn) {
        KGLModelData.GLMaterial ret = new KGLModelData.GLMaterial(this);
        ArrayList<KGLPoint> apv = new ArrayList<KGLPoint>();
        ArrayList<KGLPoint> apn = new ArrayList<KGLPoint>();
        ArrayList<KGLPoint> apuv = new ArrayList<KGLPoint>();
        ArrayList<KGLPoint> apc = new ArrayList<KGLPoint>();
        KGLPoint wpoint = null;
        boolean uvValid = false;
        boolean colValid = false;
        int f = 0;
        while (f < mqoObjs.face.length) {
            if (mqoObjs.face[f].M != null && mqoObjs.face[f].M == i_mqomat) {
                KGLPoint fn = this.calcNormal(mqoObjs.vertex, mqoObjs.face[f].V[0], mqoObjs.face[f].V[1], mqoObjs.face[f].V[2]);
                int v = 0;
                while (v < 3) {
                    apv.add(mqoObjs.vertex[mqoObjs.face[f].V[v]]);
                    float s = (float)Math.acos(fn.X() * vn[mqoObjs.face[f].V[v]].X() + fn.Y() * vn[mqoObjs.face[f].V[v]].Y() + fn.Z() * vn[mqoObjs.face[f].V[v]].Z());
                    if (mqoObjs.data.facet.floatValue() < s) {
                        apn.add(fn);
                    } else {
                        apn.add(vn[mqoObjs.face[f].V[v]]);
                    }
                    wpoint = new KGLPoint(2);
                    if (mqoObjs.face[f].UV == null) {
                        wpoint.set_UV(0.0f, 0.0f);
                    } else {
                        wpoint.set_UV(mqoObjs.face[f].UV[v * 2 + 0].floatValue(), mqoObjs.face[f].UV[v * 2 + 1].floatValue());
                        uvValid = true;
                    }
                    apuv.add(wpoint);
                    wpoint = new KGLPoint(4);
                    if (mqoObjs.face[f].COL == null) {
                        if (mqomat.data.col == null) {
                            wpoint.set_COLOR(1.0f, 1.0f, 1.0f, 1.0f);
                        } else {
                            wpoint.set_COLOR(mqomat.data.col[0].floatValue(), mqomat.data.col[1].floatValue(), mqomat.data.col[2].floatValue(), mqomat.data.col[3].floatValue());
                        }
                    } else {
                        wpoint.set_COLOR(mqoObjs.face[f].COL[v * 4 + 0].floatValue(), mqoObjs.face[f].COL[v * 4 + 1].floatValue(), mqoObjs.face[f].COL[v * 4 + 2].floatValue(), mqoObjs.face[f].COL[v * 4 + 3].floatValue());
                        colValid = true;
                    }
                    apc.add(wpoint);
                    ++v;
                }
            }
            ++f;
        }
        ret.texID = this.texPool.getGLTexture(gl, mqomat.data.tex, mqomat.data.aplane, false);
        if (ret.texID != 0) {
            ret.texName = mqomat.data.tex;
            ret.alphaTexName = mqomat.data.aplane;
        } else {
            ret.texName = null;
            ret.alphaTexName = null;
        }
        if (apv.size() == 0) {
            return null;
        }
        uvValid &= ret.texID != 0;
        ret.name = mqomat.name;
        KGLPoint[] wfv = null;
        KGLPoint[] wfn = null;
        KGLPoint[] wft = null;
        KGLPoint[] wfc = null;
        wfv = apv.toArray(new KGLPoint[0]);
        wfn = apn.toArray(new KGLPoint[0]);
        wft = apuv.toArray(new KGLPoint[0]);
        wfc = apc.toArray(new KGLPoint[0]);
        ret.vertex_num = wfv.length;
        ret.uvValid = uvValid;
        ret.colValid = colValid;
        ret.vertexBuffer = ByteBuffer.allocateDirect(ret.vertex_num * 3 * 4);
        ret.vertexBuffer.order(ByteOrder.nativeOrder());
        ret.vertexBuffer.position(0);
        ret.normalBuffer = ByteBuffer.allocateDirect(ret.vertex_num * 3 * 4);
        ret.normalBuffer.order(ByteOrder.nativeOrder());
        ret.normalBuffer.position(0);
        if (uvValid) {
            ret.uvBuffer = ByteBuffer.allocateDirect(ret.vertex_num * 2 * 4);
            ret.uvBuffer.order(ByteOrder.nativeOrder());
            ret.uvBuffer.position(0);
        }
        if (colValid) {
            ret.colBuffer = ByteBuffer.allocateDirect(ret.vertex_num * 4 * 4);
            ret.colBuffer.order(ByteOrder.nativeOrder());
            ret.colBuffer.position(0);
        }
        int v = 0;
        while (v < ret.vertex_num) {
            ret.vertexBuffer.putFloat(wfv[v].X());
            ret.vertexBuffer.putFloat(wfv[v].Y());
            ret.vertexBuffer.putFloat(wfv[v].Z());
            ret.normalBuffer.putFloat(wfn[v].X());
            ret.normalBuffer.putFloat(wfn[v].Y());
            ret.normalBuffer.putFloat(wfn[v].Z());
            if (uvValid) {
                ret.uvBuffer.putFloat(wft[v].U());
                ret.uvBuffer.putFloat(wft[v].V());
            }
            if (colValid) {
                ret.colBuffer.putFloat(wfc[v].R());
                ret.colBuffer.putFloat(wfc[v].G());
                ret.colBuffer.putFloat(wfc[v].B());
                ret.colBuffer.putFloat(wfc[v].A());
            }
            ++v;
        }
        if (mqomat.data.col != null) {
            ret.color = new float[mqomat.data.col.length];
            int c = 0;
            while (c < mqomat.data.col.length) {
                ret.color[c] = mqomat.data.col[c].floatValue();
                ++c;
            }
            if (mqomat.data.dif != null) {
                ret.dif = new float[mqomat.data.col.length];
                c = 0;
                while (c < mqomat.data.col.length) {
                    ret.dif[c] = mqomat.data.dif.floatValue() * mqomat.data.col[c].floatValue();
                    ++c;
                }
                ret.dif[3] = mqomat.data.col[3].floatValue();
            }
            if (mqomat.data.amb != null) {
                ret.amb = new float[mqomat.data.col.length];
                c = 0;
                while (c < mqomat.data.col.length) {
                    ret.amb[c] = mqomat.data.amb.floatValue() * mqomat.data.col[c].floatValue();
                    ++c;
                }
            }
            if (mqomat.data.emi != null) {
                ret.emi = new float[mqomat.data.col.length];
                c = 0;
                while (c < mqomat.data.col.length) {
                    ret.emi[c] = mqomat.data.emi.floatValue() * mqomat.data.col[c].floatValue();
                    ++c;
                }
            }
            if (mqomat.data.spc != null) {
                ret.spc = new float[mqomat.data.col.length];
                c = 0;
                while (c < mqomat.data.col.length) {
                    ret.spc[c] = mqomat.data.spc.floatValue() * mqomat.data.col[c].floatValue();
                    ++c;
                }
            }
        }
        if (mqomat.data.pow != null) {
            ret.power = new float[1];
            ret.power[0] = mqomat.data.pow.floatValue();
        }
        ret.shadeMode_IsSmooth = true;
        if (mqoObjs.data.shading == 0) {
            ret.shadeMode_IsSmooth = false;
        }
        return ret;
    }

    private KGLModelData.GLObject makeObjs(GL11 gl, material[] mqoMats, objects mqoObjs) {
        KGLModelData.GLObject ret = null;
        ArrayList<KGLModelData.GLMaterial> mats = new ArrayList<KGLModelData.GLMaterial>();
        KGLPoint[] vn = null;
        vn = this.vNormal(mqoObjs);
        int m = 0;
        while (m < mqoMats.length) {
            KGLModelData.GLMaterial mr = this.makeMats(gl, mqoMats[m], m, mqoObjs, vn);
            if (mr != null) {
                mats.add(mr);
            }
            ++m;
        }
        if (mats.size() == 0) {
            return null;
        }
        ret = new KGLModelData.GLObject(this);
        ret.name = mqoObjs.name;
        ret.mat = mats.toArray(new KGLModelData.GLMaterial[0]);
        ret.isVisible = mqoObjs.data.visible != 0;
        return ret;
    }

    protected KGLMetaseq(GL11 gl, KGLTextures in_texPool, AssetManager am, String msqname, float scale) {
        super(in_texPool, am, scale);
        material[] mats = null;
        InputStream fis = null;
        KGLModelData.multiInput br = null;
        String[] chankName = null;
        KGLModelData.GLObject glo = null;
        ArrayList<KGLModelData.GLObject> globjs = new ArrayList<KGLModelData.GLObject>();
        try {
            try {
                fis = am.open(msqname);
                br = new KGLModelData.multiInput(this, fis);
                while ((chankName = this.Chank(br, false)) != null) {
                    if (chankName[0].trim().toUpperCase().equals("MATERIAL")) {
                        try {
                            mats = new material[Integer.parseInt(chankName[1])];
                            int m = 0;
                            while (m < mats.length) {
                                mats[m] = new material();
                                mats[m].set(br.readLine().trim());
                                ++m;
                            }
                        }
                        catch (Exception mat_e) {
                            Log.e((String)"KGLMetaseq", (String)"MQO\u30d5\u30a1\u30a4\u30eb\u3000Material\u30c1\u30e3\u30f3\u30af\u8aad\u307f\u8fbc\u307f\u4f8b\u5916\u767a\u751f ", (Throwable)mat_e);
                            throw new KGLException(mat_e);
                        }
                    }
                    try {
                        if (!chankName[0].trim().toUpperCase().equals("OBJECT")) continue;
                        objects object = new objects();
                        object.set(chankName[1], br, scale);
                        if (object.face == null || (glo = this.makeObjs(gl, mats, object)) == null) continue;
                        globjs.add(glo);
                    }
                    catch (Exception obj_e) {
                        Log.e((String)"KGLMetaseq", (String)("MQO\u30d5\u30a1\u30a4\u30eb\u3000Object[" + chankName[1] + "]\u30c1\u30e3\u30f3\u30af\u8aad\u307f\u8fbc\u307f\u4f8b\u5916\u767a\u751f " + obj_e.toString()), (Throwable)obj_e);
                        throw new KGLException(obj_e);
                    }
                }
                br.close();
                br = null;
                this.glObj = globjs.toArray(new KGLModelData.GLObject[0]);
            }
            catch (Exception e) {
                Log.e((String)"KGLMetaseq", (String)"KGLMetaseq", (Throwable)e);
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    Log.e((String)"KGLMetaseq", (String)"KGLMetaseq", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                Log.e((String)"KGLMetaseq", (String)"KGLMetaseq", (Throwable)e);
            }
        }
    }

    private String[] Chank(KGLModelData.multiInput br, boolean isInner) throws IOException {
        String[] ret = null;
        String[] ws = null;
        String read = null;
        while ((read = br.readLine()) != null) {
            if (read.length() <= 0) continue;
            char c = read.charAt(read.length() - 1);
            if (c == '{') {
                ws = read.split(" ");
                if (ws.length == 2) {
                    ret = new String[]{ws[0].trim(), "{"};
                    break;
                }
                ret = new String[]{ws[0].trim(), read.substring(ws[0].length(), read.length() - 2).trim(), "{"};
                break;
            }
            if (!isInner) continue;
            ws = read.split(" ", 2);
            ret = new String[ws.length];
            int i = 0;
            while (i < ws.length) {
                ret[i] = ws[i].trim();
                ++i;
            }
            break block0;
        }
        return ret;
    }

    private class material {
        String name = null;
        material_data data = new material_data();
        String[] fls_names = null;
        Field[] fls = this.data.getClass().getDeclaredFields();
        Class[] tys = null;

        public material() {
            int len = this.fls.length;
            this.fls_names = new String[len];
            this.tys = new Class[len];
            int i = 0;
            while (i < len) {
                this.fls_names[i] = this.fls[i].getName();
                this.tys[i] = this.fls[i].getType();
                ++i;
            }
        }

        public void set(String line) throws Exception {
            this.name = KGLMetaseq.this.getDoubleQuoatString(line);
            int fn = 0;
            while (fn < this.fls_names.length) {
                int p = line.indexOf(String.valueOf(this.fls_names[fn]) + "(");
                if (p != -1) {
                    int pe = line.indexOf(")", p);
                    KGLMetaseq.this.dataSetter(this.data, this.fls[fn], this.tys[fn], line.substring(p + this.fls_names[fn].length() + 1, pe));
                }
                ++fn;
            }
        }

        public String toString() {
            String ret = this.name;
            if (this.data.shader != null) {
                ret = String.valueOf(ret) + " shader(" + this.data.shader + ")";
            }
            if (this.data.col != null) {
                ret = String.valueOf(ret) + " col(";
                int i = 0;
                while (i < this.data.col.length) {
                    if (i != 0) {
                        ret = String.valueOf(ret) + ", ";
                    }
                    ret = String.valueOf(ret) + this.data.col[i];
                    ++i;
                }
                ret = String.valueOf(ret) + ")";
            }
            if (this.data.dif != null) {
                ret = String.valueOf(ret) + " dif(" + this.data.dif + ")";
            }
            if (this.data.amb != null) {
                ret = String.valueOf(ret) + " amb(" + this.data.amb + ")";
            }
            if (this.data.emi != null) {
                ret = String.valueOf(ret) + " emi(" + this.data.emi + ")";
            }
            if (this.data.spc != null) {
                ret = String.valueOf(ret) + " spc(" + this.data.spc + ")";
            }
            if (this.data.pow != null) {
                ret = String.valueOf(ret) + " pow(" + this.data.pow + ")";
            }
            if (this.data.tex != null) {
                ret = String.valueOf(ret) + " tex(" + this.data.tex + ")";
            }
            if (this.data.aplane != null) {
                ret = String.valueOf(ret) + " aplane(" + this.data.aplane + ")";
            }
            return ret;
        }

        class material_data {
            Integer shader = null;
            Float[] col = null;
            Float dif = null;
            Float amb = null;
            Float emi = null;
            Float spc = null;
            Float pow = null;
            String tex = null;
            String aplane = null;

            material_data() {
            }
        }
    }

    private class objects {
        String name = null;
        objects_data data = new objects_data();
        String[] fls_names = null;
        Field[] fls = this.data.getClass().getDeclaredFields();
        Class[] tys = null;
        KGLPoint[] vertex = null;
        Face[] face;

        public objects() {
            int len = this.fls.length;
            this.fls_names = new String[len];
            this.tys = new Class[len];
            int i = 0;
            while (i < len) {
                this.fls_names[i] = this.fls[i].getName();
                this.tys[i] = this.fls[i].getType();
                ++i;
            }
        }

        private KGLPoint[] readVertex(int num, KGLModelData.multiInput br, float scale) throws Exception {
            KGLPoint[] ret = null;
            String line = null;
            ret = new KGLPoint[num];
            int cnt = 0;
            try {
                while ((line = br.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    if (!(line = line.trim()).equals("}")) {
                        String[] s = line.split(" ", 3);
                        ret[cnt] = KGLPoint.createXYZ(Float.parseFloat(s[0]) * scale, Float.parseFloat(s[1]) * scale, Float.parseFloat(s[2]) * scale);
                        ++cnt;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                Log.e((String)"KGLMetaseq", (String)("MQO\u30d5\u30a1\u30a4\u30eb\u3000\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc\uff08Object>vertex\uff09[" + line + "]"), (Throwable)e);
                throw e;
            }
            if (cnt != num) {
                return null;
            }
            return ret;
        }

        private KGLPoint[] readBvertex(KGLModelData.multiInput br, float scale) throws Exception {
            KGLPoint[] ret = null;
            String line = null;
            int datasize = 0;
            try {
                while ((line = br.readLine().trim()) != null) {
                    String[] s;
                    if (line.length() <= 0 || !(s = line.split(" "))[0].equals("Vector")) continue;
                    if (s.length != 3) {
                        line = null;
                    } else {
                        int p = s[2].indexOf("[");
                        int pe = s[2].indexOf("]");
                        datasize = Integer.parseInt(s[2].substring(p + 1, pe));
                    }
                    break;
                }
            }
            catch (Exception e) {
                Log.e((String)"KGLMetaseq", (String)("MQO\u30d5\u30a1\u30a4\u30eb\u3000\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc\uff08Object>Bvertex\uff09[" + line + "]"), (Throwable)e);
                throw new KGLException(e);
            }
            if (line == null) {
                return null;
            }
            if (datasize == 0) {
                return null;
            }
            byte[] bbuf = new byte[datasize];
            if (datasize != br.read(bbuf)) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.wrap(bbuf);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            FloatBuffer fb = bb.asFloatBuffer();
            ret = new KGLPoint[fb.limit() / 3];
            fb.position(0);
            float[] wf = new float[3];
            int i = 0;
            while (i < ret.length) {
                fb.get(wf);
                ret[i] = KGLPoint.create(wf).scale(scale);
                ++i;
            }
            while ((line = br.readLine().trim()) != null) {
                if (line.equals("}")) break;
            }
            return ret;
        }

        private Face[] readFace(KGLModelData.multiInput br) throws Exception {
            String line = null;
            Face[] wface = null;
            ArrayList<Face> qf = new ArrayList<Face>();
            try {
                while ((line = br.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    if (!(line = line.trim()).equals("}")) {
                        int pe;
                        wface = null;
                        Integer Mn = null;
                        int p = line.indexOf("M(");
                        if (p != -1) {
                            pe = line.indexOf(")", p);
                            Mn = Integer.parseInt(line.substring(p + 2, pe));
                        }
                        if ((p = line.indexOf("V(")) == -1) continue;
                        pe = line.indexOf(")", p);
                        String[] s = line.substring(p + 2, pe).split(" ");
                        if (s.length == 3) {
                            wface = new Face[]{new Face()};
                            wface[0].V = new Integer[3];
                            wface[0].V[0] = Integer.parseInt(s[0]);
                            wface[0].V[1] = Integer.parseInt(s[1]);
                            wface[0].V[2] = Integer.parseInt(s[2]);
                            wface[0].M = Mn;
                            p = line.indexOf("UV(");
                            if (p != -1) {
                                pe = line.indexOf(")", p);
                                s = line.substring(p + 3, pe).split(" ");
                                if (s.length != 6) {
                                    throw new Exception("UV\u306e\u6570\u304c\u4e0d\u6b63");
                                }
                                wface[0].UV = new Float[6];
                                int i = 0;
                                while (i < s.length) {
                                    wface[0].UV[i] = Float.valueOf(Float.parseFloat(s[i]));
                                    ++i;
                                }
                            }
                            if ((p = line.indexOf("COL(")) != -1) {
                                pe = line.indexOf(")", p);
                                s = line.substring(p + 4, pe).split(" ");
                                if (s.length != 3) {
                                    throw new Exception("COL\u306e\u6570\u304c\u4e0d\u6b63");
                                }
                                wface[0].COL = new Float[12];
                                int i = 0;
                                while (i < s.length) {
                                    long wl = Long.parseLong(s[i]);
                                    float wf = wl >>> 0 & 0xFFL;
                                    wface[0].COL[i * 4 + 0] = Float.valueOf(wf / 255.0f);
                                    wf = wl >>> 8 & 0xFFL;
                                    wface[0].COL[i * 4 + 1] = Float.valueOf(wf / 255.0f);
                                    wf = wl >>> 16 & 0xFFL;
                                    wface[0].COL[i * 4 + 2] = Float.valueOf(wf / 255.0f);
                                    wf = wl >>> 24 & 0xFFL;
                                    wface[0].COL[i * 4 + 3] = Float.valueOf(wf / 255.0f);
                                    ++i;
                                }
                            }
                        }
                        if (s.length == 4) {
                            wface = new Face[]{new Face(), new Face()};
                            wface[0].V = new Integer[3];
                            wface[0].V[0] = Integer.parseInt(s[0]);
                            wface[0].V[1] = Integer.parseInt(s[1]);
                            wface[0].V[2] = Integer.parseInt(s[2]);
                            wface[0].M = Mn;
                            wface[1].V = new Integer[3];
                            wface[1].V[0] = Integer.parseInt(s[0]);
                            wface[1].V[1] = Integer.parseInt(s[2]);
                            wface[1].V[2] = Integer.parseInt(s[3]);
                            wface[1].M = Mn;
                            p = line.indexOf("UV(");
                            if (p != -1) {
                                pe = line.indexOf(")", p);
                                s = line.substring(p + 3, pe).split(" ");
                                if (s.length != 8) {
                                    throw new Exception("UV\u306e\u6570\u304c\u4e0d\u6b63");
                                }
                                wface[0].UV = new Float[6];
                                wface[1].UV = new Float[6];
                                int i = 0;
                                while (i < 2) {
                                    int uv_p = 0;
                                    int j = 0;
                                    while (j < 4) {
                                        if (!(i == 0 && j == 3 || i == 1 && j == 1)) {
                                            wface[i].UV[uv_p++] = Float.valueOf(Float.parseFloat(s[j * 2 + 0]));
                                            wface[i].UV[uv_p++] = Float.valueOf(Float.parseFloat(s[j * 2 + 1]));
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                            }
                            if ((p = line.indexOf("COL(")) != -1) {
                                pe = line.indexOf(")", p);
                                s = line.substring(p + 4, pe).split(" ");
                                if (s.length != 4) {
                                    throw new Exception("COL\u306e\u6570\u304c\u4e0d\u6b63");
                                }
                                wface[0].COL = new Float[12];
                                wface[1].COL = new Float[12];
                                int i = 0;
                                while (i < 2) {
                                    int col_p = 0;
                                    int j = 0;
                                    while (j < s.length) {
                                        if (!(i == 0 && j == 3 || i == 1 && j == 1)) {
                                            long wl = Long.parseLong(s[j]);
                                            float wf = wl >>> 0 & 0xFFL;
                                            wface[i].COL[col_p * 4 + 0] = Float.valueOf(wf / 255.0f);
                                            wf = wl >>> 8 & 0xFFL;
                                            wface[i].COL[col_p * 4 + 1] = Float.valueOf(wf / 255.0f);
                                            wf = wl >>> 16 & 0xFFL;
                                            wface[i].COL[col_p * 4 + 2] = Float.valueOf(wf / 255.0f);
                                            wf = wl >>> 24 & 0xFFL;
                                            wface[i].COL[col_p * 4 + 3] = Float.valueOf(wf / 255.0f);
                                            ++col_p;
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                            }
                        }
                        if (wface == null) continue;
                        int i = 0;
                        while (i < wface.length) {
                            qf.add(wface[i]);
                            ++i;
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                Log.e((String)"KGLMetaseq", (String)("MQO\u30d5\u30a1\u30a4\u30eb\u3000\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc\uff08Object>face\uff09" + e.getMessage() + "[" + line + "]"), (Throwable)e);
                throw e;
            }
            if (qf.size() == 0) {
                return null;
            }
            return qf.toArray(new Face[0]);
        }

        private void set(String in_name, KGLModelData.multiInput br, float scale) throws Exception {
            String[] line;
            this.name = KGLMetaseq.this.getDoubleQuoatString(in_name);
            block0: while ((line = KGLMetaseq.this.Chank(br, true)) != null) {
                if (line[0].equals("}")) break;
                if (line[line.length - 1].equals("{")) {
                    if (line[0].equals("vertex")) {
                        this.vertex = this.readVertex(Integer.parseInt(line[1]), br, scale);
                        continue;
                    }
                    if (line[0].equals("BVertex")) {
                        this.vertex = this.readBvertex(br, scale);
                        continue;
                    }
                    if (line[0].equals("face")) {
                        this.face = this.readFace(br);
                        continue;
                    }
                    String single = null;
                    while ((single = br.readLine()) != null) {
                        if (single.trim().equals("}")) continue block0;
                    }
                    continue;
                }
                int i = 0;
                while (i < this.fls_names.length) {
                    if (this.fls_names[i].equals(line[0])) {
                        KGLMetaseq.this.dataSetter(this.data, this.fls[i], this.tys[i], line[1]);
                    }
                    ++i;
                }
            }
        }

        public String toString() {
            String ret = this.name;
            if (this.data.visible != null) {
                ret = String.valueOf(ret) + " visible(" + this.data.visible + ")";
            }
            if (this.data.color != null) {
                ret = String.valueOf(ret) + " color(";
                int i = 0;
                while (i < this.data.color.length) {
                    if (i != 0) {
                        ret = String.valueOf(ret) + ", ";
                    }
                    ret = String.valueOf(ret) + this.data.color[i];
                    ++i;
                }
                ret = String.valueOf(ret) + ")";
            }
            if (this.data.facet != null) {
                ret = String.valueOf(ret) + " facet(" + this.data.facet + ")";
            }
            return ret;
        }

        class Face {
            Integer[] V = null;
            Integer M = null;
            Float[] UV = null;
            Float[] COL = null;

            Face() {
            }
        }

        class objects_data {
            Integer depth = null;
            Integer folding = null;
            Float[] scale = null;
            Float[] rotation = null;
            Float[] translation = null;
            Integer patch = null;
            Integer segment = null;
            Integer visible = null;
            Integer locking = null;
            Integer shading = null;
            Float facet = null;
            Float[] color = null;
            Integer mirror = null;
            Integer color_type = null;
            Integer mirror_axis = null;
            Float mirror_dis = null;

            objects_data() {
            }
        }
    }
}

