﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;
using System.Web;
using NT2chView.NtFile;

namespace NT2chView.NtNet
{
    public sealed partial class NTHttpAccess
    {
        enum DOWNLOAD_ID_NG
        {
            WORD,
            ID,
            NAME
        }

        public static bool getFavoriteBoards()
        {
            string url;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                url = NTUserPreference.NTUserCloudFileUrl + NTCloud.USER_CLOUD_FAVORITE_BOARD_LIST;

            }else if (NTUserPreference.AESEnabled)
                url = 
                    NTUserPreference.NTCloudUrl + NTCloud.AES_FAVORITE_BOARD_LIST;
            else
                url =
                    NTUserPreference.NTCloudUrl + NTCloud.FAVORITE_BOARD_LIST;


            return getFavorites(url, true, false);
        }

        public static bool getFavoriteThreads()
        {
            string url;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                url = NTUserPreference.NTUserCloudFileUrl + NTCloud.USER_CLOUD_FAVORITE_THREAD_LIST;

            }
            else if (NTUserPreference.AESEnabled)
                url =
                    NTUserPreference.NTCloudUrl + NTCloud.AES_FAVORITE_THREAD_LIST;
            else
                url =
                    NTUserPreference.NTCloudUrl + NTCloud.FAVORITE_THREAD_LIST;

            bool b1 = getFavorites(url, false, false);

            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                url = NTUserPreference.NTUserCloudFileUrl + NTCloud.USER_CLOUD_FAVORITE_THREAD_TAG_LIST;

            }
            else if (NTUserPreference.AESEnabled)
                url =
                    NTUserPreference.NTCloudUrl + NTCloud.AES_FAVORITE_THREAD_TAG_LIST;
            else
                url =
                    NTUserPreference.NTCloudUrl + NTCloud.FAVORITE_THREAD_TAG_LIST;

            bool b2 = getFavorites(url, false, true);
            return b1 && b2;
        }

        public static bool ntGetNgWord()
        {
            string url;
            string filePath;
            string attrPath;
            if (NTUserPreference.AESEnabled)
            {
                url = NTUserPreference.NTCloudUrl + NTCloud.AES_NGWORD_TXT;
                filePath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGWORD_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGWORD_ATTR_FILE_NAME;
            }
            else
            {
                url = NTUserPreference.NTCloudUrl + NTCloud.NGWORD_TXT;
                filePath = NTFileAccess.getRootPath() + NTFileAccess.NGWORD_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.NGWORD_ATTR_FILE_NAME;
            }
            return ntGetNgItem(url, filePath, attrPath);
        }
        public static bool ntGetNgId()
        {
            string url;
            string filePath;
            string attrPath;
            if (NTUserPreference.AESEnabled)
            {
                url = NTUserPreference.NTCloudUrl + NTCloud.AES_NGID_TXT;
                filePath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGID_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGID_ATTR_FILE_NAME;
            }
            else
            {
                url = NTUserPreference.NTCloudUrl + NTCloud.NGID_TXT;
                filePath = NTFileAccess.getRootPath() + NTFileAccess.NGID_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.NGID_ATTR_FILE_NAME;
            }
            return ntGetNgItem(url, filePath, attrPath);
        }
        public static bool ntGetNgName()
        {
            string url;
            string filePath;
            string attrPath;
            if (NTUserPreference.AESEnabled)
            {
                url = NTUserPreference.NTCloudUrl + NTCloud.AES_NGNAME_TXT;
                filePath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGNAME_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGNAME_ATTR_FILE_NAME;
            }
            else
            {
                url = NTUserPreference.NTCloudUrl + NTCloud.NGNAME_TXT;
                filePath = NTFileAccess.getRootPath() + NTFileAccess.NGNAME_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.NGNAME_ATTR_FILE_NAME;
            }
            return ntGetNgItem(url, filePath, attrPath);
        }


        private static bool ntGetNgItem(string url, string filePath, string attrFilePath)
        {
            bool bRet = false;
            Stream stream = null;
            HttpWebResponse httpResp = null;
            NTHttpGetClient httpClient = new NTHttpGetClient(url);

            try
            {
                string ifMod;
                if (NTFileAccess.retrieveAttrFromFile(attrFilePath, out ifMod))
                {
                    if (ifMod != null && ifMod.Length > 0)
                        httpClient.ModifiedSince = ifMod;
                }

                httpClient.AcceptGZip = true;

                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                WebHeaderCollection headers = httpResp.Headers;

                ifMod = headers.Get("Last-Modified");


                stream = httpResp.GetResponseStream();

                if(NTFileAccess.StreamToFile(filePath, stream))
                    NTFileAccess.storeAttrToFile(attrFilePath, ifMod);
                bRet = true;
            }
            catch (System.Net.WebException e)
            {
                if (e.Status == System.Net.WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)e.Response;
                    if (errres.StatusCode == HttpStatusCode.NotModified)
                    {
                        bRet = true;
                    }
                    else
                    {
                        NTDebug.l(e.Message);
                    }
                }
                else
                {
                    NTDebug.l(e.Message);
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }

            return bRet;
        }

        private static bool getFavorites(string address, bool board, bool tag)
        {
            bool bRet = false;
            Stream stream = null;
            HttpWebResponse httpResp = null;
            NTHttpGetClient httpClient = new NTHttpGetClient(address);

            try
            {
                string ifMod;
                bool b;
                if (board)
                {
                    b = NTFileAccess.retrieveFavoriteBoardAttrFromFile(out ifMod);
                }
                else if (!tag)
                {
                    b = NTFileAccess.retrieveFavoriteThreadAttrFromFile(out ifMod);
                }
                else
                {
                    b = NTFileAccess.retrieveFavoriteThreadTagAttrFromFile(out ifMod);
                }
                if (b)
                {
                    if (ifMod != null && ifMod.Length > 0)
                        httpClient.ModifiedSince = ifMod;
                }

                httpClient.AcceptGZip = true;

                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                WebHeaderCollection headers = httpResp.Headers;

                ifMod = headers.Get("Last-Modified");


                stream = httpResp.GetResponseStream();

                if (board)
                    bRet = NTFileAccess.storeFavoriteBoardsToFile(stream, ifMod, false);
                else if(!tag)
                    bRet = NTFileAccess.storeFavoriteThreadsToFile(stream, ifMod, false);
                else
                    bRet = NTFileAccess.storeFavoriteThreadTagToFile(stream, ifMod, false);

            }
            catch (System.Net.WebException e)
            {
                if (e.Status == System.Net.WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)e.Response;
                    if (errres.StatusCode == HttpStatusCode.NotModified)
                    {
                        bRet = true;
                    }
                    else
                    {
                        NTDebug.l(e.Message);
                    }
                }
                else
                {
                    NTDebug.l(e.Message);
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }

            return bRet;
        }

        public static bool getExternalBoards()
        
        {
            string address;

            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                address = NTUserPreference.NTUserCloudFileUrl + NTCloud.USER_CLOUD_EXTERNAL_BOARD_LIST;

            }
            else if (NTUserPreference.AESEnabled)
                address = NTUserPreference.NTCloudUrl + NTCloud.AES_EXTERNAL_BOARD_LIST;
            else
                address = NTUserPreference.NTCloudUrl + NTCloud.EXTERNAL_BOARD_LIST;
            

            bool bRet = false;
            Stream stream = null;
            HttpWebResponse httpResp = null;
            NTHttpGetClient httpClient = new NTHttpGetClient(address);

            try
            {
                string ifMod;
                bool b;
                b = NTFileAccess.retrieveExternalBoardAttrFromFile(out ifMod);
                if (b)
                {
                    if (ifMod != null && ifMod.Length > 0)
                        httpClient.ModifiedSince = ifMod;
                }

                httpClient.AcceptGZip = true;

                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                WebHeaderCollection headers = httpResp.Headers;

                ifMod = headers.Get("Last-Modified");


                stream = httpResp.GetResponseStream();

                bRet = NTFileAccess.storeExternalBoardsToFile(stream, ifMod);
                
            }
            catch (System.Net.WebException e)
            {
                if (e.Status == System.Net.WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)e.Response;
                    if (errres.StatusCode == HttpStatusCode.NotModified)
                    {
                        bRet = true;
                    }
                    else
                    {
                        NTDebug.l(e.Message);
                    }
                }
                else
                {
                    NTDebug.l(e.Message);
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }

            return bRet;
        }

        public static bool getThreadHistoryList()
        {
           // public const string THREAD_HISTORY_LIST_FILE_NAME = @"\ThreadHistory.txt";
           //const string THREAD_HISTORY_LIST_ATTR_FILE_NAME = @"\ThreadHistoryAttr.txt";

            string address;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                address = NTUserPreference.NTUserCloudFileUrl
                    + NTCloud.USER_CLOUD_THREAD_HISTORY_LIST;

            }
            else if (NTUserPreference.AESEnabled)
                address = NTUserPreference.NTCloudUrl + NTCloud.AES_THREAD_HISTORY_LIST;
            else
                address = NTUserPreference.NTCloudUrl + NTCloud.THREAD_HISTORY_LIST;
            

            bool bRet = false;
            Stream stream = null;
            HttpWebResponse httpResp = null;
            NTHttpGetClient httpClient = new NTHttpGetClient(address);

            try
            {
                string ifMod;
                bool b;
                b = NTFileAccess.retrieveThreadHistoryListAttrFromFile(out ifMod);
                if (b)
                {
                    if (ifMod != null && ifMod.Length > 0)
                        httpClient.ModifiedSince = ifMod;
                }

                httpClient.AcceptGZip = true;

                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                WebHeaderCollection headers = httpResp.Headers;

                ifMod = headers.Get("Last-Modified");


                stream = httpResp.GetResponseStream();

                bRet = NTFileAccess.storeThreadHistoryListToFile(stream, ifMod);

            }
            catch (System.Net.WebException e)
            {
                if (e.Status == System.Net.WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)e.Response;
                    if (errres.StatusCode == HttpStatusCode.NotModified)
                    {
                        bRet = true;
                    }
                    else
                    {
                        NTDebug.l(e.Message);
                    }
                }
                else
                {
                    NTDebug.l(e.Message);
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }

            return bRet;
        }


        public static String ntUploadNgWord(string uid, string passwd,
            List<string> ngList, bool append)
        {
            String result = null;
            if (null == ngList)
            {
                return null;
            }

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_UP_NGWORD_URL;
            else
                url = NTCloud.UP_NGWORD_URL;


            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&append=").Append((append)?"1":"0").
                    Append("&ngwdnum=").Append(ngList.Count.ToString());

                int len = ngList.Count;
                for (int i = 0; i < len; i++)
                {
                    String s;
                    if(NTUserPreference.AESEnabled)
                        s= NTTextUtiles.aesEncodeBase64URL(ngList[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(ngList[i]);
                    postData.Append("&ngwd" + (i + 1).ToString()).Append('=').Append(s);
                }

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }


        public static String ntUploadNgName(string uid, string passwd,
            List<string> ngList, bool append)
        {
            String result = null;
            if (null == ngList)
            {
                return null;
            }

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_UP_NGNAME_URL;
            else
                url = NTCloud.UP_NGNAME_URL;


            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&append=").Append((append) ? "1" : "0").
                    Append("&ngnmnum=").Append(ngList.Count.ToString());

                int len = ngList.Count;
                for (int i = 0; i < len; i++)
                {
                    String s;
                    if(NTUserPreference.AESEnabled)
                        s = NTTextUtiles.aesEncodeBase64URL(ngList[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(ngList[i]);
                    postData.Append("&ngnm" + (i + 1).ToString()).Append('=').Append(s);
                }

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }


        public static String ntUploadNgId(string uid, string passwd,
            List<string> ngList, bool append)
        {
            String result = null;
            if (null == ngList)
            {
                return null;
            }

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_UP_NGID_URL;
            else
                url = NTCloud.UP_NGID_URL;


            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&append=").Append((append) ? "1" : "0").
                    Append("&ngidnum=").Append(ngList.Count.ToString());

                int len = ngList.Count;
                for (int i = 0; i < len; i++)
                {
                    String s;
                    if(NTUserPreference.AESEnabled)
                        s = NTTextUtiles.aesEncodeBase64URL(ngList[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(ngList[i]);

                    postData.Append("&ngid" + (i + 1).ToString()).Append('=').Append(s);
                }

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        public static String ntUploadThreadHistoryList(string uid, string passwd,
            List<string> threadList)
        {
            String result = null;
            if (null == threadList)
            {
                return null;
            }

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_UPLOAD_THREAD_HISTORY_LIST_URL;
            else
                url = NTCloud.UPLOAD_THREAD_HISTORY_LIST_URL;


            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&num=").Append(threadList.Count.ToString());

                int len = threadList.Count;
                for (int i = 0; i < len; i++)
                {
                    String s;
                    if(NTUserPreference.AESEnabled)
                        s= NTTextUtiles.aesEncodeBase64URL(threadList[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(threadList[i]);
                    postData.Append("&h" + (i + 1).ToString()).Append('=').Append(s);
                }

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }




        public static String ntUploadFavorites(String uid , String passwd,
			List<String> boardList,List<String> threadList) {
		    String result = null;
		    if(null == boardList || null == threadList){
			    return null;
		    }
		
		    String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_UPLOAD_FAVORITES_URL;
            else
                url = NTCloud.UPLOAD_FAVORITES_URL;

            
		    NTHttpPostClient client = null;
  
		
    	    try{
			    client = new NTHttpPostClient( url, NTCloud.SERVER_ROOT , NTCloud.SERVER_ROOT);

                
                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StringBuilder postData = 
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&bnum=").Append(boardList.Count.ToString()).
                    Append("&tnum=").Append(threadList.Count.ToString());

                int len = boardList.Count;
                if (NTUserPreference.AESEnabled)
                {
                    for (int i = 0; i < len; i++)
                    {
                        String s = NTTextUtiles.aesEncodeBase64URL(boardList[i]);
                        postData.Append("&b" + (i + 1).ToString()).Append('=').Append(s);
                    }
                    len = threadList.Count;
                    for (int i = 0; i < len; i++)
                    {
                        String s = NTTextUtiles.aesEncodeBase64URL(threadList[i]);
                        postData.Append("&t" + (i + 1).ToString()).Append('=').Append(s);
                    }
                }
                else
                {
                    for (int i = 0; i < len; i++)
                    {
                        String s = NTTextUtiles.encodeBase64URL(boardList[i]);
                        postData.Append("&b" + (i + 1).ToString()).Append('=').Append(s);
                    }
                    len = threadList.Count;
                    for (int i = 0; i < len; i++)
                    {
                        String s = NTTextUtiles.encodeBase64URL(threadList[i]);
                        postData.Append("&t" + (i + 1).ToString()).Append('=').Append(s);
                    }
                }

                //byte[] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());
                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                
                Stream stream = httpResp.GetResponseStream();
                
                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();
  
            }
            catch(Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
		}

        public static String ntUpdateFavoriteBoards(String uid, String passwd,
            List<String> boardList)
        {
            String result = null;
            if (null == boardList)
            {
                return null;
            }

            String url;
            if(NTUserPreference.AESEnabled)
                url= NTCloud.AES_UPDATE_ALL_FAVORITE_BOARDS_URL;
            else
                url = NTCloud.UPDATE_ALL_FAVORITE_BOARDS_URL;



            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&bnum=").Append(boardList.Count.ToString());

                int len = boardList.Count;
                for (int i = 0; i < len; i++)
                {
                    String s;
                    if(NTUserPreference.AESEnabled)
                        s= NTTextUtiles.aesEncodeBase64URL(boardList[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(boardList[i]);
                    
                    postData.Append("&b" + (i + 1).ToString()).Append('=').Append(s);
                }

                //byte[] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());
                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }


        public  static String ntUpdateFavoriteThreads(String uid, String passwd,
           List<String> threadList, List<String> tagList)
        {
            String result = null;
            if (null == threadList)
            {
                return null;
            }

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_UPDATE_ALL_FAVORITE_THREADS2_URL;
            else
                url = NTCloud.UPDATE_ALL_FAVORITE_THREADS2_URL;


            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&tnum=").Append(threadList.Count.ToString());
                if(tagList != null)
                    postData.Append("&tabnum=").Append(tagList.Count.ToString());

                int len = threadList.Count;
                for (int i = 0; i < len; i++)
                {
                    String s;
                    if (NTUserPreference.AESEnabled)
                        s = NTTextUtiles.aesEncodeBase64URL(threadList[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(threadList[i]);
                    postData.Append("&t" + (i + 1).ToString()).Append('=').Append(s);
                }
                len = tagList.Count;
                for (int i = 0; i < len; i++)
                {
                    String s;
                    if (NTUserPreference.AESEnabled)
                        s = NTTextUtiles.aesEncodeBase64URL(tagList[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(tagList[i]);
                    postData.Append("&tab" + (i + 1).ToString()).Append('=').Append(s);
                }

                //byte[] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());
                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }


        public static String ntUploadExternalBoards(string description)
        {
            string uid = NTUserPreference.NTCloudID;
            string passwd = NTUserPreference.NTCloudPSS;

            string result = null;
            if (null == description || uid == null || passwd == null)
            {
                return null;
            }

            string url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_UPLOAD_EXTERNALBOARD_URL;
            else
                url= NTCloud.UPLOAD_EXTERNALBOARD_URL;


            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                string s;
                if (NTUserPreference.AESEnabled)
                    s = NTTextUtiles.aesEncodeBase64URL(description);
                else
                    s = NTTextUtiles.encodeBase64URL(description);


                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&exbnum=1&exb1=").Append(s);


                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        public static String ntDeleteExternalBoards(string description)
        {
            string uid = NTUserPreference.NTCloudID;
            string passwd = NTUserPreference.NTCloudPSS;

            string result = null;
            if (null == description || uid == null || passwd == null)
            {
                return null;
            }

            string url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_DELETE_EXTERNALBOARD_URL;
            else
                url = NTCloud.DELETE_EXTERNALBOARD_URL;


            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                string s;
                if (NTUserPreference.AESEnabled)
                    s = NTTextUtiles.aesEncodeBase64URL(description);
                else
                    s = NTTextUtiles.encodeBase64URL(description);

                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&exbnum=1&exb1=").Append(s);


                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }


        public static String ntDeletedFavoriteBoard(String uid, String passwd,
            List<String> boardList)
        {
            String result = null;
            if (null == boardList || boardList.Count == 0)
            {
                return null;
            }

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_DELETE_FAVORITES_BOARD_URL;
            else
                url = NTCloud.DELETE_FAVORITES_BOARD_URL;
            


            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);

                
                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&bnum=").Append(boardList.Count.ToString());

                int len = boardList.Count;
                for (int i = 0; i < len; i++)
                {
                    String s;
                    if(NTUserPreference.AESEnabled)
                        s = NTTextUtiles.aesEncodeBase64URL(boardList[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(boardList[i]);
                    postData.Append("&b" + (i + 1).ToString()).Append('=').Append(s);
                }
                

                //byte[] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());
                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                
                Stream stream = httpResp.GetResponseStream();
               
                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        public static String ntDeletedFavoriteThread(String uid, String passwd,
            List<String> threadList)
        {
            String result = null;
            if (null == threadList || threadList.Count == 0)
            {
                return null;
            }

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_DELETE_FAVORITES_THREAD_URL;
            else
                url = NTCloud.DELETE_FAVORITES_THREAD_URL;


            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&tnum=").Append(threadList.Count.ToString());

                int len = threadList.Count;
                for (int i = 0; i < len; i++)
                {
                    String s;
                    if(NTUserPreference.AESEnabled)
                        s = NTTextUtiles.aesEncodeBase64URL(threadList[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(threadList[i]);
                    postData.Append("&t" + (i + 1).ToString()).Append('=').Append(s);
                }

                byte[] data = enc.GetBytes(postData.ToString());
                //byte[] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }
	
        public static string ntCheckUser(string userName, string passwd)
        {

            String result = null;

            
            NTHttpPostClient client = null;
            HttpWebResponse httpResp = null;
            Stream stream = null;
            StreamReader sr = null;


            try
            {
                client = new NTHttpPostClient(NTCloud.CHECK_USER_URL, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);

                
                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);



                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(userName).
                    Append("&passwd=").Append(passwd);
  
                

                byte[] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());
                client.setPostData(data);

                httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                
                stream = httpResp.GetResponseStream();
               
                sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

 
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (sr != null)
                    sr.Close();
                if (stream != null)
                    stream.Close();
                if (httpResp != null)
                    httpResp.Close();
            }
            return result;
        }


        public static string ntQueryReadCountList(String uid, String passwd,
            string boardName)
        {
            String result = null;
            
            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_QUERY_READCNT_LIST_URL;
            else
                url = NTCloud.QUERY_READCNT_LIST_URL;
            

            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                String s;
                if(NTUserPreference.AESEnabled)
                    s = NTTextUtiles.aesEncodeBase64URL(boardName);
                else
                    s = NTTextUtiles.encodeBase64URL(boardName);
                
                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&board_name=").Append(s);

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        public static string ntQueryReadHistory(String uid, String passwd)
        {
            if(NTUserPreference.AESEnabled)
                return ntQueryHistory(uid, passwd, 4);
            else
                return ntQueryHistory(uid, passwd, 1);
        }
        public static string ntQueryWriteHistory(String uid, String passwd)
        {
            if (NTUserPreference.AESEnabled)
                return ntQueryHistory(uid, passwd, 5);
            else
                return ntQueryHistory(uid, passwd, 2);
        }
        public static string ntQueryBookmarkHistory(String uid, String passwd)
        {
            if (NTUserPreference.AESEnabled)
                return ntQueryHistory(uid, passwd, 6);
            else
                return ntQueryHistory(uid, passwd, 3);
        }

        private static string ntQueryHistory(String uid, String passwd, int type)
        {
            String result = null;

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_QUERY_READ_HISTORY_URL;
            else
                url = NTCloud.QUERY_READ_HISTORY_URL;


            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&type=").Append(type.ToString());

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        public static string ntUpdateAttrValue(
           string boardName, string datName, string kind, string value)
        {

            string uid = NTUserPreference.NTCloudID;
            string passwd = NTUserPreference.NTCloudPSS;

            String result = null;

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_UPDATE_ATTR_VALUE_URL;
            else
                url = NTCloud.UPDATE_ATTR_VALUE_URL;
            
            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                if (NTUserPreference.AESEnabled)
                {
                    boardName = NTTextUtiles.aesEncodeBase64URL(boardName);
                    datName = NTTextUtiles.aesEncodeBase64URL(datName);
                }
                else
                {
                    boardName = NTTextUtiles.encodeBase64URL(boardName);
                    datName = NTTextUtiles.encodeBase64URL(datName);
                }
                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&attr_type=").Append(kind).
                    Append("&attr_val=").Append(value).
                    Append("&board_name=").Append(boardName).
                    Append("&dat_name=").Append(datName);

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        public static string ntDeleteDatValue(string boardName, string datName)
        {

            string uid = NTUserPreference.NTCloudID;
            string passwd = NTUserPreference.NTCloudPSS;

            String result = null;

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_DELETE_DAT_VALUE_URL;
            else
                url = NTCloud.DELETE_DAT_VALUE_URL;
            

            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                if (NTUserPreference.AESEnabled)
                {
                    boardName = NTTextUtiles.aesEncodeBase64URL(boardName);
                    if (!("*".Equals(datName)))
                        datName = NTTextUtiles.aesEncodeBase64URL(datName);
                }
                else
                {
                    boardName = NTTextUtiles.encodeBase64URL(boardName);
                    if (!("*".Equals(datName)))
                        datName = NTTextUtiles.encodeBase64URL(datName);
                }
                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&board_name=").Append(boardName).
                    Append("&dat_name=").Append(datName);

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;


        }
        public static string ntDeleteAttrValue(
           string boardName, string datName, string kind, string value)
        {

            string uid = NTUserPreference.NTCloudID;
            string passwd = NTUserPreference.NTCloudPSS;

            String result = null;

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_DELETE_ATTR_VALUE_URL;
            else
                url = NTCloud.DELETE_ATTR_VALUE_URL;
            

            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                if (NTUserPreference.AESEnabled)
                {
                    boardName = NTTextUtiles.aesEncodeBase64URL(boardName);
                    datName = NTTextUtiles.aesEncodeBase64URL(datName);
                }
                else
                {
                    boardName = NTTextUtiles.encodeBase64URL(boardName);
                    datName = NTTextUtiles.encodeBase64URL(datName);
                }
                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&attr_type=").Append(kind).
                    Append("&attr_val=").Append(value).
                    Append("&board_name=").Append(boardName).
                    Append("&dat_name=").Append(datName);

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        public static string ntQueryAttrValue(/*String uid, String passwd,*/
           string boardName, string datName)
        {
            String result = null;

            string uid = NTUserPreference.NTCloudID;
            string passwd = NTUserPreference.NTCloudPSS;

            String url;
            if(NTUserPreference.AESEnabled)
                url = NTCloud.AES_QUERY_ATTR_VALUE_URL;
            else
                url = NTCloud.QUERY_ATTR_VALUE_URL;
            

            NTHttpPostClient client = null;


            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                if (NTUserPreference.AESEnabled)
                {
                    boardName = NTTextUtiles.aesEncodeBase64URL(boardName);
                    datName = NTTextUtiles.aesEncodeBase64URL(datName);
                }
                else
                {
                    boardName = NTTextUtiles.encodeBase64URL(boardName);
                    datName = NTTextUtiles.encodeBase64URL(datName);
                }
                StringBuilder postData =
                    new StringBuilder(256).Append("nickname=").Append(uid).
                    Append("&passwd=").Append(passwd).
                    Append("&board_name=").Append(boardName).
                    Append("&dat_name=").Append(datName);

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }


        public static string queryThreadFromAllBoard(string sWord)
        {


            String result = null;

            string uid = NTUserPreference.NTCloudID;
            string passwd = NTUserPreference.NTCloudPSS;

            String url = URL_ALLBOARD_SEARCH;


            NTHttpGetClient client = null;


            try
            {
                

                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                sWord = HttpUtility.UrlEncode(sWord, enc);
                string kensaku = HttpUtility.UrlEncode("検索", enc);
                string query = "?STR="+sWord+"&submit="+kensaku+"&COUNT=50";
        	
                client = new NTHttpGetClient(url + query);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                    
                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }
	}
}
