﻿using System;
using System.Net;
using System.IO;
using NT2chView.NtFile;
using System.Text;
using System.Web;
using System.Collections.Generic;
using NT2chView.NtHtml;
using System.Windows.Documents;

namespace NT2chView.NtNet
{
    public sealed partial class NTHttpAccess
    {
        private static string [] ignoreKey = {
                        "bbs","key","time","FROM","mail","MESSAGE","submit"
        };

        const string SUBJECT_TXT = "subject.txt";

        public static string getExternalBoardSubject(string url , string filePath)
        {
            string address;
            if (url == null || url.Length == 0)
                return null;

            if ('/' != url[url.Length - 1])
                address = url + '/' + SUBJECT_TXT;
            else
                address = url + SUBJECT_TXT;


            string resultStr = null;
            Stream stream = null;
            HttpWebResponse httpResp = null;
            NTHttpGetClient httpClient = new NTHttpGetClient(address);
 
            try
            {
                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                //WebHeaderCollection headers = httpResp.Headers;
                //if ((ifMod = headers.Get("Last-Modified")) != null)
                //    NTFileAccess.storeBoardMenuAttrToFile(ifMod);

                stream = httpResp.GetResponseStream();

                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StreamReader sr = new StreamReader(stream, enc);

                resultStr = sr.ReadToEnd();
                // NTFileAccess.storeBoardMenuDataToFile(stream);
                // bRet = true;

            }
            catch (System.Net.WebException e)
            {
                /*if (e.Status == System.Net.WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)e.Response;
                    if (errres.StatusCode == HttpStatusCode.NotModified)
                    {
                        bRet = true;
                    }
                    else
                    {
                        NTDebug.l(e.Message);
                    }
                }
                else
                {
                    NTDebug.l(e.Message);
                }*/
                NTDebug.l(e.Message);
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }

            return resultStr;
        }

        public static string getWriteHtmlExternalBBS(string host, string url)
        {
            string resultStr = null;
            Stream stream = null;
            HttpWebResponse httpResp = null;
            NTHttpGetClient httpClient = new NTHttpGetClient(url);

            try
            {
                NTCookie cookie = new NTCookie(host, false);

                httpClient.mHttpReq.CookieContainer = cookie.Container;

                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                cookie.saveCookie();

                stream = httpResp.GetResponseStream();

                string strCharSet = httpResp.CharacterSet;

                Encoding enc;
                if(strCharSet.Equals("utf-8", StringComparison.CurrentCultureIgnoreCase))
                    enc = Encoding.GetEncoding("UTF-8");
                else
                    enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StreamReader sr = new StreamReader(stream, enc);

                resultStr = sr.ReadToEnd();

            }
            catch (System.Net.WebException e)
            {
                NTDebug.l(e.Message);
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }

            return resultStr;
        }


        public static String writeResExternalBBS(string url, string refferer, string host, string postData)
        {
            return BasicHttpPost( url,  refferer,  host,  postData, false);
        }


        //static CookieContainer mTempCookie = new CookieContainer();


        public static String writeRes(string[] args, List<KeyValuePair<string, string>> extra)
        {
            if (args.Length < 7)
                return null;


            string host = args[0];
            string board = args[1];
            string dat = args[2];
            string from = args[3];
            string mail = args[4];
            string msg = args[5];
            string submit = args[6];        
		
		    String result = null;
		
            String postAddress = NTHttpUtils.HTTP_PROTOCOL + host + NTHttpUtils.HTTP_WRITE_CGI_PATH;
            String refAddress = postAddress + NTHttpUtils.HTTP_SLASH + 
                        board + NTHttpUtils.HTTP_SLASH + dat + NTHttpUtils.HTTP_SLASH;
            
		    NTHttpPostClient client = null;
  
		
    	    try{
			    client = new NTHttpPostClient(postAddress , refAddress ,  host);

                NTCookie cookie = new NTCookie(host);

                //cookie.saveCookie();


                client.mHttpReq.CookieContainer = cookie.Container;

                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                TimeSpan ts = new TimeSpan(0,10,0);
                int time = NTHttpUtils.GetTime(DateTime.Now.Subtract(ts));

                StringBuilder postData = 
                    new StringBuilder(256).Append("bbs=").Append(board).
                    Append("&key=").Append(dat).
                    Append("&time=").Append(time). //1230144297
                    Append("&FROM=").Append(HttpUtility.UrlEncode(from, enc)). // . %96%BC%96%B3%82%B5" +
                    Append("&mail=").Append(mail).
                    Append("&MESSAGE=").Append(HttpUtility.UrlEncode(msg, enc)). //%82%C4%82%B7%82%C6&submit=%8F%91%82%AB%8D%9E%82%DE";
                    Append("&submit=").Append(HttpUtility.UrlEncode(submit, enc));
                //"&yuki=akari";

                //postData.Append("&yuki=").Append("akari");

                if (extra != null)
                {
                    //postData.Remove(0, postData.Length);
                    foreach (KeyValuePair<string, string> pair in extra)
                    {
                        bool ignore = false;
                        foreach (string iKey in ignoreKey)
                        {
                            if (pair.Key.Equals(iKey))
                            {
                                ignore = true;
                                break;
                            }
                        }
                    
                        if (!ignore)
                        {
                        //if(postData.Length > 0)
                            postData.Append("&").Append(pair.Key).Append("=").Append(pair.Value);
                        //else
                        //    postData.Append(pair.Key).Append("=").Append(pair.Value);

                        }
                    }
                 }

                if (NTUserPreference.MaruIsEnabled)
                {
                    string sessionId = NTMaru.getSessionId();
                    if (sessionId.Length > 0)
                    {
                        //postData.Append("&sid=").Append(HttpUtility.UrlEncode(sessionId, enc));
                        postData.Append("&sid=").Append(sessionId);
                    }
                }

                byte[] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());
                client.setPostData(data);
        	
        	    HttpWebResponse httpResp = client.execute();
            
                NTDebug.l(httpResp.StatusCode.ToString());

#if false
                foreach (Cookie cook in httpResp.Cookies)
                {
                    Console.WriteLine("Cookie:");
                    Console.WriteLine("{0} = {1}", cook.Name, cook.Value);
                    Console.WriteLine("Domain: {0}", cook.Domain);
                    Console.WriteLine("Path: {0}", cook.Path);
                    Console.WriteLine("Port: {0}", cook.Port);
                    Console.WriteLine("Secure: {0}", cook.Secure);

                    Console.WriteLine("When issued: {0}", cook.TimeStamp);
                    Console.WriteLine("Expires: {0} (expired? {1})",
                        cook.Expires, cook.Expired);
                    Console.WriteLine("Don't save: {0}", cook.Discard);
                    Console.WriteLine("Comment: {0}", cook.Comment);
                    Console.WriteLine("Uri for comments: {0}", cook.CommentUri);
                    Console.WriteLine("Version: RFC {0}", cook.Version == 1 ? "2109" : "2965");

                    // Show the string representation of the cookie.
                    Console.WriteLine("String: {0}", cook.ToString());
                }
#endif

                cookie.saveCookie();

                Stream stream = httpResp.GetResponseStream();
                //Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                            
                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            } catch (Exception e) {
                NTDebug.l(e.Message);
		    }finally{
		    }
		    return result;	
	    }
	


        public static bool getBoardMenu()
        {
            bool bRet = false;
            Stream stream = null;
            HttpWebResponse httpResp = null;
            NTHttpGetClient httpClient = new NTHttpGetClient(URL_2CH_BOARDMENU);
            httpClient.AcceptGZip = true;
 
            try
            {
                string ifMod = NTFileAccess.retrieveBoardMenuAttrFromFile();
                if (null != ifMod)
                    httpClient.ModifiedSince = ifMod;
            
                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                WebHeaderCollection headers = httpResp.Headers;
                if((ifMod = headers.Get("Last-Modified")) != null)
                    NTFileAccess.storeBoardMenuAttrToFile(ifMod);

                stream = httpResp.GetResponseStream();
                NTFileAccess.storeBoardMenuDataToFile(stream);
                bRet = true;
           
             }
            catch (System.Net.WebException e)
            {
                if (e.Status == System.Net.WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)e.Response;
                    if (errres.StatusCode == HttpStatusCode.NotModified)
                    {
                        bRet = true;
                    }
                    else
                    {
                        NTDebug.l(e.Message);
                    }
                }
                else
                {
                    NTDebug.l(e.Message);
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }

            return bRet;
        }



        public static bool getSubject(string address, string boardName)
        {
            bool bRet = false;
            Stream stream = null;
            HttpWebResponse httpResp = null;
            NTHttpGetClient httpClient = new NTHttpGetClient(address+"subject.txt");
            httpClient.AcceptGZip = true;

            try
            {
                string ifMod = NTFileAccess.retrieveSubjectAttrFromFile(boardName);
                if (null != ifMod)
                    httpClient.ModifiedSince = ifMod;

                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                WebHeaderCollection headers = httpResp.Headers;
                if ((ifMod = headers.Get("Last-Modified")) != null)
                    NTFileAccess.storeSubjectAttrToFile(ifMod, boardName);

                stream = httpResp.GetResponseStream();
                bRet = NTFileAccess.storeSubjectDataToFile(stream, boardName);
            }
            catch (System.Net.WebException e)
            {
                if (e.Status == System.Net.WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)e.Response;
                    if (errres.StatusCode == HttpStatusCode.NotModified)
                    {
                        bRet = true;
                    }
                    else
                    {
                        NTDebug.l(e.Message);
                    }
                }
                else
                {
                    NTDebug.l(e.Message);
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }
            return bRet;
        }



        public static bool getDat(string address, string boardName, string datName, string title)
        {
            bool bRet = false;
            Stream stream = null;
            HttpWebResponse httpResp = null;
            NTHttpGetClient httpClient = new NTHttpGetClient(address + "dat/" + datName);
            
            try
            {
                string ifMod;
                long fileSize = 0;

                string[] attr = NTFileAccess.retrieveDatAttrBinFromFile(boardName, datName);
                
                if (null != attr)
                {
                    httpClient.ModifiedSince = attr[1];
                    try
                    {
                        fileSize = long.Parse(attr[2]);
                    }
                    catch
                    {
                    }
                    if (fileSize <= 0)
                    {
                        httpClient.AcceptGZip = true;
                    }
                    else
                    {
                        httpClient.Range = (int)fileSize;
                    }
                }

                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                WebHeaderCollection headers = httpResp.Headers;
                ifMod = headers.Get("Last-Modified");
                    
                stream = httpResp.GetResponseStream();

                //int n = datName.IndexOf(".dat");
                //if (n >= 0)
                //    datName = datName.Substring(0, n);
                datName = NTFileAccess.ridSuffixFromDatName(datName);

                bRet = NTFileAccess.storeDatToFile(stream, boardName, datName, title, 
                    ifMod, (httpResp.StatusCode == HttpStatusCode.PartialContent));

            }
            catch (System.Net.WebException e)
            {
                if (e.Status == System.Net.WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)e.Response;
                    if (errres.StatusCode == HttpStatusCode.NotModified)
                    {
                        bRet = true;
                    }
                    else
                    {
                        NTDebug.l(e.Message);
                    }
                }
                else
                {
                    NTDebug.l(e.Message);
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }

            return bRet;
        }

        public static bool getDatFromKako(string address, string boardName, string datName, 
            string title, string sid)
        {
            if (title == null)
                title = string.Empty;
            int idx = title.IndexOf(NTHttpUtils.LOCAL_DAT_TITEL_PREFIX);
            if (idx >= 0)
            {
                idx += NTHttpUtils.LOCAL_DAT_TITEL_PREFIX.Length;
                title = title.Substring(idx).Trim();
            }

            bool bRet = false;
            Stream stream = null;
            HttpWebResponse httpResp = null;

            string host, board, dat;

            dat = NTHttpUtils.ridSuffixFromDatName(datName);
            if (!NTHttpUtils.parseHostAddress(address, out host, out board))
                return false;

            string url = NTHttpUtils.HTTP_PROTOCOL + host 
                + "/test/offlaw.cgi/" + board + "/" + dat + "/?raw=0.0&sid=" + sid;

            NTHttpGetClient httpClient = new NTHttpGetClient(url);

            try
            {
                string ifMod;
                //long fileSize = 0;

                string[] attr = NTFileAccess.retrieveDatAttrBinFromFile(boardName, datName);

                if (null != attr && attr.Length > 1)
                {
                    httpClient.ModifiedSince = attr[1];
                }
                httpClient.AcceptGZip = true;
             
                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                WebHeaderCollection headers = httpResp.Headers;
                ifMod = headers.Get("Last-Modified");

                stream = httpResp.GetResponseStream();

                //int n = datName.IndexOf(".dat");
                //if (n >= 0)
                //    datName = datName.Substring(0, n);
                bRet = NTFileAccess.storeDatToFile(stream, boardName, dat, title,
                    ifMod, false);

            }
            catch (System.Net.WebException e)
            {
                if (e.Status == System.Net.WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)e.Response;
                    if (errres.StatusCode == HttpStatusCode.NotModified)
                    {
                        bRet = true;
                    }
                    else
                    {
                        NTDebug.l(e.Message);
                    }
                }
                else
                {
                    NTDebug.l(e.Message);
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }

            return bRet;
        }



        static bool mP2LogedIn = false;
        static string P2HostName = null;
        static string P2LoginDir = null;
        static string P2PostDir = null;
        //static NTCookie mCookie = null;
        static CookieContainer mCookie = null;
        static string host;
        static string board;
        static string dat;
        static string from;
        static string mail;
        static string msg;
        static string submit;
        static Encoding enc;
        static string title;



        static  bool writeResP2Login(out HttpStatusCode resultCode)
        {
            string resultHtml;
            resultCode = HttpStatusCode.NotFound;

            try
            {
                string urlAddress = "http://" + P2HostName + P2LoginDir;
                //getClient;//request;// = new HttpGet("http://p2.2ch.net/p2/?k=1");

                NTHttpGetClient getClient = new NTHttpGetClient(urlAddress);
                getClient.mHttpReq.CookieContainer = mCookie;// mCookie.Container;

                HttpWebResponse httpResp = getClient.execute();

                if (httpResp.StatusCode != HttpStatusCode.OK)
                    return false;

                //mCookie.saveCookie();

                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                resultHtml = sr.ReadToEnd();

                httpResp.Close();

                NTHtmlParser htmlParser = new NTHtmlParser(new FlowDocument());
                string resultHtml2 = htmlParser.parse(resultHtml);

                NTDebug.l(resultHtml2);

                StringBuilder postData = new StringBuilder(256);

                foreach (KeyValuePair<string, string> pair in htmlParser.mInputTypeHidden)
                {
                    if (0 < postData.Length)
                        postData.Append("&");

                    postData.Append(pair.Key).Append("=").Append(pair.Value);
                }
                foreach (KeyValuePair<string, string> pair in htmlParser.mInputTypeSubmit)
                {
                    if (0 < postData.Length)
                        postData.Append("&");

                    postData.Append(pair.Key).Append("=").Append(pair.Value);
                    break;
                }

                foreach (KeyValuePair<string, string> pair in htmlParser.mInputTypeCheckBox)
                {
                    if (0 < postData.Length)
                        postData.Append("&");

                    postData.Append(pair.Key).Append("=").Append(pair.Value);
                }

                foreach (KeyValuePair<string, string> pair in htmlParser.mInputTypeText)
                {
                    if (0 < postData.Length)
                        postData.Append("&");

                    string p2id = NTUserPreference.P2ID;
                    postData.Append(pair.Key).Append("=").Append(p2id);
                    break;
                }

                foreach (KeyValuePair<string, string> pair in htmlParser.mInputTypePasswd)
                {
                    if (0 < postData.Length)
                        postData.Append("&");

                    string p2pass = NTUserPreference.P2PSS;
                    postData.Append(pair.Key).Append("=").Append(p2pass);
                    break;
                }

                string action = null;
                foreach (KeyValuePair<string, string> pair in htmlParser.mFormAttributes)
                {
                    if (pair.Key.Equals("action"))
                    {
                        action = pair.Value;
                        break;
                    }
                }
                string prevUrl = urlAddress;
                if (null != action)
                    urlAddress = "http://" + P2HostName + action;


                byte[] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());

                NTHttpPostClient postClient = new NTHttpPostClient(urlAddress, prevUrl, "http://" + P2HostName);
                postClient.mHttpReq.CookieContainer = mCookie;// mCookie.Container;
                postClient.setPostData(data);

                httpResp = postClient.execute();

                resultCode = httpResp.StatusCode;

                switch (httpResp.StatusCode)
                {
                    case HttpStatusCode.OK:
                        return true;
                    case HttpStatusCode.Redirect:
                        break;
                    default:
                        return false;
                }


                WebHeaderCollection headers = httpResp.Headers;
                string newLocation = headers["Location"];
                httpResp.Close();

                if (null == newLocation)
                    return false;

                prevUrl = urlAddress;

                int n1 = newLocation.IndexOf('&');
                if (0 <= n1)
                {
                    newLocation = newLocation.Substring(0, n1);
                }
                n1 = newLocation.IndexOf("http://");
                if (0 <= n1)
                {
                    n1 += "http://".Length;
                    int n2 = NTHttpUtils.parseWebHost(newLocation, n1);
                    if (0 < n2)
                    {
                        P2HostName = newLocation.Substring(n1, n2);
                    }
                }
                return true;

            }
            catch (WebException we)
            {
                NTDebug.l(we.Message);
                return false;
            }
            catch
            {
                return false;
            }

        }

        static string writeResP2Retry(string postAddress, string refAddress, List<KeyValuePair<string, string>> extra)
        {

            string resultHtml = null;

            if(extra == null)
                return null;

            StringBuilder postData =
                new StringBuilder(256).Append("bbs=").Append(board).
                Append("&key=").Append(dat).
                Append("&time=100").
                Append("&FROM=").Append(from).
                Append("&mail=").Append(mail).
                Append("&MESSAGE=").Append(msg).
                Append("&submit=").Append(submit);

            
            NTHttpPostClient postClient = new NTHttpPostClient(postAddress, refAddress, "http://" + P2HostName);
            postClient.mHttpReq.CookieContainer = mCookie;// mCookie.Container;

            try
            {
                foreach (KeyValuePair<string, string> pair in extra)
                {
                    bool ignore = false;
                    foreach (string iKey in ignoreKey)
                    {
                        if (pair.Key.Equals(iKey))
                        {
                            ignore = true;
                            break;
                        }
                    }

                    if (!ignore)
                    {
                        postData.Append("&").Append(pair.Key).Append("=").Append(pair.Value);
                    }
                }
                byte [] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());
                postClient.setPostData(data);

                HttpWebResponse httpResp = postClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                resultHtml = sr.ReadToEnd();

                httpResp.Close();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return resultHtml;
        }


        public static string createThread(string url, string refferer, string host, string postData)
        {
            return BasicHttpPost( url,  refferer,  host,  postData, true);
        }

        public static string loginMaru(string uid, string passwd)
        {
            if (uid.Length == 0 || passwd.Length == 0)
                return null;

            string url = NTHttpUtils.HTTPS_PROTOCOL 
                + NTHttpUtils.MARU_HOST 
                + NTHttpUtils.MARU_LOGIN_PATH;
            string reffer = NTHttpUtils.HTTPS_PROTOCOL
                    + NTHttpUtils.MARU_HOST + '/';
            string host = NTHttpUtils.MARU_HOST;

            StringBuilder sb = new StringBuilder();

            sb.Append("ID=").Append(uid).Append("&PW=").Append(passwd);
            string ua = "DOLIB/1.00";
            List<KeyValuePair<string, string>> list = new List<KeyValuePair<string, string>>();
            list.Add(new KeyValuePair<string, string>("X-2ch-UA",HTTP_HEADER_USER_AGENT));

            return loginMaruPost( url,  reffer,  host, sb.ToString(), list,  ua);

        }
        private static string loginMaruPost(string url, string refferer, string host, string postData, List<KeyValuePair<string,string>> list, string ua)
        {

            string result = null;

            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, refferer, host, list, ua);

                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                byte[] data = System.Text.Encoding.ASCII.GetBytes(postData);

                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                string strCharSet = httpResp.CharacterSet;
                if (strCharSet.Equals("utf-8", StringComparison.CurrentCultureIgnoreCase))
                    enc = Encoding.GetEncoding("UTF-8");

                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
            }
            return result;
        }


        private static string BasicHttpPost(string url, string refferer, 
            string host, string postData, bool cookieDomain)
        {

            String result = null;

            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, refferer, host);

                NTCookie cookie = new NTCookie(host, cookieDomain);


                client.mHttpReq.CookieContainer = cookie.Container;


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                byte[] data = System.Text.Encoding.ASCII.GetBytes(postData);

                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                string strCharSet = httpResp.CharacterSet;
                if (strCharSet.Equals("utf-8", StringComparison.CurrentCultureIgnoreCase))
                    enc = Encoding.GetEncoding("UTF-8");

                cookie.saveCookie();

                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
            }
            return result;
        }



        public static string createThreadP2(string[] args, List<KeyValuePair<string, string>> extra, bool retry)
        {

            string resultHtml = null;

            enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);


            host = args[0];
            board = args[1];
            from = HttpUtility.UrlEncode(args[2], enc);
            mail = args[3];
            title = HttpUtility.UrlEncode(args[4], enc);
            msg = HttpUtility.UrlEncode(args[5], enc);
            submit = HttpUtility.UrlEncode(args[6].Trim(), enc);

            if (null == P2HostName)
                P2HostName = "p2.2ch.net";
            //P2HostName = "w2.p2.2ch.net";

            if (null == P2LoginDir)
                P2LoginDir = "/p2/?k=1";

            if (null == P2PostDir)
                P2PostDir = "/p2/post_form.php";

            String postAddress = "http://" + P2HostName + P2PostDir;
            String refAddress = postAddress;

            if (null == mCookie)
                mCookie = new CookieContainer();

            //if (extra != null)
            //    return writeResP2Retry(postAddress, refAddress, extra);

            

            if (!mP2LogedIn)
            {
                HttpStatusCode resultCode;
                if (!writeResP2Login(out resultCode))
                    return null;

                if (resultCode == HttpStatusCode.Redirect)
                {
                    mCookie = new CookieContainer();
                    if (!writeResP2Login(out resultCode))
                        return null;

                }
            }

            resultHtml = createThreadP2Create();
#if false
            resultHtml = writeResP2Write(readCnt, threadTitle);
#endif
            if (resultHtml == null)
                return null;


            if (0 < resultHtml.IndexOf("p2 error"))
            {
                mP2LogedIn = false;
                //if (!retry)
                //    resultHtml = writeResP2(args, extra, readCnt, threadTitle, true);
                //else
                //    return null;
            }
            else
            {
                mP2LogedIn = true;
            }
            return resultHtml;
        }


        static string createThreadP2Create(/*int readCnt, string threadTitle*/)
        {

            string resultHtml = null;

            try
            {

                StringBuilder newAddress =
                    new StringBuilder(256).Append("http://")
                    .Append(P2HostName).Append("/p2/post_form.php?host=")
                    .Append(host)//toro.2ch.net
                    .Append("&bbs=").Append(board)
                    //.Append("&key=").Append(dat)
                    //.Append("&rescount=").Append(readCnt.ToString())
                    .Append("&newthread=1&b=k");


                string newAddressStr = newAddress.ToString();

                NTHttpGetClient getClient = new NTHttpGetClient(newAddressStr);
                getClient.mHttpReq.CookieContainer = mCookie;

                HttpWebResponse httpResp = getClient.execute();

                if (httpResp.StatusCode != HttpStatusCode.OK)
                    return null;


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                resultHtml = sr.ReadToEnd();

                httpResp.Close();

                NTHtmlParser htmlParser = new NTHtmlParser(new FlowDocument());
                string resultHtml2 = htmlParser.parse(resultHtml);

                NTDebug.l(resultHtml2);

                string action = null;
                string encStr = null;
                foreach (KeyValuePair<string, string> pair in htmlParser.mFormAttributes)
                {
                    if (pair.Key.Equals("action"))
                    {
                        action = pair.Value;
                        //break;
                    }
                    else if (pair.Key.Equals("accept-charset"))
                    {
                        encStr = pair.Value;
                    }
                }

                StringBuilder postData = new StringBuilder(256);

                foreach (KeyValuePair<string, string> pair in htmlParser.mInputTypeHidden)
                {
                    if (0 < postData.Length)
                        postData.Append("&");
                    string val = HttpUtility.UrlEncode(pair.Value, enc);
                    postData.Append(pair.Key).Append("=").Append(val);
                }
                foreach (KeyValuePair<string, string> pair in htmlParser.mInputTypeSubmit)
                {
                    if (0 < postData.Length)
                        postData.Append("&");
                    string val = HttpUtility.UrlEncode(pair.Value, enc);
                    postData.Append(pair.Key).Append("=").Append(val);
                    break;
                }

                
                postData.Append("&subject=").Append(title)
                        .Append("&MESSAGE=").Append(msg)
                        .Append("&FROM=").Append(from)
                        .Append("&mail=").Append(mail);


                string newUrl = NTHtmlUtils.parseActionUrl(P2HostName, newAddressStr, action);
                if (null == newUrl)
                    return null;
#if false
                if (0 != action.IndexOf("/p2/"))
                {
                    P2PostDir = "/p2/" + action;
                }
                else
                {
                    P2PostDir = action;
                }
                String newUrl = "http://" + P2HostName + P2PostDir;
#endif
                byte[] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());

                NTHttpPostClient postClient = new NTHttpPostClient(newUrl,
                        "http://" + P2HostName + "/p2/post_form.php", "http://" + P2HostName);
                postClient.mHttpReq.CookieContainer = mCookie;// mCookie.Container;
                postClient.setPostData(data);

                httpResp = postClient.execute();

                if (httpResp.StatusCode != HttpStatusCode.OK)
                    return null;



                stream = httpResp.GetResponseStream();

                sr = new StreamReader(stream, enc);

                resultHtml = sr.ReadToEnd();

                httpResp.Close();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
                resultHtml = null;
            }
            //finally
            // {
            // }
            //  if (loginAgain)
            //  {
            //     return writeResP2(args, extra, readCnt, threadTitle, true);
            //  }
            //  else
            //  {
            return resultHtml;
            //  }
        }




        public static String writeResP2(string[] args, List<KeyValuePair<string, string>> extra, int readCnt, string threadTitle, bool retry)
        {

            string resultHtml = null;

            enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);


            host = args[0];
            board = args[1];
            dat = args[2];
            from = HttpUtility.UrlEncode(args[3].Trim(), enc);//args[3];
            mail = args[4];
            msg = HttpUtility.UrlEncode(args[5].Trim(), enc);//args[5];
            submit = HttpUtility.UrlEncode(args[6].Trim(), enc);//args[6];

            if (null == P2HostName)
                P2HostName = "p2.2ch.net";
                //P2HostName = "w2.p2.2ch.net";

            if (null == P2LoginDir)
                P2LoginDir = "/p2/?k=1";

            if (null == P2PostDir)
                P2PostDir = "/p2/post_form.php";

            String postAddress = "http://" + P2HostName + P2PostDir;
            String refAddress = postAddress;
            
            if (null == mCookie)
                mCookie = new CookieContainer();

            if (extra != null)
                return writeResP2Retry(postAddress, refAddress, extra);

            //bool loginAgain = false;

  
            if (!mP2LogedIn)
            {
                HttpStatusCode resultCode;
                if(!writeResP2Login(out resultCode))
                    return null;

                if(resultCode == HttpStatusCode.Redirect){
                    mCookie = new CookieContainer();
                    if(!writeResP2Login(out resultCode))
                        return null;

                }
            }

            resultHtml = writeResP2Write(readCnt, threadTitle);

            if (resultHtml == null)
                return null;
            

            if (0 < resultHtml.IndexOf("p2 error"))
            {
                mP2LogedIn = false;
                if (!retry)
                    resultHtml = writeResP2(args, extra, readCnt, threadTitle, true);
                else
                    return null;
            }
            else
            {
                 mP2LogedIn = true;
            }
            return resultHtml;
        }

        static string writeResP2Write(int readCnt, string threadTitle)
        {

            string resultHtml = null;

            try
            {

                StringBuilder newAddress =
                    new StringBuilder(256).Append("http://")
                    .Append(P2HostName).Append("/p2/post_form.php?host=")
                    .Append(host)//toro.2ch.net
                    .Append("&bbs=").Append(board)
                    .Append("&key=").Append(dat)
                    .Append("&rescount=").Append(readCnt.ToString())
                    .Append("&ttitle_en=")
                    .Append(HttpUtility.UrlEncode(threadTitle.Trim(), enc))
                    .Append("&b=k");


                NTHttpGetClient getClient = new NTHttpGetClient(newAddress.ToString());
                getClient.mHttpReq.CookieContainer = mCookie;

                HttpWebResponse httpResp = getClient.execute();

                if (httpResp.StatusCode != HttpStatusCode.OK)
                    return null;

                
                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                resultHtml = sr.ReadToEnd();

                httpResp.Close();

                NTHtmlParser htmlParser = new NTHtmlParser(new FlowDocument());
                string resultHtml2 = htmlParser.parse(resultHtml);

                NTDebug.l(resultHtml2);

                StringBuilder postData = new StringBuilder(256);

                foreach (KeyValuePair<string, string> pair in htmlParser.mInputTypeHidden)
                {
                    if (0 < postData.Length)
                        postData.Append("&");

                    postData.Append(pair.Key).Append("=").Append(pair.Value);
                }
                foreach (KeyValuePair<string, string> pair in htmlParser.mInputTypeSubmit)
                {
                    if (0 < postData.Length)
                        postData.Append("&");

                    postData.Append(pair.Key).Append("=").Append(pair.Value);
                    break;
                }

                string action = null;
                foreach (KeyValuePair<string, string> pair in htmlParser.mFormAttributes)
                {
                    if (pair.Key.Equals("action"))
                    {
                        action = pair.Value;
                        break;
                    }
                }

                if (null != msg)
                    postData.Append("&MESSAGE=").Append(msg);
                if (null != from)
                    postData.Append("&FROM=").Append(from);
                if (null != mail)
                    postData.Append("&mail=").Append(mail);

                if (null == action)
                    return null;

                if (0 != action.IndexOf("/p2/"))
                {
                    P2PostDir = "/p2/" + action;
                }
                else
                {
                    P2PostDir = action;
                }
                String newUrl = "http://" + P2HostName + P2PostDir;

                byte [] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());

                NTHttpPostClient postClient = new NTHttpPostClient(newUrl,
                        "http://" + P2HostName + "/p2/post_form.php", "http://" + P2HostName);
                postClient.mHttpReq.CookieContainer = mCookie;// mCookie.Container;
                postClient.setPostData(data);

                httpResp = postClient.execute();

                if (httpResp.StatusCode != HttpStatusCode.OK)
                    return null;



                stream = httpResp.GetResponseStream();

                sr = new StreamReader(stream, enc);

                resultHtml = sr.ReadToEnd();

                httpResp.Close();

             }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            //finally
           // {
           // }
          //  if (loginAgain)
          //  {
           //     return writeResP2(args, extra, readCnt, threadTitle, true);
          //  }
          //  else
          //  {
            return resultHtml;
          //  }
        }



        public static bool getMachiBBSDat(string address, string boardName, string datName, string title)
        {
            bool bRet = false;
            Stream stream = null;
            HttpWebResponse httpResp = null;

            address = NTHttpUtils.convertMachiAddress(address);
            if (null == address)
                return false;

            datName = NTHttpUtils.ridSuffixFromCgiName(datName);
            NTHttpGetClient httpClient = new NTHttpGetClient(address + datName + '/' );

            try
            {
                string ifMod;
                long fileSize = 0;

                string[] attr = NTFileAccess.retrieveDatAttrBinFromFile(boardName, datName);

                if (null != attr)
                {
                    httpClient.ModifiedSince = attr[1];
                    try
                    {
                        //fileSize = long.Parse(attr[2]);
                    }
                    catch
                    {
                    }
                    if (fileSize <= 0)
                    {
                        httpClient.AcceptGZip = true;
                    }
                    else
                    {
                        httpClient.Range = (int)fileSize;
                    }
                }

                httpResp = httpClient.execute();

                NTDebug.l(httpResp.StatusCode.ToString());

                WebHeaderCollection headers = httpResp.Headers;
                ifMod = headers.Get("Last-Modified");

                stream = httpResp.GetResponseStream();

                //int n = datName.IndexOf(".dat");
                //if (n >= 0)
                //    datName = datName.Substring(0, n);
                //datName = NTFileAccess.ridSuffixFromDatName(datName);

                bRet = NTFileAccess.storeDatToFile(stream, boardName, datName, title,
                    ifMod, (httpResp.StatusCode == HttpStatusCode.PartialContent));

            }
            catch (System.Net.WebException e)
            {
                if (e.Status == System.Net.WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)e.Response;
                    if (errres.StatusCode == HttpStatusCode.NotModified)
                    {
                        bRet = true;
                    }
                    else
                    {
                        NTDebug.l(e.Message);
                    }
                }
                else
                {
                    NTDebug.l(e.Message);
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (null != stream)
                    stream.Close();
                if (null != httpResp)
                    httpResp.Close();
            }

            return bRet;
        }

    }
}
