﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chView
{
    class NTSimString
    {
		List<string> mSplitedString;
		
		
		const int TOKEN_SPACE = 0;
		const int TOKEN_HIRAKANA = 1;
		const int TOKEN_NUMALPHA = 2;
		const int TOKEN_OTHER = 3;
		
		public NTSimString(String seed){
            mSplitedString = new List<string>();
			int current = TOKEN_OTHER;
			int len = seed.Length;
			int start = 0;
			int i = 0;
			for(; i < len; i++){
				char c = seed[i];
				int token = getToken(c);
				if(token == TOKEN_SPACE){
					if(current != TOKEN_SPACE){
						if(start < i){
                            mSplitedString.Add(seed.Substring(start, i - start));
						}
						current = TOKEN_SPACE;
					}
					start = i+1;
				}else{
					if(current != token){
						if(start < i){
                            mSplitedString.Add(
                                seed.Substring(start, i - start));
						}
						current = token;
						start = i;
					}
				}
			}
			if(start < i && current != TOKEN_SPACE){
                mSplitedString.Add(
                    seed.Substring(start, i - start));
			}
		}
		
		public int match(String source){
			int match_len = 0;
            foreach (string line in mSplitedString)
            {
                //int len;
                //int idx = line.match(source, 0, out len);
                //if (idx >= 0 && len > 1)
                //{
                //    match_len += len;
                //}
                if (0 <= source.IndexOf(line, StringComparison.CurrentCultureIgnoreCase))
                {
					match_len += line.Length;
				}
			}
			return match_len;
		}
		public void log(){
			//DebugUtil.log("SimString logging...");
			//foreach(String line in mSplitedString){
				//DebugUtil.log(line);
			//}
		}
		int getToken(char c){
			for(int i = 0; i < mSeparatorChar.Length; i++){
				if(c == mSeparatorChar[i]){
					return TOKEN_SPACE;
				}
			}
			for(int i = 0; i < mHiraKakaChar.Length; i++){
				if(c == mHiraKakaChar[i]){
					return TOKEN_HIRAKANA;
				}
			}
			for(int i = 0; i < mNumAlphaChar.Length; i++){
				if(c == mNumAlphaChar[i]){
					return TOKEN_NUMALPHA;
				}
			}
			
			return TOKEN_OTHER;
		}
		static char [] mSeparatorChar = {
			' ','　','(',')','【','】','（','）','「','」','{','}','｛','｝','〈','〉',
			'《','》','｢','｣','『','』',',','.','、','。','★','※','*','?','!','？','！','・'};
		static char [] mHiraKakaChar = {
			'ー','ｰ','あ','ア','ぁ','ァ','い','イ','ぃ','ィ','う','ウ','ぅ','ゥ',
			'え','エ','ぇ','ェ','お','オ','ぉ','ォ','を','ヲ',
			'か','カ','ヵ','ヵ','き','キ','く','ク','け','ケ','ヶ','ヶ','こ','コ',
			'さ','サ','し','シ','す','ス','せ','セ','そ','ソ',
			'た','タ','ち','チ','つ','ツ','っ','ッ','て','テ','と','ト',
			'な','ナ','に','ニ','ぬ','ヌ','ね','ネ','の','ノ',
			'は','ハ','ワ','わ','ひ','ヒ','ふ','フ','へ','ヘ','ほ','ホ',
			'ま','マ','み','ミ','む','ム','め','メ','も','モ',
			'や','ヤ','ゃ','ャ','ゆ','ユ','ゅ','ュ','よ','ヨ','ょ','ョ',
			'ラ','ら','ﾗ','り','リ','ﾘ','る','ル','ﾙ',
			'れ','レ','ﾚ','ろ','ロ','ﾛ','ん','ン',
			'が','ガ','ぎ','ギ','ぐ','グ','げ','ゲ','ご','ゴ',
			'ざ','ザ','じ','ジ','ぢ','ヂ','ず','ズ','づ','ヅ',
			'ぜ','ゼ','ぞ','ゾ','だ','ダ','で','デ','ど','ド',
			'ば','バ','び','ビ','ぶ','ブ','べ','ベ','ぼ','ボ',
			'ぱ','パ','ぴ','ピ','ぷ','プ','ぺ','ペ','ぽ','ポ'};
		static char [] mNumAlphaChar = {
			'-','_','－','＿',
			'0','０','1','１','2','２','3','３','4','４',
			'5','５','6','６','7','７','8','８','9','９',
			'A','a','Ａ','ａ','B','b','Ｂ','ｂ','C','c','Ｃ','ｃ',
			'D','d','Ｄ','ｄ','E','e','Ｅ','ｅ','F','f','Ｆ','ｆ',
			'G','g','Ｇ','ｇ','H','h','Ｈ','ｈ','I','i','Ｉ','ｉ',
			'J','j','Ｊ','ｊ','K','k','Ｋ','ｋ',	'L','l','Ｌ','ｌ',
			'M','m','Ｍ','ｍ','N','n','Ｎ','ｎ','O','o','Ｏ','ｏ',
			'P','p','Ｐ','ｐ','Q','q','Ｑ','ｑ','R','r','Ｒ','ｒ',
			'S','s','Ｓ','ｓ','T','t','Ｔ','ｔ',	'U','u','Ｕ','ｕ',
			'V','v','Ｖ','ｖ','W','w','Ｗ','ｗ','X','x','Ｘ','ｘ',
			'Y','y','Ｙ','ｙ','Z','z','Ｚ','ｚ','%','％','$','＄','#','＃',
			'@','＠','+','＋'};
	}
    
}
