﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using NT2chView.NtFile;

namespace NT2chView
{
    class NTResMenuCommand
    {
        FlowDocumentScrollViewer mViewer;

        private static List<NTMenuCommand> mMenuCommands = new List<NTMenuCommand>();

        const string REGEX_PATERN = @"\{[1-9]+\}|\{[0-9]+.+\}";
        const string FORMAT_SPECIFIERS = "{0}";

        private static bool probeCommand(string arguments)
        {
            if(arguments.Length == 0)
                return false;

            if (Regex.IsMatch(arguments, REGEX_PATERN))
                return false;

            /*int idx1 = arguments.IndexOf(FORMAT_SPECIFIERS);
            if (idx1 >= 0)
            {
                int idx2 = arguments.IndexOf(FORMAT_SPECIFIERS);
                if (idx2 >= 0)
                    return false;
            }*/
            return true;
        }

        public static List<NTMenuCommand> getMenuCommands()
        {
            return mMenuCommands;
        }

        public static void init()
        {

            mMenuCommands.Clear();

            string [] cmdList = NTPersistentFileAccess.retrieveResMenuCmd();
            foreach (string cmd in cmdList)
            {
               
                string s = cmd.Trim();
                //skip a comment line
                if (s[0] == '#')
                    continue;

                int len = s.Length;

                int idx1 = s.IndexOf(',');
                if (idx1 <= 0 || idx1 == (len+1))
                    continue;

                NTMenuCommand menuCmd = new NTMenuCommand();

                int idx2 = s.IndexOf(',', idx1 + 1);

                if (idx2 > idx1+1)
                {
                    menuCmd.Arguments = s.Substring(idx2 + 1).Trim();
                    if (!probeCommand(menuCmd.Arguments))
                        continue;
                    menuCmd.FileName = s.Substring(idx1 + 1, idx2 - (idx1 + 1)).Trim();
                }
                else
                {
                    menuCmd.Arguments = string.Empty;
                    menuCmd.FileName = s.Substring(idx1 + 1).Trim();
                }
                menuCmd.DisplayText = s.Substring(0, idx1).Trim();

                mMenuCommands.Add(menuCmd);
            }

        }

        List<NTMenuCommand> mCmdList;

        NTResMenuCommand(FlowDocumentScrollViewer viewer, List<NTMenuCommand> mcList)
        {
            mViewer = viewer;
            mCmdList = mcList;
        }

        public static void createContextMenu(FlowDocumentScrollViewer viewer)
        {
            if (viewer == null)
                return ;

            ContextMenu cm = new ContextMenu();
            if (cm == null)
                return ;



            MenuItem mi = new MenuItem();
            mi.Command = ApplicationCommands.Copy;
            cm.Items.Add(mi);
            mi = new MenuItem();
            mi.Command = ApplicationCommands.Print;
            cm.Items.Add(mi);
            mi = new MenuItem();
            mi.Command = ApplicationCommands.Find;
            cm.Items.Add(mi);

            List<NTMenuCommand> mcList = NTResMenuCommand.getMenuCommands();
            NTResMenuCommand resCmd = new NTResMenuCommand(viewer, mcList);
            if (resCmd == null)
                return ;
            foreach (NTMenuCommand mc in mcList)
            {
                mi = new MenuItem();
                mi.Tag = resCmd;
                mi.Header = mc.DisplayText;
                mi.Click += MenuItem_Click;
                cm.Items.Add(mi);
            }

            viewer.ContextMenu = cm;

        }

 
        static void MenuItem_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            MenuItem mi = sender as MenuItem;
            if (mi == null)
                return;

            string header = mi.Header as string;
            if (header == null)
                return;

            NTResMenuCommand resCmd = mi.Tag as NTResMenuCommand;
            if (resCmd == null)
                return;

            List<NTMenuCommand> mcList = resCmd.mCmdList;
            NTMenuCommand mc = null;
            foreach (NTMenuCommand mc2 in mcList)
            {
                if (header.Equals(mc2.DisplayText))
                {
                    mc = mc2;
                    break;
                }
            }
            if (mc == null)
                return;


            string param = resCmd.getSelectedText();
            if (param == null)// || param.Length == 0)
                return;

            string param2 =
                string.Format(mc.Arguments, HttpUtility.UrlEncode(param));

            try
            {
                Process ie = Process.Start(mc.FileName, param2);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private bool isSelected()
        {
            string s = mViewer.Selection.Text;
            return (s != null && s.Length > 0) ;
        }

        private string getSelectedText()
        {
            return mViewer.Selection.Text;
        }


     


    }
}
