﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Media.Imaging;
using NT2chView.NtHtml;
using System.Runtime.Remoting.Contexts;
using NT2chCtrl;
using NT2chObject;


namespace NT2chView
{
    //[Synchronization]
    public sealed class NTRes : IRes
    {
        const string ID_TEXT = "ID:";
        public int getSequenceNo() { return mSeqNo; }
        public string getName() { return mName; }
        public string getMail() { return mMail; }
        public string getMsg() { return mMsg; }
        public string getMisc()
        {
            string buf;
            buf = (mDate != null) ? mDate : string.Empty;
            buf += (mId != null) ? (ID_TEXT + mId) : string.Empty;
            return buf;
        }
        public string getDate()
        {
            return mDate;
        }
        public string getID()
        {
            return mId;
        }
        public bool getAttribute(RES_ATTRIBUTE attr)
        {
            switch (attr)
            {
                case RES_ATTRIBUTE.MYMESSAGE:
                    return mWroteMsg;
                case RES_ATTRIBUTE.REPRY:
                    return mIsRepray;
                case RES_ATTRIBUTE.BOOKMARK:
                    return mBookmark;
                default:
                    return false;
            }
        }

        public int[] getReferenceArray() { return mRefferFrom.ToArray(); }
        private object mObjExtra;
        public object getExtra() { return mObjExtra; }
        public void setExtra(object o) { mObjExtra = o; }


        public string mName;
        public string mMail;
        public string mDate;
        public string mId;
        public string mMsg;
        public int mSeqNo;
        public bool mBookmark ;
        public bool mWroteMsg;
        public bool mIsRepray;
        public bool mIsDummy;

        public NTThreadTitle mThread;
        public List<int> mSameIdList = null;

        public int[] mRefferTo = null;
        public List<int> mRefferFrom = new List<int>();

        public Section mSection = null;

        public NTRes(NTThreadTitle thread,  int seqNo, string name, string mail, string date_id, string msg)
        {
            mThread = thread;
            mSeqNo = seqNo;
            mName = name;
            mMail = mail;
            mMsg = parseMsg(msg);
            mBookmark = false;
            mWroteMsg = false;
            mIsRepray = false;
            mIsDummy = false;

            

            int n = date_id.LastIndexOf(ID_TEXT);
            if (n > 0)
            {
                mId = date_id.Substring(n + ID_TEXT.Length);
                mDate = date_id.Substring(0, n).Trim();
                NTRes sameId = thread.findResById(mId);
                if (sameId != null)
                {
                    List<int> list = sameId.mSameIdList;
                    if (list == null)
                    {
                        list = new List<int>();
                        list.Add(sameId.mSeqNo);
                        sameId.mSameIdList = list;
                    }
                    list.Add(this.mSeqNo);
                    this.mSameIdList = list;
                }
            }
            else
            {
                mId = string.Empty;
                mDate = date_id;
            }
        }
#if false
        public void removeBookmark()
        {
            mBookmark = false;
            if (mSection == null)
                return;

            if (2 > mSection.Blocks.Count)
                return;

            Paragraph paraBody = mSection.Blocks.LastBlock as Paragraph;

            if (paraBody == null)
                return;

            Inline il = paraBody.Inlines.FirstInline;
            if (il == null)
                return;
            Span span = il as Span;
            if (span == null)
                return;
            Hyperlink hl = span as Hyperlink;
            if (hl != null)
                return;
            paraBody.Inlines.Remove(span);

            mThread.removeBookmark(mSeqNo);
        }

        public void addBookmark()
        {
            mBookmark = true;
            if (mSection == null)
                return;

            if (2 > mSection.Blocks.Count)
                return;

            Paragraph paraBody = mSection.Blocks.LastBlock as Paragraph;

            if (paraBody == null)
                return;

            Inline il = paraBody.Inlines.FirstInline;
            if(il == null )
                return;

            Span span = il as Span;
            if (span != null)
            {
                Hyperlink hl = span as Hyperlink;
                if(hl == null)
                    return;
            }

            // Create the image element.
            Image img = new Image();
            img.Width = 12;
            img.Height = 20;
            //Uri oUri = new Uri("pack://application:,,,/NT2chView;component/images/tag.png", UriKind.RelativeOrAbsolute);
            Uri oUri = new Uri("pack://application:,,,/NT2chStyle;component/images/tag.png", UriKind.RelativeOrAbsolute);
            BitmapImage bi = new BitmapImage();
            bi.BeginInit();
            bi.UriSource = oUri;

            bi.EndInit();
            // Set the image source.
            img.Source = bi;
            //Span span2 = new Span();
            //span2.Inlines.Add(img);
            img.VerticalAlignment = System.Windows.VerticalAlignment.Center;
            //img.Margin = new Thickness(3,2,3,0);
            span = new Span();
            span.Inlines.Add(img);
            paraBody.Inlines.InsertBefore(il, span);

            mThread.addBookmark(mSeqNo);

        }
#endif
        string parseMsg(string source)
        {
#if false
            int i = 0;
            int start = 0;
            StringBuilder
                sb = new StringBuilder(source.Length);
            for (; i < source.Length; i++)
            {
                switch (source[i])
                {
                    case '&':
                        int retLen;
                        if ((i + 1 < source.Length) && source[i + 1] == '#')
                        {
                            char c = NTHtmlUtils.parseHTMLDecimalHexEscape(source, i + 2, out retLen);
                            if (c != '\0')
                            {
                                if (start < i)
                                    sb.Append(source.Substring(start, i - start));
                                sb.Append(c);
                                start = retLen;
                                i = retLen - 1;

                            }
                        }
                        else
                        {
                            char c = NTHtmlUtils.HTMLEscapeTable.getCodeFromEscape(source, i + 1, out retLen);
                            if (c != '\0')
                            {
                                if (start < i)
                                    sb.Append(source.Substring(start, i - start));
                                sb.Append(c);
                                start = retLen;
                                i = retLen - 1;

                            }
                        }
                        break;
                }
            }
            if (start < source.Length)
            {
                sb.Append(source.Substring(start, source.Length - start));
            }

            source = sb.ToString();
#endif
            source = NTHtmlUtils.parseHTMLEscape(source);

            List<int> arr = NTTextFormat.parseReferenceNumber(source);
            if (null != arr)
                mRefferTo = arr.ToArray();
            else
                mRefferTo = null;

            return source;
        }
    }
}
