﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Documents;
using System.Windows.Media;

namespace NT2chView
{
    class NTMovieHistoryPopup : Popup
    {
        NTMovie mMovie;

        public NTMovieHistoryPopup(NTMovie movie)
        {
            mMovie = movie;

            StackPanel sp = new StackPanel();
            sp.Orientation = Orientation.Horizontal;


            StackPanel panel = new StackPanel();
            Border border = new Border();
            border.BorderThickness = new System.Windows.Thickness(1);
            border.BorderBrush = new SolidColorBrush(Colors.DarkGray);


            ListBoxItem item1 = new ListBoxItem();

            string title = movie.ID + ": " + movie.Caption;
            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run(title)));
            item1.Content = sp;
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new Separator());
            item1 = new ListBoxItem();
            item1.BorderBrush = new SolidColorBrush(Colors.LightGray);
            item1.BorderThickness = new System.Windows.Thickness(1);
            item1.Height = 1;
            item1.Content = sp;
            panel.Children.Add(item1);
            panel.Background = new SolidColorBrush(Colors.White);



            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("リストから削除")));
            sp.MouseLeftButtonDown += movieItemDelete_MouseLeftButtonDown;
            sp.Tag = movie;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("閉じる")));
            sp.MouseLeftButtonDown += movieItemClose_MouseLeftButtonDown;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);
            border.Child = panel;
            this.Child = border;
        }

        public void show()
        {
            IsOpen = true;
            Placement = PlacementMode.Mouse;
            Focus();
            this.StaysOpen = false;

        }


        void movieItemDelete_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            NTMovieHistory.RemoveMovie(mMovie);
            NTMovieHistory.Save();

        }

        void movieItemClose_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

        }
    }


}
