﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;
using NT2chView.NtUI;

namespace NT2chView
{
    /// <summary>
    /// NTFavoritePanel.xaml の相互作用ロジック
    /// </summary>
    public partial class NTFavoritePanel : UserControl
    {
        FlowDocument mThreadListDocument;
        System.Threading.Timer mTimer;
        System.Threading.Timer mUpdateTimer;
        object mLockTimerObj = new object();
        object mLockUpdateTimerObj = new object();
        bool mBoardDirty = false;
        bool mThreadDirty = false;

        NTBoard.DelegateMsgOnNotifyBoardUpdate mOnNotifyBoardUpdate;

        public MainWindow.DelegateMsgOpenThreadTitleListRequest2 OpenThreadTitleListRequest
        {
            get;
            set;
        }

        NTFavorite mFavorite;
        public NTFavorite FavoriteData 
        {
            set
            {
                initData(value);
                mFavorite = value;
            }
        } 

        public NTFavoritePanel()
        {
            InitializeComponent();

            mOnNotifyBoardUpdate = new NTBoard.DelegateMsgOnNotifyBoardUpdate(OnNotifyBoardUpdate);

        }

        private void NTFavoritePanel_Loaded(object sender, RoutedEventArgs e)
        {
            
        }

        public void OnClosing()
        {
            lock (mLockTimerObj)
            {
                if (mTimer != null)
                {
                    mTimer.Dispose();
                    // since a Thread.Timer.Timer works on a background thread,
                    // To avoid being killed by System when the process is terminated. 
                    Thread th = new Thread(saveFavoriteTimerCallback);
                    th.Start(null);
                    //mTimer.Change(0, Timeout.Infinite);
                    //mTimer = null;
                }
            }
            lock (mLockUpdateTimerObj)
            {
                if (mUpdateTimer != null)
                {
                    mUpdateTimer.Dispose();
                }
            }
        }

        private void setDirty(bool board)
        {

            lock (mLockTimerObj)
            {
                if (board)
                    mBoardDirty = true;
                else
                    mThreadDirty = true;

                if (mTimer == null)
                    mTimer = new System.Threading.Timer(saveFavoriteTimerCallback, null, 15000, Timeout.Infinite);
                else
                    mTimer.Change(15000, Timeout.Infinite);
            }
        }

        private void setUpdateTimer(int millisecond)
        {
            lock (mLockUpdateTimerObj)
            {
                if (millisecond <= 0)
                {
                    if (mUpdateTimer != null)
                    {
                        mUpdateTimer.Dispose();
                        mUpdateTimer = null;
                    }
                }
                else
                {
                    if (mUpdateTimer == null)
                        mUpdateTimer = new System.Threading.Timer(
                            updateFavoriteTimerCallback, null, millisecond, millisecond);
                    else
                        mUpdateTimer.Change(millisecond, millisecond);
                }
            }

        }


        /*void btn_LayoutUpdated(object sender, EventArgs e)
        {
            //NTDebug.l(sender.ToString());
        }
        private void TestButtonLoaded(
            Object sender,
            RoutedEventArgs e
        )
        {
            NTDebug.l(sender.ToString());
        }*/

        public void addBoard(NTFavoriteBoard fb)
        {
            if (mFavoriteBoardPanel == null)
                return;

            Button btn = new Button();
            if (btn == null)
                return;
            Style style = (Style)TryFindResource("FavoriteBoardDisplayButton");
            
            fb.setButton(btn);
            if(style != null)
                btn.Style = style;
            btn.Content = fb.BoardName;
            btn.Tag = fb;
            btn.Click += boardBtn_Click;
            btn.DragEnter += boardBtn_DragEnter;
            btn.DragLeave += boardBtn_DragLeave;
            btn.DragOver += boardBtn_DragOver;
            btn.Drop += boardBtn_Drop;
            btn.MouseRightButtonDown += boardBtn_MouseRightButtonDown;
            btn.MouseRightButtonUp += boardBtn_MouseRightButtonUp;
            btn.AllowDrop = true;

            mFavoriteBoardPanel.Children.Add(btn);
            setDirty(true);
  
        }
        private void initData(NTFavorite favorite)
        {
            Style style = (Style)TryFindResource("FavoriteBoardDisplayButton");
            //Style style2 = (Style)TryFindResource("FavoriteThreadDisplayButton");
            //Style style3 = (Style)TryFindResource("FavoriteThreadDisplayButtonHeader");

            

            List<NTFavoriteBoard> boardList = favorite.getBoardList();
            foreach (NTFavoriteBoard fb in boardList)
            {
                Button btn = new Button();
                if (btn != null)
                {
                    fb.setButton(btn);
                    btn.Style = style;
                    btn.Content = fb.BoardName;
                    btn.Tag = fb;
                    btn.Click += boardBtn_Click;
                    btn.DragEnter += boardBtn_DragEnter;
                    btn.DragLeave += boardBtn_DragLeave;
                    btn.DragOver += boardBtn_DragOver;
                    btn.Drop += boardBtn_Drop;
                    btn.MouseRightButtonDown += boardBtn_MouseRightButtonDown;
                    btn.MouseRightButtonUp += boardBtn_MouseRightButtonUp;
                    btn.AllowDrop = true;

                    mFavoriteBoardPanel.Children.Add(btn);
                }
            }

            Dictionary<string, NTBoard> boardListForUpdate = 
                new Dictionary<string, NTBoard>();


            List<NTFavoriteThreadTag> tagList = favorite.getThreadTagList();

            mPanelMain.MouseWheel += mPanelMain_MouseWheel;
#if DOTNET45
            mPanelMain.TouchDown += mPanelMain_TouchDown;
            //mPanelMain.TouchEnter += mPanelMain_TouchEnter;
            mPanelMain.TouchMove += mPanelMain_TouchMove;
            mPanelMain.TouchUp += mPanelMain_TouchUp;
#endif
            foreach (NTFavoriteThreadTag tag in tagList)
            {
                string tagName = tag.getTagName();

                Expander exp = new Expander();
                exp.Header = tagName;
                Grid grid = new Grid();
                exp.Content = grid;
                exp.Tag = tag;
                exp.AllowDrop = true;
                exp.Drop += threadTagExpander_Drop;

                if(!tagName.Equals("お気に入りのスレ"))
                    exp.MouseRightButtonUp += threadTagExpander_MouseRightButtonUp;
                mPanelMain.Children.Add(exp);


                FlowDocumentScrollViewer sv = new FlowDocumentScrollViewer();
                sv.VerticalScrollBarVisibility = ScrollBarVisibility.Hidden;
                FlowDocument document = new FlowDocument();
                sv.Document = document;
                mThreadListDocument = document;
                grid.Children.Add(sv);

                document.AllowDrop = true;
                document.Cursor = Cursors.Arrow;



                List<NTFavoriteThread> threadList = tag.getThreadList();
                foreach (NTFavoriteThread thread in threadList)
                {
                    thread.setScrollViewer(mFavoritePanelScrollViewer, mPanelMain);
                    string boardName = thread.BoardName;
                    if (boardName != null && boardName.Length > 0 &&
                            !boardListForUpdate.ContainsKey(boardName))
                    {
                        NTBoard board = NTDataRoot.getBoardByName(boardName);
                        if (board != null)
                            boardListForUpdate.Add(thread.BoardName, board);
                    }
                    Paragraph para = thread.createParagraph();
                    if (para == null)
                        continue;
                    para.AllowDrop = true;
                    para.Cursor = Cursors.Hand;
                    para.DragEnter += threadParagraph_DragEnter;
                    para.DragOver += threadParagraph_DragOver;
                    para.DragLeave += threadParagraph_DragLeave;
                    para.Drop += threadParagraph_Drop;
                    para.MouseRightButtonDown += threadParagraph_MouseRightButtonDown;
                    para.MouseRightButtonUp += threadParagraph_MouseRightButtonUp;
                    document.Blocks.Add(para);

                }

                exp.IsExpanded = tag.Opened();

            }

            foreach(NTBoard board in boardListForUpdate.Values)
            {
                board.Update(mOnNotifyBoardUpdate);
            }

 
        }

#if DOTNET45
        bool fDown = false;
        TouchPoint mPos;
        double mVOffest;
        void mPanelMain_TouchUp(object sender, TouchEventArgs e)
        {
            fDown = false;
            e.Handled = true;
        }

        void mPanelMain_TouchMove(object sender, TouchEventArgs e)
        {
            if (!fDown)
                return;
            if (mFavoritePanelScrollViewer == null)
                return;


            TouchPoint pos = e.GetTouchPoint(mPanelMain);
            double y = mPos.Position.Y - pos.Position.Y;
            double newOffset = mVOffest + y;
            if (mFavoritePanelScrollViewer != null)
                mFavoritePanelScrollViewer.ScrollToVerticalOffset(newOffset);

            e.Handled = true;
        }


        void mPanelMain_TouchDown(object sender, TouchEventArgs e)
        {
            if (mFavoritePanelScrollViewer == null)
                return;

            try
            {
                mPos = e.GetTouchPoint(mPanelMain);
                mVOffest = mFavoritePanelScrollViewer.VerticalOffset;
                fDown = true;
                e.Handled = true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
#endif
        void mPanelMain_MouseWheel(object sender, MouseWheelEventArgs e)
        {
            int d = e.Delta;
            if (d == 0)
                return;
            if (mFavoritePanelScrollViewer == null)
                return;

            int vOffset = (int)mFavoritePanelScrollViewer.VerticalOffset;

            vOffset -= e.Delta;

            mFavoritePanelScrollViewer.ScrollToVerticalOffset(vOffset);

        }

        //void unhandle_MouseWheel(object sender, MouseWheelEventArgs e)
        //{
        //    e.Handled = false;
            //throw new NotImplementedException();
        //}

        void addFavoriteTag(string tagName)
        {
            int nChild = mPanelMain.Children.Count;
            if (nChild < 2)
                return;
            //already exists such name.
            if(null != mFavorite.findTag(tagName))
                return;

            NTFavoriteThreadTag tag = 
                mFavorite.insertThreadTagByDescription(tagName+",0,update", false, true);
            if (tag == null)
                return;

            Expander exp = new Expander();
            exp.Header = tagName;
            Grid grid = new Grid();
            exp.Content = grid;
            exp.Tag = tag;
            exp.AllowDrop = true;
            exp.Drop += threadTagExpander_Drop;
            exp.MouseRightButtonUp += threadTagExpander_MouseRightButtonUp;

            mPanelMain.Children.Insert(nChild - 1, exp);
            FlowDocumentScrollViewer sv = new FlowDocumentScrollViewer();
            sv.VerticalScrollBarVisibility = ScrollBarVisibility.Hidden;
            FlowDocument document = new FlowDocument();
            sv.Document = document;
            grid.Children.Add(sv);

            setDirty(false);
        }

        Expander getExpanderByThreadTag(NTFavoriteThreadTag tag)
        {
            if (tag == null)
                return null;

            foreach (UIElement ui in mPanelMain.Children)
            {
                Expander exp = ui as Expander;
                if (exp == null)
                    continue;

                if (tag.Equals(exp.Tag))
                    return exp;
            }
            return null;
        }

        FlowDocument getFlowDocumentFromExpander(Expander expander)
        {
            Grid grid = expander.Content as Grid;
            if (grid == null || grid.Children.Count == 0)
                return null;
            FlowDocumentScrollViewer sv = grid.Children[0] as FlowDocumentScrollViewer;
            if (sv == null)
                return null;

            return sv.Document;
        }


        void boardBtn_Drop(object sender, DragEventArgs e)
        {
            //NTDebug.l("Drop");
            Button btn = sender as Button;
            if (btn == null)
                return;

            NTFavoriteBoard destBoard = btn.Tag as NTFavoriteBoard;
            if (destBoard == null)
                return;

            destBoard.setDragOverBrush(false);

            IDataObject data = e.Data;


            if (data.GetDataPresent(NTDragDrop.BOARD_DRAG_DATA_FORMAT))
            {
                NTDragDrop.BoardData
                    boardData =
                        data.GetData(NTDragDrop.BOARD_DRAG_DATA_FORMAT)
                        as NTDragDrop.BoardData;
                if (boardData == null)
                    return;

                List<NTFavoriteBoard> boardList =
                        mFavorite.getBoardList();
                if (boardList == null)
                    return;

                int srcIdx = mFavorite.findBoard(boardData.BoardName);
                if (srcIdx < 0)
                    return;

                int destIdx = mFavorite.findBoard(destBoard.BoardName);
                if (destIdx < 0)
                    return;

                if (srcIdx == destIdx)
                    return;

                Button findBoardBtn = null;

                foreach (UIElement element in mFavoriteBoardPanel.Children)
                {
                    btn = element as Button;
                    if (btn == null)
                        continue;
                    NTFavoriteBoard board = btn.Tag as NTFavoriteBoard;
                    if (board == null)
                        continue;

                    if (boardList[srcIdx].Equals(board))
                    {
                        findBoardBtn = btn;
                        mFavoriteBoardPanel.Children.Remove(btn);
                        break;
                    }
                }

                if (findBoardBtn == null)
                    return;


                foreach (UIElement element in mFavoriteBoardPanel.Children)
                {
                    btn = element as Button;
                    if (btn == null)
                        continue;
                    NTFavoriteBoard board = btn.Tag as NTFavoriteBoard;
                    if (board == null)
                        continue;

                    if (destBoard.Equals(board))
                    {
                        int idx = mFavoriteBoardPanel.Children.IndexOf(element);
                        if (idx < 0)
                            return;
                        mFavoriteBoardPanel.Children.Insert(idx+1, findBoardBtn);
                        break;
                    }
                }

                NTFavoriteBoard fb = boardList[srcIdx];
                boardList.RemoveAt(srcIdx);
                if (srcIdx < destIdx)
                    destIdx--;
                boardList.Insert(destIdx + 1, fb);

                e.Handled = true;

                setDirty(true);

            }
        }


        void boardBtn_DragLeave(object sender, DragEventArgs e)
        {
            Button btn = sender as Button;
            if (btn == null)
                return;

            NTFavoriteBoard board = btn.Tag as NTFavoriteBoard;
            if (board == null)
                return;

            board.setDragOverBrush(false);
        }

        void boardBtn_DragOver(object sender, DragEventArgs e)
        {
            validateBoardDropData(sender, e, false);
        }

        void boardBtn_DragEnter(object sender, DragEventArgs e)
        {
            validateBoardDropData(sender, e, true);
        }

        void boardBtn_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {
            e.Handled = true;
        }
        void boardBtn_MouseRightButtonUp(object sender, MouseButtonEventArgs e)
        {
            Button btn = sender as Button;
            if (btn == null)
                return;

            NTFavoriteBoard fb = btn.Tag as NTFavoriteBoard;
            if (fb == null)
                return;

            NTFavoriteBoardPopupMenu popup = new NTFavoriteBoardPopupMenu(fb);
            popup.OnNotifiDeleteFavoriteBoard +=
                new NTFavoriteBoardPopupMenu.DelegateMsgOnNotifiDeleteFavoriteBoard(
                    OnNotifiDeleteFavoriteBoard);
            popup.show();
            e.Handled = true;
        }

        void OnNotifiDeleteFavoriteBoard(NTFavoriteBoard fb)
        {
            //NTDebug.l("Delete Call: " + ft.Title);
            mFavorite.removeBoardByBoardName(fb.BoardName, false);
            foreach (UIElement element in mFavoriteBoardPanel.Children)
            {
                Button btn = element as Button;
                if (btn == null)
                    continue;
                NTFavoriteBoard board = btn.Tag as NTFavoriteBoard;
                if (board == null)
                    continue;

                if (fb.Equals(board))
                {
                    mFavoriteBoardPanel.Children.Remove(btn);
                    setDirty(true);
                    break;
                }
            }
        }

        void threadParagraph_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {
            //NTFavoriteThreadPopupMenu popup = new NTFavoriteThreadPopupMenu();
            //popup.show();
            e.Handled = true;
        }
        void threadParagraph_MouseRightButtonUp(object sender, MouseButtonEventArgs e)
        {
            Paragraph para = sender as Paragraph;
            if (para == null)
                return;

            NTFavoriteThread ft = para.Tag as NTFavoriteThread;
            if (ft == null)
                return;


            NTFavoriteThreadPopupMenu popup = new NTFavoriteThreadPopupMenu(ft);
            popup.OnNotifiDeleteFavoriteThread += 
                new NTFavoriteThreadPopupMenu.DelegateMsgOnNotifiDeleteFavoriteThread(
                    OnNotifiDeleteFavoriteThread);
            popup.show();
            e.Handled = true;
        }

        void threadTagExpander_MouseRightButtonUp(object sender, MouseButtonEventArgs e)
        {
            Expander exp = sender as Expander;
            if (exp == null)
                return;

            NTFavoriteThreadTag tag = exp.Tag as NTFavoriteThreadTag;
            if (tag == null)
                return;


            NTFavoriteThreadTagPopupMenu popup = new NTFavoriteThreadTagPopupMenu(tag);
            popup.OnNotifiDeleteFavoriteThreadTag +=
                new NTFavoriteThreadTagPopupMenu.DelegateMsgOnNotifiDeleteFavoriteThreadTag(
                    OnNotifiDeleteFavoriteThreadTag);
            popup.OnNotifiChangeFavoriteThreadTagName +=
                new NTFavoriteThreadTagPopupMenu.DelegateMsgOnNotifiChangeFavoriteThreadTagName(
                    OnNotifiChangeFavoriteThreadTagName);
            popup.show();
            e.Handled = true;
        }

        public void addThread(NTFavoriteThread ft)
        {
            if (mThreadListDocument == null)
                return;

            Paragraph para = ft.createParagraph();
            if (para == null)
                return;
            para.AllowDrop = true;
            para.DragEnter += threadParagraph_DragEnter;
            para.DragOver += threadParagraph_DragOver;
            para.DragLeave += threadParagraph_DragLeave;
            para.Drop += threadParagraph_Drop;
            //mThreadListDocument.Blocks.Add(para);
            List<NTFavoriteThreadTag> tagList = mFavorite.getThreadTagList();
            if (tagList.Count == 0)
                return;

            NTFavoriteThreadTag tag = tagList[tagList.Count - 1];
            List<NTFavoriteThread> threadList = tag.getThreadList();
            threadList.Add(ft);
            tag.setCount(threadList.Count);

            Expander exp = getExpanderByThreadTag(tag);
            if (exp == null)
                return;
            FlowDocument doc = getFlowDocumentFromExpander(exp);
            if (doc == null)
                return;

            doc.MouseWheel += doc_MouseWheel;

            doc.Blocks.Add(para);


            setDirty(false);


        }

        void doc_MouseWheel(object sender, MouseWheelEventArgs e)
        {
            //throw new NotImplementedException();
        }

        void OnNotifiDeleteFavoriteThreadTag(NTFavoriteThreadTag tag, bool withItem)
        {
            Expander exp = getExpanderByThreadTag(tag);
            if (exp == null)
                return;

            int threadIdx = 0;
            List<NTFavoriteThreadTag> tagList = mFavorite.getThreadTagList();
            foreach (NTFavoriteThreadTag tmpTag in tagList)
            {
                if(tmpTag.Equals(tag))
                {
                    List<NTFavoriteThread> threadList = mFavorite.getThreadList();
                    List<NTFavoriteThread> moveThreadList = new List<NTFavoriteThread>(); 
                    int removeCount = tmpTag.getCount();
                    if ((threadIdx + removeCount) > threadList.Count)
                        return;
                    for (int i = 0; i < removeCount; i++)
                    {
                        if(!withItem)
                            moveThreadList.Add(threadList[threadIdx]);
                        threadList.RemoveAt(threadIdx);
                    }
                    tagList.Remove(tag);
                    if (!withItem)
                    {
                        Expander exp2 = null;
                        FlowDocument doc2 = null;
                        int nLastParagraph = mPanelMain.Children.Count;
                        if (nLastParagraph > 0)
                        {
                            exp2 = mPanelMain.Children[nLastParagraph - 1] as Expander;
                            doc2 = getFlowDocumentFromExpander(exp2);
                        }
                        foreach (NTFavoriteThread thread in moveThreadList)
                        {
                            threadList.Add(thread);
                            if (doc2 != null)
                            {
                                Paragraph para = thread.createParagraph();
                                if (para != null)
                                {
                                    para.AllowDrop = true;
                                    para.DragEnter += threadParagraph_DragEnter;
                                    para.DragOver += threadParagraph_DragOver;
                                    para.DragLeave += threadParagraph_DragLeave;
                                    para.Drop += threadParagraph_Drop;
                                    para.MouseRightButtonDown += threadParagraph_MouseRightButtonDown;
                                    para.MouseRightButtonUp += threadParagraph_MouseRightButtonUp;
                                    doc2.Blocks.Add(para);
                                }
                            }
                        }
                    }
                    mPanelMain.Children.Remove(exp);
                    setDirty(false);
                    break;
                }
                threadIdx += tmpTag.getCount();
            }           
        }
        void OnNotifiChangeFavoriteThreadTagName(NTFavoriteThreadTag tag)
        {
            Expander exp = getExpanderByThreadTag(tag);
            if (exp == null)
                return;

            exp.Header = tag.getTagName();
            setDirty(false);
        }

        void OnNotifiDeleteFavoriteThread(NTFavoriteThread ft)
        {
            removeThread(ft);
        }

        public void removeThread(NTFavoriteThread ft)
        {
            int idx = mFavorite.findThread(ft);
            if (idx < 0)
                return;

            List<NTFavoriteThread> threadList = mFavorite.getThreadList();
            //NTFavoriteThread srcThread = threadList[idx];
            NTFavoriteThreadTag tag = mFavorite.findTag(ft);
            if (tag == null)
                return;

            Expander exp = getExpanderByThreadTag(tag);
            if (exp == null)
                return;
            FlowDocument doc = getFlowDocumentFromExpander(exp);
            if (doc == null)
                return;

           // Paragraph paraRemoved = null;
            foreach (Block block in doc.Blocks)
            {
                Paragraph para1 = block as Paragraph;
                if (para1 == null)
                    continue;
                if (ft.Equals(para1.Tag))
                {
                    if (doc.Blocks.Remove(para1))
                    {
                        threadList.RemoveAt(idx);
                        tag.setCount(tag.getCount() - 1);
                        setDirty(false);
                    }
                    break;
                }
            }
        }


        void threadParagraph_DragLeave(object sender, DragEventArgs e)
        {
            Paragraph para = sender as Paragraph;
            if (para == null)
                return;

            NTFavoriteThread thread = para.Tag as NTFavoriteThread;
            if (thread == null)
                return;

            thread.setDragOverBrush(false);
        }

        void threadParagraph_DragEnter(object sender, DragEventArgs e)
        {
            validateThreadDropData(sender, e, true);
        }

        void threadParagraph_DragOver(object sender, DragEventArgs e)
        {
            validateThreadDropData(sender, e, false);
        }

        void threadParagraph_Drop(object sender, DragEventArgs e)
        {
            //NTDebug.l("Drop");
            Paragraph para = sender as Paragraph;
            if (para == null)
                return;

            NTFavoriteThread destThread = para.Tag as NTFavoriteThread;
            if (destThread == null)
                return;

            destThread.setDragOverBrush(false);

            IDataObject data = e.Data;


            if (!data.GetDataPresent(NTDragDrop.THREAD_DRAG_DATA_FORMAT))
                return;

            NTDragDrop.ThreadData
                threadData = 
                    data.GetData(NTDragDrop.THREAD_DRAG_DATA_FORMAT)
                    as NTDragDrop.ThreadData;
            if (threadData == null)
                return;

            List<NTFavoriteThread> threadList = 
                    mFavorite.getThreadList();
            if(threadList == null)
                return;

            int srcIdx = mFavorite.findThread(threadData.BoardName, 
                threadData.Address,
                threadData.Title);
            if (srcIdx < 0)
                return;

            int destIdx = mFavorite.findThread(destThread);
            if (destIdx < 0)
                return;

            if (srcIdx == destIdx)
                return;

            NTFavoriteThread srcThread = threadList[srcIdx];
            NTFavoriteThreadTag srcTag = mFavorite.findTag(srcThread);
            if (srcTag == null)
                return;

            Expander srcExp = getExpanderByThreadTag(srcTag);
            if (srcExp == null)
                return;
            FlowDocument srcDoc = getFlowDocumentFromExpander(srcExp);
            if (srcDoc == null)
                return;

            Paragraph paraRemoved = null;
            foreach (Block block in srcDoc.Blocks)
            {
                Paragraph para1 = block as Paragraph;
                if (para1 == null)
                    continue;
                if (srcThread.Equals(para1.Tag))
                {
                    if(srcDoc.Blocks.Remove(para1))
                        paraRemoved = para1;
                    break;
                }
            }
            if (paraRemoved == null)
                return;

            NTFavoriteThreadTag destTag = mFavorite.findTag(threadList[destIdx]);
            if (destTag == null)
                return;
            Expander destExp = getExpanderByThreadTag(destTag);
            if (destExp == null)
                return;
            FlowDocument destDoc = getFlowDocumentFromExpander(destExp);
            if (destDoc == null)
                return;

            foreach (Block block in destDoc.Blocks)
            {
                Paragraph para1 = block as Paragraph;
                if (para1 == null)
                    continue;
                if (destThread.Equals(para1.Tag))
                {
                    Paragraph para2 = srcThread.createParagraph();
                    if (para2 == null)
                        continue;
                    para2.AllowDrop = true;
                    para2.DragEnter += threadParagraph_DragEnter;
                    para2.DragOver += threadParagraph_DragOver;
                    para2.DragLeave += threadParagraph_DragLeave;
                    para2.Drop += threadParagraph_Drop;
                    para2.MouseRightButtonDown += threadParagraph_MouseRightButtonDown;
                    para2.MouseRightButtonUp += threadParagraph_MouseRightButtonUp;
                    destDoc.Blocks.InsertAfter(para1, para2);
                    break;
                }
            }

            srcTag.getThreadList().Remove(srcThread);
            int n1 = destTag.getThreadList().IndexOf(destThread);
            if(n1 >= 0)
                destTag.getThreadList().Insert(n1, srcThread);

            threadList.RemoveAt(srcIdx);
            if (srcIdx < destIdx)
                destIdx--;
            threadList.Insert(destIdx + 1, srcThread);

            if (!srcTag.Equals(destTag))
            {
                srcTag.setCount(srcTag.getCount() - 1);
                destTag.setCount(destTag.getCount() + 1);
                updateExpanderHeader(srcTag);
                updateExpanderHeader(destTag);
            }

            setDirty(false);
            
        }

        void threadTagExpander_Drop(object sender, DragEventArgs e)
        {
            Expander destExp = sender as Expander;
            if (destExp == null)
                return;

            NTFavoriteThreadTag destTag = destExp.Tag as NTFavoriteThreadTag;
            if (destTag == null)
                return;

            IDataObject data = e.Data;

            if (!data.GetDataPresent(NTDragDrop.THREAD_DRAG_DATA_FORMAT))
                return;

            NTDragDrop.ThreadData
                threadData =
                    data.GetData(NTDragDrop.THREAD_DRAG_DATA_FORMAT)
                    as NTDragDrop.ThreadData;
            if (threadData == null)
                return;

            List<NTFavoriteThread> threadList =
                    mFavorite.getThreadList();
            if (threadList == null)
                return;

            int srcIdx = mFavorite.findThread(threadData.BoardName,
                threadData.Address,
                threadData.Title);
            if (srcIdx < 0)
                return;

            NTFavoriteThread srcThread = threadList[srcIdx];
            NTFavoriteThreadTag srcTag = mFavorite.findTag(srcThread);
            if (srcTag == null)
                return;

            Expander srcExp = getExpanderByThreadTag(srcTag);
            if (srcExp == null)
                return;

            FlowDocument srcDoc = getFlowDocumentFromExpander(srcExp);
            if (srcDoc == null)
                return;

            Paragraph paraRemoved = null;
            foreach (Block block in srcDoc.Blocks)
            {
                Paragraph para1 = block as Paragraph;
                if (para1 == null)
                    continue;
                if (srcThread.Equals(para1.Tag))
                {
                    if (srcDoc.Blocks.Remove(para1))
                        paraRemoved = para1;
                    break;
                }
            }
            if (paraRemoved == null)
                return;

            FlowDocument destDoc = getFlowDocumentFromExpander(destExp);
            if (destDoc == null)
                return;

            Block firstBlock = destDoc.Blocks.FirstBlock;
            if (firstBlock != null)
                destDoc.Blocks.InsertBefore(firstBlock, paraRemoved);
            else
                destDoc.Blocks.Add(paraRemoved);

            if (!srcTag.Equals(destTag))
            {
                srcTag.setCount(srcTag.getCount() - 1);
                destTag.setCount(destTag.getCount() + 1);
            }

            threadList.RemoveAt(srcIdx);

            int insertIdx = 0;
            List<NTFavoriteThreadTag> tagList = mFavorite.getThreadTagList();
            foreach(NTFavoriteThreadTag tag in tagList)
            {
                if (tag.Equals(destTag))
                {
                    threadList.Insert(insertIdx, srcThread);
                    break;
                }
                insertIdx += tag.getCount();
            }

            setDirty(false);

       }

        void validateBoardDropData(object sender, DragEventArgs e, bool startEvent)
        {

            Button btn = sender as Button;
            if (btn == null)
                return;

            NTFavoriteBoard destBoard = btn.Tag as NTFavoriteBoard;
            if (destBoard == null)
                return;

            if(startEvent)
                destBoard.setDragOverBrush(true);

            IDataObject data = e.Data;

            
            if (!data.GetDataPresent(NTDragDrop.BOARD_DRAG_DATA_FORMAT))
            {
                //NTDebug.l("Drag Enter None");
                e.Effects = DragDropEffects.None;
            }
            else
            {
                //NTDebug.l("Drag Enter All");
                NTDragDrop.BoardData
                    boardData =
                        data.GetData(NTDragDrop.BOARD_DRAG_DATA_FORMAT)
                        as NTDragDrop.BoardData;
                if (boardData == null)
                {
                    e.Effects = DragDropEffects.None;
                    return;
                }

                List<NTFavoriteBoard> boardList =
                        mFavorite.getBoardList();
                if (boardList == null)
                {
                    e.Effects = DragDropEffects.None;
                    return;
                }

                int srcIdx = mFavorite.findBoard(boardData.BoardName);
                if (srcIdx < 0)
                {
                    e.Effects = DragDropEffects.None;
                    return;
                }

                int destIdx = mFavorite.findBoard(destBoard.BoardName);
                if (destIdx < 0)
                {
                    e.Effects = DragDropEffects.None;
                    return;
                }

                if (srcIdx == destIdx)
                {
                    e.Effects = DragDropEffects.None;
                    return;
                }
                e.Effects = DragDropEffects.Move;
                e.Handled = true;
            }
        }

        void validateThreadDropData(object sender, DragEventArgs e, bool startEvent)
        {

            Paragraph para = sender as Paragraph;
            if (para == null)
                return;

            NTFavoriteThread destThread = para.Tag as NTFavoriteThread;
            if (destThread == null)
                return;

            if (startEvent)
                destThread.setDragOverBrush(true);

            IDataObject data = e.Data;


            if (!data.GetDataPresent(NTDragDrop.THREAD_DRAG_DATA_FORMAT))
            {
                //NTDebug.l("Drag Enter None");
                e.Effects = DragDropEffects.None;
            }
            else
            {
                //NTDebug.l("Drag Enter All");
                NTDragDrop.ThreadData
                    threadData =
                        data.GetData(NTDragDrop.THREAD_DRAG_DATA_FORMAT)
                        as NTDragDrop.ThreadData;
                if (threadData == null)
                {
                    e.Effects = DragDropEffects.None;
                    return;
                }

                List<NTFavoriteThread> threadList =
                        mFavorite.getThreadList();
                if (threadList == null)
                {
                    e.Effects = DragDropEffects.None;
                    return;
                }

                int srcIdx = mFavorite.findThread(threadData.BoardName,
                    threadData.Address,
                    threadData.Title);
                if (srcIdx < 0)
                {
                    e.Effects = DragDropEffects.None;
                    return;
                }

                int destIdx = mFavorite.findThread(destThread);
                if (destIdx < 0)
                {
                    e.Effects = DragDropEffects.None;
                    return;
                }

                if (srcIdx == destIdx)
                {
                    e.Effects = DragDropEffects.None;
                    return;
                }
                e.Effects = DragDropEffects.Move;
                e.Handled = true;
            }
        }

        public void OnNotifyBoardUpdate(NTBoard board)
        {
            if (mFavorite == null)
                return;

            List<NTFavoriteThreadTag> tagList = mFavorite.getThreadTagList();
            foreach (NTFavoriteThreadTag tag in tagList)
            {
                bool update = false;
                List<NTFavoriteThread> threadList = tag.getThreadList();
                foreach (NTFavoriteThread thread in threadList)
                {
                    string boardName = thread.BoardName;
                    if (board.mName.Equals(boardName))
                    {
                        NTThreadTitle tt = board.findThreadTitleByDatName(thread.Address);
                        if (tt != null)
                        {
                            thread.updateParagraph(tt);
                            update = true;
                        }
                    }
                }
                if (update)
                    updateExpanderHeader(tag);
            }
         }

        void updateExpanderHeader(NTFavoriteThreadTag tag)
        {
            Expander exp = getExpanderByThreadTag(tag);
            if (exp == null)
                return;
            int nNewMsg = 0;

            List<NTFavoriteThread> threadList = tag.getThreadList();
            foreach (NTFavoriteThread thread in threadList)
            {
                NTBoard board = NTDataRoot.getBoardByName(thread.BoardName);
                if (board == null)
                    continue;
                NTThreadTitle tt = board.findThreadTitleByDatName(thread.Address);
                if(tt == null)
                    continue;
                if (tt.ReadCnt > 0 &&
                    tt.RemainCnt > 0)
                {
                    nNewMsg++;
                }
            }
            StackPanel sp = new StackPanel();
            sp.Orientation = Orientation.Horizontal;
            TextBlock tb = new TextBlock(new Run(tag.getTagName()));
            sp.Children.Add(tb);
            if (nNewMsg > 0)
            {
                string s = " 新着 " + nNewMsg.ToString() + "件";
                tb = new TextBlock(new Run(s));
                tb.Foreground = new SolidColorBrush(Colors.Red);
                sp.Children.Add(tb);
            }
            exp.Header = sp;

        }

        void boardBtn_Click(object sender, RoutedEventArgs e)
        {
            if (OpenThreadTitleListRequest == null)
                return;
            Button btn = sender as Button;
            if (btn == null)
                return;

            NTFavoriteBoard fb = btn.Tag as NTFavoriteBoard;
            if (fb == null)
                return;

            OpenThreadTitleListRequest(fb.BoardName);
        }

         /*void btn_Click21(object sender, RoutedEventArgs e)
        {
           
            NTBoard board = NTDataRoot.getBoardByName(values[1]);
            if (board == null)
                return;

            if (!OpenNewBoard(board))
                return;

            NTThreadTitle tt = board.findThreadTitleByDatName(values[0]);
            if (tt != null)
            {
                OpenNewThread(tt);
            }
        
        }*/

        private void btnNewFolder_Click(object sender, RoutedEventArgs e)
        {
            string folderName = mEdtFolderName.Text;
            if (folderName == null || folderName.Length == 0)
                return;

            addFavoriteTag(folderName);

        }

        bool mUpdateing = false;
        private void btnUpdateTimer_Click(object sender, RoutedEventArgs e)
        {
            mUpdateing = !mUpdateing;
            if (mUpdateing)
            {
                int duration = NTUserPreference.FavoriteUpdateDuration;
                btnUpdateTimer.Background = new SolidColorBrush(Colors.Blue);
                setUpdateTimer(duration * 60 * 1000);

            }
            else
            {
                btnUpdateTimer.Background = null;
                setUpdateTimer(0);//dispose update timer.
            }
        }
        private void btnUpdate_Click(object sender, RoutedEventArgs e)
        {
            updateFavorite();
        }

        private void updateFavorite()
        {

            if (mFavorite == null)
                return;

            Dictionary<string, NTBoard> boardListForUpdate =
                new Dictionary<string, NTBoard>();

            List<NTFavoriteThread> threadList = mFavorite.getThreadList();
            foreach (NTFavoriteThread thread in threadList)
            {
                string boardName = thread.BoardName;
                if (boardName != null &&
                        !boardListForUpdate.ContainsKey(boardName))
                {
                    NTBoard board = NTDataRoot.getBoardByName(boardName);
                    if (board != null)
                        boardListForUpdate.Add(thread.BoardName, board);
                }
            }

            foreach (NTBoard board in boardListForUpdate.Values)
            {
                board.Update(null);
            }

        }

        private void updateFavoriteTimerCallback(object StateObj)
        {
            DateTime dt = DateTime.Now;
            string strTime = dt.ToString();
            NTDebug.l("*** Timer called in updateFavoriteTimerCallback ***");
            NTDebug.l("\tBackgroud:" + Thread.CurrentThread.IsBackground + " on " + strTime);

            this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
            (ThreadStart)delegate()
            {

                updateFavorite();
            });
        }
        private void saveFavoriteTimerCallback(object StateObj)
        {
            
            lock (mLockTimerObj)
            {
                if (mTimer != null)
                {
                    mTimer.Dispose();
                    mTimer = null;

                    if (mBoardDirty)
                        mFavorite.updateFavoriteBoards();
                    if (mThreadDirty)
                        mFavorite.updateFavoriteThread();

                    mBoardDirty = false;
                    mThreadDirty = false;
                }
            }

        }
     }
}
