﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Media;
using NT2chView.NtUI;

namespace NT2chView
{
    public class NTFavoriteBoard
    {
        Button mButton;
        Point mMouseObservePoint;
        bool mMousePressed = false;
        string mBoardName;
        Brush mFavoriteBKBrush;
        Brush mFavoriteDragOverBKBrush;
        public NTFavoriteBoard(string boardName)
        {
            mBoardName = boardName;
            mFavoriteDragOverBKBrush = (Brush)
               NTAppState.getMainWindow().TryFindResource("FavoriteBoardDragOverBKBrush");
            mFavoriteBKBrush = (Brush)
                NTAppState.getMainWindow().TryFindResource("FavoritePanelBKBrush");
        }

        public void setDragOverBrush(bool isOver)
        {
            if (isOver)
            {
                if (mFavoriteDragOverBKBrush != null)
                    mButton.Background = mFavoriteDragOverBKBrush;
            }
            else
            {
                if (mFavoriteBKBrush != null)
                    mButton.Background = mFavoriteBKBrush;
            }
        }

        public string BoardName
        {
            get { return mBoardName; }
        }

        public void setButton (Button button){
            mButton = button;
            //button.MouseLeftButtonDown += button_MouseLeftButtonDown;
            button.PreviewMouseLeftButtonDown += button_PreviewMouseLeftButtonDown;
            button.PreviewMouseMove += button_PreviewMouseMove;
            //button.MouseLeftButtonUp += button_MouseLeftButtonUp;
            //button.MouseMove += button_MouseMove;            
        }



        public static List<string> getStringArray(List<NTFavoriteBoard> boardList)
        {
            List<string> list = new List<string>();
            foreach (NTFavoriteBoard fb in boardList)
            {
                list.Add(fb.mBoardName);
            }
            return list;
        }

        /*void button_MouseMove(object sender, System.Windows.Input.MouseEventArgs e)
        {
        }*/
        void button_PreviewMouseMove(object sender, System.Windows.Input.MouseEventArgs e)
        {
            if (!mMousePressed)
                return;

            Button btn = sender as Button;
            if (btn == null)
                return;

            Point point = e.GetPosition(btn);
            NTDebug.l("Point (" + point.X + "," + point.Y + ")");
            Vector v = Point.Subtract(point, mMouseObservePoint);
            if (v.Length > NTDragDrop.DRAG_START_MOVE_DELTA)
            {
                startDrag();
                e.Handled = true;
                mMousePressed = false;
            }
        }

        /*void button_MouseLeftButtonUp(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            mMousePressed = false;
        }

        void button_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
        }*/
        void button_PreviewMouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            //throw new NotImplementedException();
            Button btn = sender as Button;
            if (btn == null)
                return;

            mMousePressed = true;
            //e.Handled = true;
            mMouseObservePoint = e.GetPosition(btn);
        }
        void startDrag()
        {
            NTDebug.l("*** Drag Start!!! ***");
            NTDragDrop.BoardData data = new NTDragDrop.BoardData(mBoardName);
            DataObject dObj = new DataObject(NTDragDrop.BOARD_DRAG_DATA_FORMAT, data);

            DragDrop.DoDragDrop(mButton, dObj, DragDropEffects.All);
        }
    }
}
