﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using NT2chView.NtHtml;
using NT2chView.NtNet;

namespace NT2chView
{
    /// <summary>
    /// NTCreateThreadWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class NTCreateThreadWindow : Window
    {
        NTBoard mBoard;

        string mName;
        string mMail;
        string mTitle;
        string mMsg;
        bool mP2;

        bool  setUserInput(out string error)
        {
            error = string.Empty;

            mTitle = txtTitle.Text.Trim();
            if (mTitle.Length == 0)
            {
                error = "タイトルが指定されていません。";
                return false;
            }
            mName = txtName.Text.Trim();
            if (chkSage.HasContent && (bool)chkSage.IsChecked)
                mMail = "sage";
            else
                mMail = txtMail.Text.Trim();

            mMsg = txtMsg.Text;

            if (chkWriteTroughP2.HasContent && (bool)chkWriteTroughP2.IsChecked)
                mP2 = true;
            else
                mP2 = false;

            return true;
        }

        public NTCreateThreadWindow(NTBoard board, NTThreadTitle tt)
        {
            InitializeComponent();

            mBoard = board;

            if (tt != null)
            {
                string address = mBoard.mAddress;
                string hostName, boardName;
                if (NTHttpUtils.parseHostAddress(address, out hostName, out boardName))
                {
                    string title = tt.Title;
                    string dat = NTHttpUtils.ridSuffixFromDatName(tt.mDat);
                    StringBuilder sb = new StringBuilder();
                    sb.Append(title).Append("\r\n")
                        .Append("http://").Append(hostName).Append("/test/read.cgi/")
                        .Append(boardName).Append('/')
                        .Append(dat).Append("/\r\n");
                    txtTitle.Text = title;
                    txtMsg.Text = sb.ToString();

                }
            }
        }
        public NTCreateThreadWindow(NTBoard board, string title, string message)
        {
            InitializeComponent();

            mBoard = board;

            if(title != null)
                txtTitle.Text = title;

            if (message != null)
                txtMsg.Text = message;
        }

        private void btnCreateThread_Click(object sender, RoutedEventArgs e)
        {
            string error = string.Empty;

            if (!setUserInput(out error))
            {
                MessageBox.Show(error);
                return;
            }

            string retStr = null;
            if (mP2)
            {
                retStr = createThreadP2(out error);
            }
            else
            {
                retStr = createThread(out error, null);
            }
            if(retStr == null)
            {
                if (error.Length > 0) 
                    MessageBox.Show(error);
                //return;
            }
            Close();
            //return;
        }

        private void btnCreateThreadClose_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }

        private void chkSage_Unchecked(object sender, RoutedEventArgs e)
        {

        }

        private void chkSage_Checked(object sender, RoutedEventArgs e)
        {

        }

        private void chkWriteTroughP2_Checked(object sender, RoutedEventArgs e)
        {

        }

        private void chkWriteTroughP2_Unchecked(object sender, RoutedEventArgs e)
        {

        }

        string createThread(out string errorMsg, NTHtmlParser extra)
        {
            //bool bRet = false;
            string result = null;
            errorMsg = string.Empty;
            FlowDocument doc;

            Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

            string extraParam = null;
            if (NTUserPreference.MaruIsEnabled)
            {
                string sessionId = NTMaru.getSessionId();
                if (sessionId.Length > 0)
                {
                    extraParam = "&sid=" + sessionId;
                }
            }


            Mouse.OverrideCursor = Cursors.Wait;
            try
            {
                //string[] args = new string[7];
                string address = mBoard.mAddress;
                string hostName, boardName;

                if (!NTHttpUtils.parseHostAddress(address, out hostName, out boardName))
                {
                    throw new Exception();
                }

                string referer = "http://" + hostName + "/" + boardName;
                string url = "http://" + hostName + "/test/bbs.cgi";
                StringBuilder postData = new StringBuilder(256);

                if (extra == null)
                {
                    TimeSpan ts = new TimeSpan(0, 10, 0);
                    int time = NTHttpUtils.GetTime(DateTime.Now.Subtract(ts));

                    postData.Append("submit=").Append(HttpUtility.UrlEncode("新規スレッド作成画面へ", enc))
                    .Append("&bbs=").Append(boardName)
                    .Append("&time=").Append(time);
                    if (extraParam != null)
                        postData.Append(extraParam);
                    result = NTHttpAccess.createThread(url, referer, hostName, postData.ToString());

                    if (result == null)
                    {
                        errorMsg = "サーバーの応答が不正です";
                        return null;
                    }

                    doc = new FlowDocument();
                    NTHtmlParser parser = new NTHtmlParser(doc);
                    string resultHtml = parser.parse(result);
                    if (resultHtml == null)
                    {
                        errorMsg = "サーバーの応答が不正です";
                        return null;
                    }

                    postData.Remove(0, postData.Length);

                    if (parser.mInputTypeSubmit.Count == 0 || parser.mInputTypeHidden.Count == 0)
                    {
                        postData.Append("submit=").Append(HttpUtility.UrlEncode("新規スレッド作成", enc))
                            .Append("&bbs=").Append(boardName)
                            .Append("&time=").Append(time);
                        //errorMsg = "サーバーの応答が不正です";
                        //return null;
                    }
                    else
                    {
                        postData.Append(parser.mInputTypeSubmit[0].Key)
                            .Append('=')
                            .Append(HttpUtility.UrlEncode(parser.mInputTypeSubmit[0].Value, enc));
                    }
                    postData.Append("&subject=")
                        .Append(HttpUtility.UrlEncode(mTitle, enc))
                        .Append("&FROM=")
                        .Append(HttpUtility.UrlEncode(mName, enc))
                        .Append("&mail=")
                        .Append(HttpUtility.UrlEncode(mMail, enc))
                        .Append("&MESSAGE=")
                        .Append(HttpUtility.UrlEncode(mMsg, enc));



                    foreach (KeyValuePair<string, string> pair in parser.mInputTypeHidden)
                    {
                        postData.Append('&').Append(pair.Key)
                            .Append('=')
                            .Append(HttpUtility.UrlEncode(pair.Value, enc));
                    }

                    if (extraParam != null)
                        postData.Append(extraParam);
                }
                else
                {
                    if (extra.mInputTypeSubmit.Count == 0 || extra.mInputTypeHidden.Count == 0)
                    {
                        errorMsg = "サーバーの応答が不正です";
                        return null;
                    }

                    //postData = new StringBuilder();

                    postData.Append(extra.mInputTypeSubmit[0].Key)
                        .Append('=')
                        .Append(HttpUtility.UrlEncode(extra.mInputTypeSubmit[0].Value, enc));
                    foreach (KeyValuePair<string, string> pair in extra.mInputTypeHidden)
                    {
                        postData.Append('&').Append(pair.Key)
                            .Append('=')
                            .Append(HttpUtility.UrlEncode(pair.Value, enc));
                    }
                    if (extraParam != null)
                        postData.Append(extraParam);

                }

                result = NTHttpAccess.createThread(url, url, hostName, postData.ToString());

                if (result == null)
                {
                    errorMsg = "サーバーの応答が不正です";
                    return null;
                }
            }
            catch
            {
                return null;
            }
            finally
            {
                Mouse.OverrideCursor = null;
            }

            doc = new FlowDocument();
            NTHtmlParser htmlParser = new NTHtmlParser(doc);
            string parsedHtml = htmlParser.parse(result);
            if (parsedHtml == null)
            {
                errorMsg = "サーバーの応答が不正です";
                return null;
            }

            X_CONFIRM_RESULT xResult = NTHtmlWriteResParser.validateResult(htmlParser);
            if (xResult == X_CONFIRM_RESULT.SUCCESS)
                return result;

            NTDebug.l(parsedHtml);
            NTWriteResResultWindow w
                = new NTWriteResResultWindow(htmlParser.getTitle(), doc, xResult);
            w.Owner = this;
            bool? bRet = w.ShowDialog();

            if (bRet.HasValue && ((bool)bRet))
            {
                List<KeyValuePair<string, string>> list = htmlParser.mInputTypeSubmit;
                if (list.Count > 0)
                {
                    return createThread(out errorMsg, htmlParser);
                }
            }
            return result;
        }



        string createThreadP2(out string errorMsg)
        {
            //bool bRet = false;
            string result = null;
            errorMsg = string.Empty;

            Mouse.OverrideCursor = Cursors.Wait;
            try
            {
                string[] args = new string[7];
                string address = mBoard.mAddress;
                string hostName, boardName;

                if (!NTHttpUtils.parseHostAddress(address, out hostName, out boardName))
                {
                    throw new Exception();
                }
                args[0] = hostName;
                args[1] = boardName;
                args[2] = mName;
                args[3] = mMail;
                args[4] = mTitle;
                args[5] = mMsg;
                args[6] = "新規スレッド作成";

                result = NTHttpAccess.createThreadP2(args, null, false);

            }
            catch
            {
                return null;
            }
            finally
            {
                Mouse.OverrideCursor = null;
            }

            FlowDocument doc = new FlowDocument();
            NTHtmlParser htmlParser = new NTHtmlParser(doc);
            string parsedHtml = htmlParser.parse(result);
            if (parsedHtml == null)
            {
                errorMsg = "サーバーの応答が不正です";
                return null;
            }

            X_CONFIRM_RESULT xResult = NTHtmlWriteResParser.validateResult(htmlParser);
            if (xResult == X_CONFIRM_RESULT.SUCCESS)
                return result;

            NTDebug.l(parsedHtml);
            NTWriteResResultWindow w
                = new NTWriteResResultWindow(htmlParser.getTitle(), doc, xResult);
            w.Owner = this;
            bool? bRet = w.ShowDialog();

            if (bRet.HasValue && ((bool)bRet))
            {
                List<KeyValuePair<string, string>> list = htmlParser.mInputTypeSubmit;
                if (list.Count > 0)
                {
                    return createThreadP2(out errorMsg);
                }
            }
            return result;
        }





    }
}
