﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using NT2chView.NtFile;
using NT2chView.NtNet;

namespace NT2chView
{
    public sealed partial class NTBoard
    {
        private static object mLockUpdate = new object();
        private BackgroundWorker mUpdateBackgroundWorker = null;

        static void delDat_Worker(object o)
        {
            string[] s = o as string[];
            if (s == null)
                return;

            string result = NTHttpAccess.ntDeleteDatValue(s[0], s[1]);
            NTDebug.l(result);

        }

        private void NTBoardUpdate_DoWork(object sender,
            DoWorkEventArgs e)
        {
            lock (mLockUpdate)
            {
                mUpdateBackgroundWorker = null;
            }
            NTHttpAccess.getSubject(mAddress, mName);
            e.Result = true;

        }

        private void NTBoardUpdate_RunWorkerCompleted(
            object sender, RunWorkerCompletedEventArgs e)
        {
            

            lock (mLockUpdate)
            {
                string strSubject = NTFileAccess.retrieveSubjectDataFromFile(mName);

                if (null != strSubject)
                    parseSubjectData(strSubject, NTAppState.getMainWindow().getFavoriteData());

                if (NTUserPreference.NTCloudIsEnabled)
                {
                    BackgroundWorker bw = new BackgroundWorker();
                    bw.DoWork +=
                        new DoWorkEventHandler(NTCloudBoardUpdate_DoWork);
                    bw.RunWorkerCompleted += 
                        new RunWorkerCompletedEventHandler(
                            NTCloudBoardUpdate_RunWorkerCompleted);
                    bw.RunWorkerAsync();
                }
                else
                {
                    fireEvent();
                }

            }
            
        }

        private void fireEvent()
        {
            if (OnNotifyBoardUpdate != null)
                OnNotifyBoardUpdate(this);
            //mUpdateBackgroundWorker = null;
        }

        private void NTCloudBoardUpdate_DoWork(object sender,
            DoWorkEventArgs e)
        {
            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                string uid = NTUserPreference.NTCloudID;
                string passwd = NTUserPreference.NTUserCloudGetHashedPasswd();
                result = NTHttpAccess.UserCloudQueryReadCountList(uid, passwd, mName);
            }
            else
            {
                string uid = NTUserPreference.NTCloudID;
                string passwd = NTUserPreference.NTCloudPSS;
                result = NTHttpAccess.ntQueryReadCountList(uid, passwd, mName);
            }
            e.Result = result;
        }
        private void NTCloudBoardUpdate_RunWorkerCompleted(
            object sender, RunWorkerCompletedEventArgs e)
        {

            string resultHtml = e.Result as string;
            if (resultHtml != null)
            {
                QueryReadCountFromCloud(resultHtml);
            }
            lock (mLockUpdate)
            {
                fireEvent();
            }             
       }
    }
}
