﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Text;
using System.Threading;
using System.Windows;
using NT2chCtrl;
using NT2chView.NtFile;
using NT2chView.NtHtml;
using NT2chView.NtNet;
using NT2chObject;


namespace NT2chView
{
    public sealed partial class NTBoard : IBoard
    {
        public event DelegateMsgOnNotifyBoardUpdate OnNotifyBoardUpdate;
        public delegate void DelegateMsgOnNotifyBoardUpdate(NTBoard board);

        public string getName() { return mName; }
        public string getAddress() { return mAddress; }
        private object mObjExtra;
        public object getExtra() { return mObjExtra; }
        public void setExtra(object o) { mObjExtra = o; }
        public List<IThread> getThreadList()
        {
            if (mThreadTitleList == null)
                return null;
            List<IThread> list = new List<IThread>(mThreadTitleList.Count);
            foreach (NTThreadTitle tt in mThreadTitleList)
            {
                list.Add(tt);
            }
            return list;
        }
        

        public NTBoard(string name, string address)
        {
            mName = name;
            mAddress = address;
            mMachiBBS = NTHttpUtils.chkMachiBBSAddress(address);
        }

        public string mName;
        public string mAddress;
        public bool mMachiBBS;
        public ObservableCollection<NTThreadTitle> 
            mThreadTitleList = new ObservableCollection<NTThreadTitle>();
        public bool mDataInit = false;
        public List<string> mThreadListSortStack = new List<string>();

 
        public void delAllDat()
        {

            foreach (NTThreadTitle tt in mThreadTitleList)
            {

                //MainWindow wnd = NTAppState.getMainWindow();
                //wnd.removeThreadFromTabCtrl(tt);

                tt.clearLoadedDat();

                //NTFileAccess.deleteDatDir(mName, tt.mDat);
            }

            NTFileAccess.deleteBoardDir(mName);
            Thread th = new Thread(delDat_Worker);
            string[] s = new string[2];
            s[0] = mName;
            s[1] = "*";
            th.Start(s);

        }


        NTThreadTitle removeThreadFromList(string dat)
        {
            int length = mThreadTitleList.Count;
            for (int i = 0; i < length; i++ )
            {
                NTThreadTitle tt = mThreadTitleList[i];
                if (dat.Equals(tt.mDat))
                {
                    mThreadTitleList.RemoveAt(i);
                    return tt;
                }
            }
            return null;
        }

        public NTThreadTitle addExtraThread(string datName, string title)
        {
            NTThreadTitle tt = new NTThreadTitle(this);
            tt.SeqNo = mThreadTitleList.Count + 1;
            tt.mDat = datName;
            tt.Title = (title != null) ? title : string.Empty;
            tt.ResCnt = 0;
            tt.ReadCnt = 0;
            tt.RemainCnt = 0;
            tt.LastMod = string.Empty;
            tt.mLocalDat = true;
            mThreadTitleList.Add(tt);

            return tt;
        }
        public bool parseSubjectData(string source, NTFavorite favorite)
        {
            bool result;

            if (mMachiBBS)
                result = parseMachiSubjectData(source);
            else
                result = parseSubjectData1(source);

            if (favorite != null && mThreadTitleList != null)
            {
                foreach (NTThreadTitle tt in mThreadTitleList)
                {
                    if (0 > favorite.findThread(
                        tt.getBoard().getName(), tt.getDatName(), tt.getTitle()))
                    {
                        tt.IsFavorite = false;
                    }
                    else
                    {
                        tt.IsFavorite = true;
                    }
                }
            }
            return result;
        }

        private bool parseSubjectData1(string source)
        {

            bool bRet = false;
            try
            {

                List<string> datList = NTFileAccess.getStoredDat(mName);

                string[] lines = NTTextUtiles.splitLine(source);

                //mThreadTitleList.Clear();
                List<NTThreadTitle> newList = new List<NTThreadTitle>();
                int seqNo = 1;
                foreach (string s in lines)
                {
                    int n1 = s.IndexOf("<>");
                    if (n1 < 0)
                        continue;
                    int n2 = s.LastIndexOf('(');
                    int n3 = s.LastIndexOf(')');
                    if (n2 < 0 || n3 < 0 || n2 >= n3)
                        continue;
                    n2++;
                    string strResCnt = s.Substring(n2, n3 - n2);
                    int nResCnt = Int32.Parse(strResCnt);
                    string dat = s.Substring(0, n1);
                    n1 += 2;
                    string title = NTHtmlUtils.parseHTMLEscape(s.Substring(n1, n2 - n1 - 1));
                    NTThreadTitle tt = removeThreadFromList(dat);
                    if(tt == null)
                        tt = new NTThreadTitle(this);
                    tt.SeqNo = seqNo++;
                    tt.mDat = dat;
                    tt.Title = title;
                    tt.ResCnt = nResCnt;
                    tt.ReadCnt = 0;
                    tt.RemainCnt = 0;// nResCnt;
                    tt.LastMod = string.Empty;
                    if (!NTUserPreference.NTShowOnlyCloudReadCount)
                    {
                        int numRead;
                        int[] writes;
                        int[] bookmarkes;
                        string lastWrite;
                        if (NTFileAccess.retrieveDatAttrToFile(mName, tt.mDat,
                            out numRead, out writes, out bookmarkes, out lastWrite))
                        {
                            tt.ReadCnt = numRead;
                            tt.LastMod = lastWrite;
                        }
                    }
                    dat = NTHttpUtils.ridSuffixFromDatName(dat);
                    foreach (string oldDat in datList)
                    {
                        if (dat.Equals(oldDat))
                        {
                            datList.Remove(oldDat);
                            break;
                        }
                    }
                    newList.Add(tt);
                }
#if true
                foreach (NTThreadTitle tt in mThreadTitleList)
                {
                    newList.Add(tt);
                }
#endif
                mThreadTitleList.Clear();
                foreach(NTThreadTitle tt in newList)
                    mThreadTitleList.Add(tt);

                foreach (string localDatName in datList)
                {
                    string[] attr = NTFileAccess.retrieveDatAttrBinFromFile(
                                    this.mName, localDatName);
                    if (attr == null || attr.Length < 1)
                        continue;
                    NTThreadTitle tt = removeThreadFromList(localDatName);
                    if (tt == null)
                        tt = new NTThreadTitle(this, true);
                    tt.SeqNo = seqNo++;
                    tt.mDat = localDatName;
                    tt.Title = "[DAT落] "+attr[0];
                    int numRead;
                    int[] writeIndexies;
                    int[] bookmarkedIndexies;
                    string lastMod;
                    if (NTFileAccess.retrieveDatAttrToFile(mName, localDatName, 
                        out numRead, out writeIndexies, out bookmarkedIndexies, out lastMod))
                    {
                        tt.ResCnt = numRead;
                        tt.ReadCnt = numRead;
                    }
                    //tt.RemainCnt = 0;
                    tt.LastMod = string.Empty;
                    mThreadTitleList.Add(tt);
                }

                bRet = true;

               
            }
            catch(Exception e)
            {
                NTDebug.l(e.Message);

            }
            return mDataInit = bRet;
        }


        private bool parseMachiSubjectData(string source)
        {
           
            bool bRet = false;
            try
            {

                List<string> datList = NTFileAccess.getStoredDat(mName);

                string[] lines = NTTextUtiles.splitLine(source);

                //mThreadTitleList.Clear();
                List<NTThreadTitle> newList = new List<NTThreadTitle>();
                int seqNo = 1;
                foreach (string s in lines)
                {
                    int n1 = s.IndexOf(",");
                    if (n1 < 0)
                        continue;
                    int n2 = s.LastIndexOf('(');
                    int n3 = s.LastIndexOf(')');
                    if (n2 < 0 || n3 < 0 || n2 >= n3)
                        continue;
                    n2++;
                    string strResCnt = s.Substring(n2, n3 - n2);
                    int nResCnt = Int32.Parse(strResCnt);
                    string dat = s.Substring(0, n1);
                    n1 += 1;
                    string title = NTHtmlUtils.parseHTMLEscape(s.Substring(n1, n2 - n1 - 1));
                    NTThreadTitle tt = removeThreadFromList(dat);
                    if (tt == null)
                        tt = new NTThreadTitle(this);
                    tt.SeqNo = seqNo++;
                    tt.mDat = dat;
                    tt.Title = title;
                    tt.ResCnt = nResCnt;
                    tt.ReadCnt = 0;
                    tt.RemainCnt = 0;// nResCnt;
                    tt.LastMod = string.Empty;
                    if (!NTUserPreference.NTShowOnlyCloudReadCount)
                    {
                        int numRead;
                        int[] writes;
                        int[] bookmarkes;
                        string lastWrite;
                        if (NTFileAccess.retrieveDatAttrToFile(mName, tt.mDat,
                            out numRead, out writes, out bookmarkes, out lastWrite))
                        {
                            tt.ReadCnt = numRead;
                            tt.LastMod = lastWrite;
                        }
                    }
                    dat = NTHttpUtils.ridSuffixFromCgiName(dat);
                    foreach (string oldDat in datList)
                    {
                        if (dat.Equals(oldDat))
                        {
                            datList.Remove(oldDat);
                            break;
                        }
                    }
                    newList.Add(tt);
                }
                foreach (NTThreadTitle tt in mThreadTitleList)
                {
                    newList.Add(tt);
                }
                mThreadTitleList.Clear();
                foreach (NTThreadTitle tt in newList)
                    mThreadTitleList.Add(tt);

                foreach (string localDatName in datList)
                {
                    string[] attr = NTFileAccess.retrieveDatAttrBinFromFile(
                                    this.mName, localDatName);
                    if (attr == null || attr.Length < 1)
                        continue;
                    NTThreadTitle tt = removeThreadFromList(localDatName);
                    if (tt == null)
                        tt = new NTThreadTitle(this, true);
                    tt.SeqNo = seqNo++;
                    tt.mDat = localDatName;
                    tt.Title = "[DAT落] " + attr[0];
                    int numRead;
                    int[] writeIndexies;
                    int[] bookmarkedIndexies;
                    string lastMod;
                    if (NTFileAccess.retrieveDatAttrToFile(mName, localDatName,
                        out numRead, out writeIndexies, out bookmarkedIndexies, out lastMod))
                    {
                        tt.ResCnt = numRead;
                        tt.ReadCnt = numRead;
                    }
                    //tt.RemainCnt = 0;
                    tt.LastMod = string.Empty;
                    mThreadTitleList.Add(tt);
                }
                bRet = true;


            }
            catch
            {
            }
            return mDataInit = bRet;
        }
 
        
        
        public NTThreadTitle findThreadTitleByDatName(string datName)
        {
            foreach (NTThreadTitle tt in mThreadTitleList)
            {
                if (datName.Equals(tt.mDat))
                {
                    return tt;
                }
            }
            return null;
        }

        public NTThreadTitle findThreadTitleByTitle(string title)
        {
            foreach (NTThreadTitle tt in mThreadTitleList)
            {
                if (title.Equals(tt.Title))
                {
                    return tt;
                }
            }
            return null;
        }

        public void Update(DelegateMsgOnNotifyBoardUpdate notifyUpdate)
        {
            lock (mLockUpdate)
            {
                if (/*OnNotifyBoardUpdate != null &&*/ notifyUpdate != null)
                {
                    OnNotifyBoardUpdate += notifyUpdate;
                }
                if (mUpdateBackgroundWorker != null)
                    return;

                mUpdateBackgroundWorker = new BackgroundWorker();
                mUpdateBackgroundWorker.DoWork += new DoWorkEventHandler(NTBoardUpdate_DoWork);
                mUpdateBackgroundWorker.RunWorkerCompleted +=
                    new RunWorkerCompletedEventHandler(NTBoardUpdate_RunWorkerCompleted);
                mUpdateBackgroundWorker.RunWorkerAsync();
            }
        }

        //public void NotifyThreadUpdate()
        //{
        //    if (OnNotifyBoardUpdate != null)
        //        OnNotifyBoardUpdate(this);
       // }



        private void QueryReadCountFromCloud(string resultHtml)
        {
            //string uid = NTUserPreference.NTCloudID;
            //string passwd = NTUserPreference.NTCloudPSS;

            //string result = NTHttpAccess.ntQueryReadCountList(uid, passwd, mName);
            if (resultHtml != null)
            {
                string [] lines = NTTextUtiles.splitLine(resultHtml);
                foreach (string line  in lines)
                {
                    string dat;
                    int seqNo, type;
                    DateTime dt;
                    int ret = parseReadCntList(line, out dat, out seqNo, out type, out dt);
                    if (ret < 3)
                        continue;
                    foreach (NTThreadTitle thread in mThreadTitleList)
                    {
                        if (dat.Equals(thread.mDat))
                        {
                            switch (type)
                            {
                                case 1:
                                case 4:
                                    if (thread.ReadCnt < seqNo)
                                        thread.ReadCnt = seqNo;
                                    if (ret > 3)
                                    {
                                        if (0 == thread.LastMod.Length)

                                        {
                                            thread.LastMod = dt.ToString();
                                        }
                                        else
                                        {
                                            DateTime dt2;
                                            if (DateTime.TryParse(thread.LastMod, out dt2))
                                            {
                                                if (0 < DateTime.Compare(dt, dt2))
                                                    thread.LastMod = dt.ToString();
                                            }
                                        }
                                    }
                                    break;
                                case 2:
                                case 5:
                                    if (ret > 3)
                                    {
                                        if (thread.LastWrite.Length == 0)
                                        {
                                            thread.LastWrite = dt.ToString();
                                        }
                                        else
                                        {
                                            DateTime dt2;
                                            if (DateTime.TryParse(thread.LastWrite, out dt2))
                                            {
                                                if (0 < DateTime.Compare(dt, dt2))
                                                    thread.LastWrite = dt.ToString();
                                            }
                                        }
                                    }
                                    break;
                            }//End switch
                            break;
                        }//End if 
                    }//End foreach
                }
            }
        }
#if false
        public void aaa_QueryReadCountFromCloudAsync()
        {
                BackgroundWorker bw = new BackgroundWorker();
                bw.DoWork += new DoWorkEventHandler(NTBoard_DoWork);
                bw.RunWorkerCompleted += 
                    new RunWorkerCompletedEventHandler(NTBoard_RunWorkerCompleted);
                
                bw.RunWorkerAsync();
        }

 
        private void NTBoard_DoWork(object sender,
            DoWorkEventArgs e)
        {
            //NTBoard board = e.Argument as NTBoard;
            //if (board == null)
            //    return;

            string uid = NTUserPreference.NTCloudID;
            string passwd = NTUserPreference.NTCloudPSS;

            string result = NTHttpAccess.ntQueryReadCountList(uid, passwd, mName);

            e.Result = result;

            NTDebug.l("Entering NTBoard_DoWork: " + mName);

            //Thread.Sleep(2000);

            // Get the BackgroundWorker that raised this event.
            //BackgroundWorker worker = sender as BackgroundWorker;
            // Assign the result of the computation
            // to the Result property of the DoWorkEventArgs
            // object. This is will be available to the 
            // RunWorkerCompleted eventhandler.
            //e.Result = null;/// ComputeFibonacci((int)e.Argument, worker, e);
        }

        private void NTBoard_RunWorkerCompleted(
            object sender, RunWorkerCompletedEventArgs e)
        {
            //e.
            //NTBoard board = e.Argument as NTBoard;
            //if (board != null)
            //    NTDebug.l(board.mName);
                


            NTDebug.l("Entering NTBoard_RunWorkCompleted: " + this.mName);
            // First, handle the case where an exception was thrown.
            if (e.Error != null)
            {
                MessageBox.Show(e.Error.Message);
            }
            else if (e.Cancelled)
            {

            }
            else
            {
                string result = e.Result as string;
                if (result != null)
                {

                    string [] lines = NTTextUtiles.splitLine(result);
                    foreach (string line  in lines)
                    {
                        string dat;
                        int seqNo, type;
                        DateTime dt;
                        int ret = parseReadCntList(line, out dat, out seqNo, out type, out dt);
                        if (ret < 3)
                            continue;
                        foreach (NTThreadTitle thread in mThreadTitleList)
                        {
                            if (dat.Equals(thread.mDat))
                            {
                                switch (type)
                                {
                                    case 1:
                                        if (thread.ReadCnt < seqNo)
                                            thread.ReadCnt = seqNo;
                                        if (ret > 3)
                                        {
                                            if (0 == thread.LastMod.Length)

                                            {
                                                thread.LastMod = dt.ToString();
                                            }
                                            else
                                            {
                                                DateTime dt2;
                                                if (DateTime.TryParse(thread.LastMod, out dt2))
                                                {
                                                    if (0 < DateTime.Compare(dt, dt2))
                                                        thread.LastMod = dt.ToString();
                                                }
                                            }
                                        }
                                        break;
                                    case 2:
                                        if (ret > 3)
                                        {
                                            if (thread.LastWrite.Length == 0)
                                            {
                                                thread.LastWrite = dt.ToString();
                                            }
                                            else
                                            {
                                                DateTime dt2;
                                                if (DateTime.TryParse(thread.LastWrite, out dt2))
                                                {
                                                    if (0 < DateTime.Compare(dt, dt2))
                                                        thread.LastWrite = dt.ToString();
                                                }
                                            }
                                        }
                                        break;
                                }//End switch
                                break;
                            }//End if 
                        }//End foreach
                    }
                }
            }
        }
#endif
        static int parseReadCntList(string source, 
            out string datName, out int seqNo, out int type, out DateTime dt)
        {
            datName = null;
            seqNo = -1;
            type = -1;
            dt = DateTime.MinValue;
            int retVal = -1;

            try
            {
                
                string[] values = source.Split(NTTextUtiles.COMMA_VALUE);
                retVal = values.Length;
                if (retVal < 3)
                    return -1;
                for (int i = 0; i < values.Length; i++)
                {
                    string s = values[i];
                    switch (i)
                    {
                        case 0:
                            if(NTUserPreference.AESEnabled)
                                datName = NTTextUtiles.aesDecodeBase64URL(s);
                            else
                                datName = NTTextUtiles.decodeBase64URL(s);
                            break;
                        case 1:
                            seqNo = int.Parse(s);
                            break;
                        case 2:
                            type = int.Parse(s);
                            break;
                        case 3:
                            dt = DateTime.Parse(s);
                            break;
                    }
            
                }
            }
            catch(Exception e)
            {
                NTDebug.l(e.Message);
                return -1;
            }
            return retVal;

        }



    }
}
