﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows.Controls;

namespace NT2chView
{
    partial class MainWindow
    {
        public delegate void DelegateMsgOpenBoardListRequest(NTCategory category);
        public delegate void DelegateMsgOpenFavoriteListRequest(NTFavorite favorite);
        public delegate void DelegateMsgOpenThreadTitleListRequest(NTBoard board);
        public delegate void DelegateMsgOpenThreadTitleListRequest2(string boardName);
        public delegate void DelegateMsgOpenThreadRequest(NTThreadTitle tt);
        public delegate void DelegateMsgGetHistoryOnCloud(int type);

        void MsgOpenBoardListRequest(NTCategory category)
        {
            mBoardPanel.BoardTable = category.mBoardList;
            mBoardPanel.Visibility = System.Windows.Visibility.Visible;
            mFavoritePanel.Visibility = System.Windows.Visibility.Hidden;
        }

        void MsgOpenFavoriteListRequest(NTFavorite favorite)
        {
            mFavoritePanel.Visibility = System.Windows.Visibility.Visible;
            mBoardPanel.Visibility = System.Windows.Visibility.Hidden;
        }

        void MsgOpenThreadtitleListRequest(NTBoard board)
        {
            if (board == null)
                return;

            if(board.mDataInit)
                mSubjectPanel.OpenBoard(board);
            else
                board.Update(mOnNotifyBoardUpdate);

            /*constructBoardTabItem(board);
            TabItem tabitem = searchBoardFromTabItem(board);
            if (tabitem != null)// || tabitem.Tag == null)
            {
                if (tabitem.Tag != null)
                {
                    constructBoardTabItemContent(board, tabitem);
                    int num = tabCtrlSubject.Items.Count;
                    if (num > 0)
                    {
                        tabCtrlSubject.SelectedIndex = num - 1;
                    }
                }
                else
                {
                    board.Update(mOnNotifyBoardUpdate);
                }
            }*/
        }
        void MsgOpenThreadtitleListRequest2(string boardName)
        {
            if (boardName == null)
                return;

            NTBoard board = NTDataRoot.getBoardByName(boardName);
            if (board == null)
                return;

            MsgOpenThreadtitleListRequest(board);
        }

        void MsgOpenThreadRequest(NTThreadTitle tt)
        {
            OpenNewThread(tt);
        }

        void MsgGetHistoryOnCloud(int type)
        {
            Thread thread;
            switch (type)
            {
                case 1:
                    thread = new Thread(getReadHistoryOnCloud);
                    break;
                case 2:
                    thread = new Thread(getWriteHistoryOnCloud);
                    break;
                case 3:
                    thread = new Thread(getBookmarkHistoryOnCloud);
                    break;
                default:
                    return;
            }
            thread.Start();
        }

    }
}
