﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.js
{
    public class JsFunctionContext
    {
        protected static Dictionary<string, JsVariant>
            mGlobalVariables = new Dictionary<string, JsVariant>();
        protected Dictionary<string, JsVariant>
            mLocalVariables = new Dictionary<string, JsVariant>();

        private DebugContext mDbgCtx;
        public void setDbgCtx(DebugContext dbgCtx)
        {
            mDbgCtx = dbgCtx;
        }
        public DebugContext getDbgCtx() { return mDbgCtx; }

        public JsFunctionContext(DebugContext dCtx)
        {
            setDbgCtx(dCtx);
        }

        public bool getMemoryList(out List<DebugMemory> list)
        {
            list = new List<DebugMemory>();
            foreach (string key in mGlobalVariables.Keys)
            {
                JsVariant var;
                if (mGlobalVariables.TryGetValue(key, out var))
                {
                    list.Add(DebugMemory.createInstance(key, var, false));
                }
            }
            foreach (string key in mLocalVariables.Keys)
            {
                JsVariant var;
                if (mLocalVariables.TryGetValue(key, out var))
                {
                    list.Add(DebugMemory.createInstance(key, var, true));
                }
            }

            return true;
        }
        public JsFunctionContext() { }

        public JsVariant getValue(JsIdentifier id)
        {
            return getValue(id.getName(), id.isLocal());
        }

        public JsVariant getValue(string name, bool local)
        {
            JsVariant value;
            if (mLocalVariables.TryGetValue(name, out value))
            {
                return value;
            }

            if (local)
            {
                value = new JsUndefValue();
                mLocalVariables.Add(name, value);
                return value;
            }
            if (mGlobalVariables.TryGetValue(name, out value))
            {
                return value;
            }
            value = new JsUndefValue();
            mGlobalVariables.Add(name, value);
            return value;
        }
        public void setValue(JsIdentifier id, JsVariant value)
        {
            setValue(id.getName(), id.isLocal(), value);
        }

        public void setValue(string name, bool local, JsVariant inValue)
        {
            if (mLocalVariables.ContainsKey(name))
            {
                mLocalVariables.Remove(name);
                mLocalVariables.Add(name, inValue);
                return;
            }
            if (local)
            {
                mLocalVariables.Add(name, inValue);
                return;
            }
            if (mGlobalVariables.ContainsKey(name))
            {
                mGlobalVariables.Remove(name);
                mGlobalVariables.Add(name, inValue);
                return;
            }
            mGlobalVariables.Add(name, inValue);
        }

        public JsVariant getParamValue(HtmlElement elem, JsVariant val)
        {
            if (val == null)
                return null;
            JsFunction func = val as JsFunction;
            if (func != null)
            {
                val = func.Execute(this, elem);
                if (val == null)
                    return null;
            }
            JsIdentifier id = val as JsIdentifier;
            if (id != null)
            {
                val = getValue(id);
            }
            func = val as JsFunction;
            if (func != null)
            {
                return getParamValue(elem, val);
            }
            return val;

        }
    }
}
