﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.js
{
    class JsCmpFunction : JsFunction
    {
        JsVariant mLhsValue;
        JsVariant mRhsValue;
        JsToken mOpToken;

        public JsCmpFunction(int lineNo, int srcIdx, JsToken opToken)
            : base(lineNo, srcIdx)
        {
            mOpToken = opToken;
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_COMPARE;
        }

        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (count < 3 || count <= (currIdx + 1))
                return false;

            mRhsValue = insList[currIdx + 1];
            mLhsValue = insList[currIdx - 1];
            insList.RemoveAt(currIdx + 1);
            insList.RemoveAt(currIdx - 1);
            mArranged = true;
            return true;
        }

        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);

            JsVariant lhs = ctx.getParamValue(rootElement, mLhsValue);
            JsVariant rhs = ctx.getParamValue(rootElement, mRhsValue);

            switch (mOpToken)
            {
                case JsToken.KEY_OP_CMP_EQUAL:
                    return cmpEqual(lhs, rhs);
                case JsToken.KEY_OP_CMP_STRICT_EQUAL:
                    return cmpStrictEqual(lhs, rhs);
                case JsToken.KEY_OP_CMP_NOT_EQUAL:
                    return cmpNotEqual(lhs, rhs);
                case JsToken.KEY_OP_CMP_STRICT_NOT_EQUAL:
                    return cmpStrictNotEqual(lhs, rhs);
                case JsToken.KEY_OP_CMP_LT:
                case JsToken.KEY_OP_CMP_GT:
                case JsToken.KEY_OP_CMP_LT_EQUAL:
                case JsToken.KEY_OP_CMP_GT_EQUAL:
                    return cmpValues(mOpToken, lhs, rhs);
            }
            return null;
        }

        private JsVariant cmpValues(JsToken token, JsVariant lhs, JsVariant rhs)
        {
            JsNumberValue nVal1 = lhs.getNumberValue();
            if (nVal1 == null)
                return null;

            JsNumberValue nVal2 = rhs.getNumberValue();
            if (nVal2 == null)
                return null;
            double d1 = nVal1.getValue();
            double d2 = nVal2.getValue();
            switch (mOpToken)
            {
                case JsToken.KEY_OP_CMP_LT:
                    return JsBooleanValue.getConstantValue(d1 < d2);
                case JsToken.KEY_OP_CMP_GT:
                    return JsBooleanValue.getConstantValue(d1 > d2);
                case JsToken.KEY_OP_CMP_LT_EQUAL:
                    return JsBooleanValue.getConstantValue(d1 <= d2);
                case JsToken.KEY_OP_CMP_GT_EQUAL:
                    return JsBooleanValue.getConstantValue(d1 >= d2);
            }
            return null;
        }

        private JsVariant cmpStrictNotEqual(JsVariant lhs, JsVariant rhs)
        {
            JsBooleanValue bVal = cmpStrictEqual(lhs, rhs) as JsBooleanValue;
            if (bVal != null)
            {
                if (bVal.getValue())
                    return JsBooleanValue.getFalseValue();
                else
                    return JsBooleanValue.getTrueValue();
            }
            return null;
        }

        private JsVariant cmpStrictEqual(JsVariant lhs, JsVariant rhs)
        {
            JsNumberValue nVal1, nVal2;
            JsStringValue sVal1, sVal2;
            string s1, s2;

            if (lhs == null || rhs == null)
                return null;

            if (lhs is JsNullValue)
            {
                return JsBooleanValue.getConstantValue(rhs is JsNullValue);
            }
            if (rhs is JsNullValue)
            {
                return JsBooleanValue.getConstantValue(lhs is JsNullValue);
            }
            if (lhs is JsUndefValue)
            {
                return JsBooleanValue.getConstantValue(rhs is JsNullValue);
            }
            if (rhs is JsUndefValue)
            {
                return JsBooleanValue.getConstantValue(lhs is JsUndefValue);
            }

            nVal1 = lhs as JsNumberValue;
            if (nVal1 != null)
            {
                if (!(rhs is JsNumberValue))
                    return JsBooleanValue.getFalseValue();
                nVal2 = rhs.getNumberValue();
                if (nVal2 == null)
                    return JsBooleanValue.getFalseValue();
                return JsBooleanValue.getConstantValue(nVal1.getValue() == nVal2.getValue());
            }
            nVal1 = rhs as JsNumberValue;
            if (nVal1 != null)
            {
                if (!(lhs is JsNumberValue))
                    return JsBooleanValue.getFalseValue();
                nVal2 = lhs.getNumberValue();
                if (nVal2 == null)
                    return JsBooleanValue.getFalseValue();
                return JsBooleanValue.getConstantValue(nVal1.getValue() == nVal2.getValue());
            }
            sVal1 = lhs as JsStringValue;
            if (sVal1 != null)
            {
                if (!(rhs is JsStringValue))
                    return JsBooleanValue.getFalseValue();
                sVal2 = rhs.getStringValue();
                if (sVal2 == null)
                    return JsBooleanValue.getFalseValue();
                s1 = sVal1.getValue();
                s2 = sVal2.getValue();
                if (s1 == null || s2 == null)
                    return JsBooleanValue.getFalseValue();
                return JsBooleanValue.getConstantValue(s1.Equals(s2));
            }
            sVal1 = rhs as JsStringValue;
            if (sVal1 != null)
            {
                if (!(lhs is JsStringValue))
                    return JsBooleanValue.getFalseValue();
                sVal2 = lhs.getStringValue();
                if (sVal2 == null)
                    return JsBooleanValue.getFalseValue();
                s1 = sVal1.getValue();
                s2 = sVal2.getValue();
                if (s1 == null || s2 == null)
                    return JsBooleanValue.getFalseValue();
                return JsBooleanValue.getConstantValue(s1.Equals(s2));
            }
            return null;
        }
        private JsVariant cmpNotEqual(JsVariant lhs, JsVariant rhs)
        {
            JsBooleanValue bVal = cmpEqual(lhs, rhs) as JsBooleanValue;
            if (bVal != null)
            {
                if (bVal.getValue())
                    return JsBooleanValue.getFalseValue();
                else
                    return JsBooleanValue.getTrueValue();
            }
            return null;
        }

        private JsVariant cmpEqual(JsVariant lhs, JsVariant rhs)
        {
            JsNumberValue nVal1, nVal2;
            JsStringValue sVal1, sVal2;
            string s1, s2;

            if (lhs == null || rhs == null)
                return null;

            if (lhs is JsNullValue || lhs is JsUndefValue)
            {
                if (rhs is JsNullValue || rhs is JsUndefValue)
                    return JsBooleanValue.getTrueValue();
                if (rhs is JsNumberValue)
                {
                    double d = ((JsNumberValue)rhs).getValue();
                    return JsBooleanValue.getConstantValue(d == 0);
                }
                return JsBooleanValue.getFalseValue();
            }
            if (rhs is JsNullValue || rhs is JsUndefValue)
            {
                if (lhs is JsNullValue || lhs is JsUndefValue)
                    return JsBooleanValue.getTrueValue();
                if (lhs is JsNumberValue)
                {
                    double d = ((JsNumberValue)lhs).getValue();
                    return JsBooleanValue.getConstantValue(d == 0);
                }
                return JsBooleanValue.getFalseValue();
            }

            nVal1 = lhs as JsNumberValue;
            if (nVal1 != null)
            {
                nVal2 = rhs.getNumberValue();
                if (nVal2 == null)
                    return JsBooleanValue.getFalseValue();
                return JsBooleanValue.getConstantValue(nVal1.getValue() == nVal2.getValue());
            }
            nVal1 = rhs as JsNumberValue;
            if (nVal1 != null)
            {
                nVal2 = lhs.getNumberValue();
                if (nVal2 == null)
                    return JsBooleanValue.getFalseValue();
                return JsBooleanValue.getConstantValue(nVal1.getValue() == nVal2.getValue());
            }
            sVal1 = lhs as JsStringValue;
            if (sVal1 != null)
            {
                sVal2 = rhs.getStringValue();
                if (sVal2 == null)
                    return JsBooleanValue.getFalseValue();
                s1 = sVal1.getValue();
                s2 = sVal2.getValue();
                if (s1 == null || s2 == null)
                    return JsBooleanValue.getFalseValue();
                return JsBooleanValue.getConstantValue(s1.Equals(s2));
            }
            sVal1 = rhs as JsStringValue;
            if (sVal1 != null)
            {
                sVal2 = lhs.getStringValue();
                if (sVal2 == null)
                    return JsBooleanValue.getFalseValue();
                s1 = sVal1.getValue();
                s2 = sVal2.getValue();
                if (s1 == null || s2 == null)
                    return JsBooleanValue.getFalseValue();
                return JsBooleanValue.getConstantValue(s1.Equals(s2));
            }
            return null;
        }






    }
}
