﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.css
{
    public class cssLength
    {
        const double ONE_INCH_CM = 2.54;
        const double ONE_INCH_MM = 25.4;
        const double SCREEN_DPI = 96;
 
        private static double mBaseLength = 14; 
        //public static void init(double baseFontLength)
        //{
        //    mBaseLength = baseFontLength;
        //}

        public static double getLength(string source)
        {
            return getLength(source, null);
        }

        public static double getLength(string source, double? fontSize)
        {
            int state = 0;
            int numberStartIdx = 0;
            int length = source.Length;
            double resultLength;
            bool fraction = false;
            bool zeroSuppress = false;
            int nVal;
            double dVal;
            string numberStr;

            if (source == null)
                return double.NaN;

            for (int i = 0; i < length; i++)            
            {
                char c = source[i];
                switch (HtmlParser.getCharToken(c))
                {
                    case HtmlParser.CHAR_TOKEN.NUMBER:
                        if (state == 0)
                        {
                            state = 1;
                            numberStartIdx = i;
                        }
                        else if (state != 1)
                        {
                            return double.NaN;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.PERIOD:
                        if (state == 0)
                        {
                            state = 1;
                            numberStartIdx = i;
                            zeroSuppress = true;
                        }
                        else if (state != 1)
                        {
                            return double.NaN;
                        }
                        fraction = true;
                        break;
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                    case HtmlParser.CHAR_TOKEN.NL:
                        if (state != 0)
                            return double.NaN;
                        break;
                    //case HtmlParser.CHAR_TOKEN.OTHER:
                    default:
                        if (state != 1)
                            return double.NaN;
                        numberStr = source.Substring(numberStartIdx, i - numberStartIdx);
                        if (fraction)
                        {
                            if (zeroSuppress)
                                numberStr = "0" + numberStr;
                            if (!double.TryParse(numberStr, out dVal))
                                return double.NaN;
                        }
                        else
                        {
                            if (!int.TryParse(numberStr, out nVal))
                                return double.NaN;
                            else
                                dVal = nVal;

                        }
                        if (tryParseCSSLength(dVal, source, i, out resultLength, fontSize))
                            return resultLength;
                        else
                            return double.NaN;
                }
            }
            return double.NaN;
        }

        public static bool tryParseCSSLength(double length , string source,
            int startIdx, out double outLength, double? fontSize)
        {
            outLength = double.NaN;
            bool bRet = true;

            double baseLength;
            if (!fontSize.HasValue || fontSize == double.NaN)
            {
                baseLength = mBaseLength;
            }
            else
            {
                baseLength = (double)fontSize;
            }

            if (startIdx == source.IndexOf("in", startIdx))
            {
                //in (inches)
                outLength = length / SCREEN_DPI;
            }
            else if (startIdx == source.IndexOf("cm", startIdx))
            {
                //cm (centimeters)
                outLength = length * SCREEN_DPI / ONE_INCH_CM;                
            }
            else if (startIdx == source.IndexOf("mm", startIdx))
            {
                //mm (millimeters)
                outLength = length * SCREEN_DPI / ONE_INCH_MM;
            }
            else if (startIdx == source.IndexOf("pt", startIdx))
            {
                //pt (point 1/72 of an inch)
                outLength = length * SCREEN_DPI / 72;
            }
            else if (startIdx == source.IndexOf("pc", startIdx))
            {
                //pc (picas 12 points)
                outLength = length * SCREEN_DPI / 72 / 12;
            }
            else if (startIdx == source.IndexOf("em", startIdx))
            {
                //em font size
                outLength = baseLength * length;
            }
            else if (startIdx == source.IndexOf("ex", startIdx))
            {
                //ex x-height of font (approximately 0.5em)
                outLength = baseLength * length / 2;
            }
            else if (startIdx == source.IndexOf("rem", startIdx))
            {
                //rem root elements font size
                outLength = mBaseLength * length;
            }
            else if (startIdx == source.IndexOf("px", startIdx))
            {
                //px (96dpi)
                outLength = length;
            }
            else if (startIdx == source.IndexOf("%", startIdx))
            {
                //% percentage of another property
                outLength = baseLength * length / 100;
            }
            else
            {
                bRet = false;
            }
            return bRet;
        }
    }
}
